/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.uihandler.LogRecords;
import org.netbeans.lib.uihandler.PasswdEncryption;
import org.netbeans.modules.exceptions.ExceptionsSettings;
import org.netbeans.modules.exceptions.ReportPanel;
import org.netbeans.modules.exceptions.ReporterResultTopComponent;
import org.netbeans.modules.uihandler.BuildInfo;
import org.netbeans.modules.uihandler.ButtonsParser;
import org.netbeans.modules.uihandler.CPUInfo;
import org.netbeans.modules.uihandler.DataConsistentFileOutputStream;
import org.netbeans.modules.uihandler.EarlyHandler;
import org.netbeans.modules.uihandler.MetricsHandler;
import org.netbeans.modules.uihandler.ReminderPanel;
import org.netbeans.modules.uihandler.ScreenSize;
import org.netbeans.modules.uihandler.SelfSampleVFS;
import org.netbeans.modules.uihandler.SlownessData;
import org.netbeans.modules.uihandler.SubmitPanel;
import org.netbeans.modules.uihandler.TimeToFailure;
import org.netbeans.modules.uihandler.UIHandler;
import org.netbeans.modules.uihandler.UINode;
import org.netbeans.modules.uihandler.api.Activated;
import org.netbeans.modules.uihandler.api.Deactivated;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.WindowManager;
import org.xml.sax.SAXException;

public class Installer
extends ModuleInstall
implements Runnable {
    static final String IDE_STARTUP = "IDE_STARTUP";
    static final long serialVersionUID = 1L;
    static final String USER_CONFIGURATION = "UI_USER_CONFIGURATION";
    private static UIHandler ui = new UIHandler(false);
    private static UIHandler handler = new UIHandler(true);
    private static MetricsHandler metrics = new MetricsHandler();
    static final Logger LOG = Logger.getLogger(Installer.class.getName());
    public static final RequestProcessor RP = new RequestProcessor("UI Gestures");
    public static final RequestProcessor RP_UI = new RequestProcessor("UI Gestures - Create Dialog");
    public static final RequestProcessor RP_SUBMIT = new RequestProcessor("UI Gestures - Submit Data", 2);
    public static RequestProcessor RP_OPT = null;
    private static final Preferences prefs = NbPreferences.forModule(Installer.class);
    private static OutputStream logStream;
    private static OutputStream logStreamMetrics;
    private static int logsSize;
    private static int logsSizeMetrics;
    private static long logsFirstDateMetric;
    private static URL hintURL;
    private static Object[] selectedExcParams;
    private static boolean logMetricsEnabled;
    private static boolean logMetricsUploadFailed;
    private static final ThreadLocal<List<LogRecord>> logRecords;
    private static final String USAGE_STATISTICS_ENABLED = "usageStatisticsEnabled";
    private static final String USAGE_STATISTICS_SET_BY_IDE = "usageStatisticsSetByIde";
    private static final String USAGE_STATISTICS_NB_OF_IDE_STARTS = "usageStatisticsNbOfIdeStarts";
    private static final String CORE_PREF_NODE = "org/netbeans/core";
    private static final Preferences corePref;
    private JButton metricsEnable = new JButton();
    private JButton metricsCancel = new JButton();
    private static final String CMD_METRICS_ENABLE = "MetricsEnable";
    private static final String CMD_METRICS_CANCEL = "MetricsCancel";
    private ActionListener l = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            Installer.this.cmd = ev.getActionCommand();
            if (Installer.CMD_METRICS_ENABLE.equals(Installer.this.cmd)) {
                corePref.putBoolean(Installer.USAGE_STATISTICS_ENABLED, true);
            } else if (Installer.CMD_METRICS_CANCEL.equals(Installer.this.cmd)) {
                corePref.putBoolean(Installer.USAGE_STATISTICS_ENABLED, false);
            }
            corePref.putBoolean(Installer.USAGE_STATISTICS_SET_BY_IDE, true);
        }
    };
    private String cmd;
    static final String METRICS_LOGGER_NAME = "org.netbeans.ui.metrics";
    private static Pattern ENCODING;
    static boolean preferencesWritable;
    static final String preferencesWritableKey = "uihandler.preferences.writable.check";
    private static final Object UIGESTURE_LOG_LOCK;
    private static final Object METRICS_LOG_LOCK;
    private static boolean fileContentReported;
    private static AtomicReference<String> DISPLAYING;
    private static boolean dontWaitForUserInputInTests;

    public void restored() {
        TimeToFailure.logAction();
        Logger log = Logger.getLogger("org.netbeans.ui");
        log.setUseParentHandlers(false);
        log.setLevel(Level.FINEST);
        log.addHandler(ui);
        Logger all = Logger.getLogger("");
        all.addHandler(handler);
        logsSize = prefs.getInt("count", 0);
        logsSizeMetrics = prefs.getInt("countMetrics", 0);
        logsFirstDateMetric = prefs.getLong("firstDateMetric", -1L);
        logMetricsUploadFailed = prefs.getBoolean("metrics.upload.failed", false);
        corePref.addPreferenceChangeListener(new PrefChangeListener());
        if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
            this.usageStatisticsReminder();
        }
        System.setProperty("nb.show.statistics.ui", USAGE_STATISTICS_ENABLED);
        logMetricsEnabled = corePref.getBoolean(USAGE_STATISTICS_ENABLED, false);
        if (logMetricsEnabled) {
            log = Logger.getLogger(METRICS_LOGGER_NAME);
            log.setUseParentHandlers(true);
            log.setLevel(Level.FINEST);
            log.addHandler(metrics);
            try {
                LogRecord userData = Installer.getUserData(log);
                LogRecords.write((OutputStream)Installer.logStreamMetrics(), (LogRecord)userData);
                ArrayList<LogRecord> enabledRec = new ArrayList<LogRecord>();
                ArrayList<LogRecord> disabledRec = new ArrayList<LogRecord>();
                Installer.getModuleList(log, enabledRec, disabledRec);
                for (LogRecord rec : enabledRec) {
                    LogRecords.write((OutputStream)Installer.logStreamMetrics(), (LogRecord)rec);
                }
                for (LogRecord rec : disabledRec) {
                    LogRecords.write((OutputStream)Installer.logStreamMetrics(), (LogRecord)rec);
                }
                LogRecord clusterRec = Installer.getClusterList(log);
                LogRecords.write((OutputStream)Installer.logStreamMetrics(), (LogRecord)clusterRec);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        EarlyHandler.disable();
        CPUInfo.logCPUInfo();
        ScreenSize.logScreenSize();
        this.logIdeStartup();
        for (Activated a : Lookup.getDefault().lookupAll(Activated.class)) {
            a.activated(log);
        }
        if (logsSize >= 1000) {
            WindowManager.getDefault().invokeWhenUIReady((Runnable)this);
        }
    }

    static int getLogsSizeTest() {
        return logsSize;
    }

    private void logIdeStartup() {
        Logger.getLogger("org.netbeans.ui").log(new LogRecord(Level.CONFIG, IDE_STARTUP));
    }

    private void usageStatisticsReminder() {
        long nbOfIdeStarts = corePref.getLong(USAGE_STATISTICS_NB_OF_IDE_STARTS, 0L);
        if (++nbOfIdeStarts < 4L) {
            corePref.putLong(USAGE_STATISTICS_NB_OF_IDE_STARTS, nbOfIdeStarts);
        }
        boolean setByIde = corePref.getBoolean(USAGE_STATISTICS_SET_BY_IDE, false);
        boolean usageEnabled = corePref.getBoolean(USAGE_STATISTICS_ENABLED, false);
        if (setByIde) {
            return;
        }
        if (!setByIde && !usageEnabled && nbOfIdeStarts == 2L) {
            this.metricsEnable.addActionListener(this.l);
            this.metricsEnable.setActionCommand(CMD_METRICS_ENABLE);
            Mnemonics.setLocalizedText((AbstractButton)this.metricsEnable, (String)NbBundle.getMessage(Installer.class, (String)"LBL_MetricsEnable"));
            this.metricsEnable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Installer.class, (String)"ACSN_MetricsEnable"));
            this.metricsEnable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Installer.class, (String)"ACSD_MetricsEnable"));
            this.metricsCancel.addActionListener(this.l);
            this.metricsCancel.setActionCommand(CMD_METRICS_CANCEL);
            Mnemonics.setLocalizedText((AbstractButton)this.metricsCancel, (String)NbBundle.getMessage(Installer.class, (String)"LBL_MetricsCancel"));
            this.metricsCancel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Installer.class, (String)"ACSN_MetricsCancel"));
            this.metricsCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Installer.class, (String)"ACSD_MetricsCancel"));
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    Installer.this.showDialog();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDialog() {
        final ReminderPanel panel = new ReminderPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(Installer.class, (String)"Metrics_title"), true, new Object[]{this.metricsEnable, this.metricsCancel}, null, 0, null, null);
        Dialog dlg = null;
        try {
            final Dialog d = dlg = DialogDisplayer.getDefault().createDialog(descriptor);
            dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    BufferedImage offImg = (BufferedImage)panel.createImage(1000, 1000);
                    Graphics2D g = offImg.createGraphics();
                    panel.paint(g);
                    int height = d.getPreferredSize().height;
                    Dimension size = d.getSize();
                    size.height = height;
                    d.setSize(size);
                }
            });
            dlg.setResizable(false);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    @Override
    public void run() {
        if (RP.isRequestProcessorThread()) {
            Installer.displaySummary("INIT_URL", false, false, false);
        } else {
            RP.post((Runnable)this);
        }
    }

    public void uninstalled() {
        this.doClose();
    }

    public final void close() {
        UIHandler.flushImmediatelly();
        Installer.closeLogStream();
        MetricsHandler.flushImmediatelly();
        Installer.closeLogStreamMetrics();
    }

    public final void doClose() {
        Logger log = Logger.getLogger("org.netbeans.ui");
        log.removeHandler(ui);
        Logger all = Logger.getLogger("");
        all.removeHandler(handler);
        log = Logger.getLogger(METRICS_LOGGER_NAME);
        log.removeHandler(metrics);
        Installer.closeLogStream();
        Installer.closeLogStreamMetrics();
    }

    static boolean isImmediateWriteOut(LogRecord r) {
        List<LogRecord> preferredLog = logRecords.get();
        if (preferredLog != null) {
            preferredLog.add(r);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOut(LogRecord r) {
        block23: {
            try {
                File f1;
                File f;
                boolean logSizeControl;
                boolean logOverflow;
                ArrayList<LogRecord> logs = null;
                Object object = UIGESTURE_LOG_LOCK;
                synchronized (object) {
                    LogRecords.write((OutputStream)Installer.logStream(), (LogRecord)r);
                    boolean bl = logOverflow = ++logsSize > 1000;
                    if (preferencesWritable) {
                        if (logOverflow) {
                            prefs.putInt("count", 1000);
                        } else if (prefs.getInt("count", 0) < logsSize) {
                            prefs.putInt("count", logsSize);
                        }
                    }
                    if (logOverflow) {
                        Installer.closeLogStream();
                        if (Installer.isHintsMode()) {
                            logs = new ArrayList<LogRecord>(Installer.getLogs());
                        }
                    }
                    logSizeControl = logsSize % 100 == 0 && !logOverflow;
                }
                if (logOverflow) {
                    if (Installer.isHintsMode()) {
                        ArrayList<LogRecord> recs = logs;
                        class Auto
                        implements Runnable {
                            final /* synthetic */ List val$recs;

                            Auto(List list) {
                                this.val$recs = list;
                            }

                            @Override
                            public void run() {
                                Installer.displaySummary("WELCOME_URL", true, true, true, DataType.DATA_UIGESTURE, this.val$recs, null);
                            }
                        }
                        RP.post((Runnable)new Auto(recs)).waitFinished();
                    }
                    object = UIGESTURE_LOG_LOCK;
                    synchronized (object) {
                        f = Installer.logFile(0);
                        f1 = Installer.logFile(1);
                        if (f1.exists()) {
                            f1.delete();
                        }
                        f.renameTo(f1);
                        logsSize = 0;
                    }
                }
                if (!logSizeControl) break block23;
                object = UIGESTURE_LOG_LOCK;
                synchronized (object) {
                    f = Installer.logFile(0);
                    f1 = Installer.logFile(1);
                    if (f.exists() && f.length() > 0x1400000L) {
                        LOG.log(Level.INFO, "UIGesture Collector log file size is over limit. It will be deleted.");
                        LOG.log(Level.INFO, "Log file:{0} Size:{1} Bytes", new Object[]{f, f.length()});
                        Installer.closeLogStream();
                        logsSize = 0;
                        if (preferencesWritable) {
                            prefs.putInt("count", logsSize);
                        }
                        f.delete();
                    }
                    if (f1.exists() && f1.length() > 0x1400000L) {
                        LOG.log(Level.INFO, "UIGesture Collector backup log file size is over limit. It will be deleted.");
                        LOG.log(Level.INFO, "Log file:{0} Size:{1} Bytes", new Object[]{f1, f1.length()});
                        f1.delete();
                    }
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "UIGesture Collector logging has failed: {0}", ex.getMessage());
            }
        }
    }

    private static LogRecord getUserData(Logger logger) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(Submit.getOS());
        params.add(Submit.getVM());
        params.add(Submit.getVersion());
        List<String> buildInfo = BuildInfo.logBuildInfo();
        if (buildInfo != null) {
            params.addAll(buildInfo);
        }
        LogRecord userData = new LogRecord(Level.INFO, "USG_SYSTEM_CONFIG");
        userData.setParameters(params.toArray());
        userData.setLoggerName(logger.getName());
        return userData;
    }

    private static boolean uploadMetricsTest() {
        if (logsSizeMetrics >= 400) {
            return true;
        }
        int daysSinceFirstMetric = (int)((System.currentTimeMillis() - logsFirstDateMetric) / 86400000L);
        return daysSinceFirstMetric > MetricsHandler.MAX_DAYS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOutMetrics(LogRecord r) {
        try {
            boolean upload;
            Object object = METRICS_LOG_LOCK;
            synchronized (object) {
                boolean firstDateMetric;
                LogRecords.write((OutputStream)Installer.logStreamMetrics(), (LogRecord)r);
                ++logsSizeMetrics;
                boolean bl = firstDateMetric = logsFirstDateMetric < 0L;
                if (firstDateMetric) {
                    logsFirstDateMetric = System.currentTimeMillis();
                }
                if (preferencesWritable) {
                    prefs.putInt("countMetrics", logsSizeMetrics);
                    if (firstDateMetric) {
                        prefs.putLong("firstDateMetric", logsFirstDateMetric);
                    }
                }
                if (upload = Installer.uploadMetricsTest()) {
                    MetricsHandler.waitFlushed();
                    Installer.closeLogStreamMetrics();
                    File f = Installer.logFileMetrics(0);
                    File f1 = Installer.logFileMetrics(1);
                    if (f1.exists()) {
                        if (logMetricsUploadFailed) {
                            if (f1.length() > 0xA00000L) {
                                f1.delete();
                                if (!f.renameTo(f1)) {
                                    LOG.log(Level.INFO, "Failed to rename file:{0} to:{1}", new Object[]{f, f1});
                                }
                            } else {
                                Installer.appendFile(f, f1);
                            }
                        } else {
                            f1.delete();
                            if (!f.renameTo(f1)) {
                                LOG.log(Level.INFO, "Failed to rename file:{0} to:{1}", new Object[]{f, f1});
                            }
                        }
                    } else if (!f.renameTo(f1)) {
                        LOG.log(Level.INFO, "Failed to rename file:{0} to:{1}", new Object[]{f, f1});
                    }
                    logsSizeMetrics = 0;
                    logsFirstDateMetric = System.currentTimeMillis();
                    if (preferencesWritable) {
                        prefs.putInt("countMetrics", logsSizeMetrics);
                        prefs.putLong("dateFirstMetric", logsFirstDateMetric);
                    }
                }
            }
            if (upload) {
                List recs = null;
                class Auto
                implements Runnable {
                    final /* synthetic */ List val$recs;

                    Auto(List list) {
                        this.val$recs = list;
                    }

                    @Override
                    public void run() {
                        Installer.displaySummary("METRICS_URL", true, true, true, DataType.DATA_METRICS, this.val$recs, null);
                    }
                }
                RP.post((Runnable)new Auto(recs)).waitFinished();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFile(File source, File target) {
        byte[] buf = new byte[8192];
        FileInputStream is = null;
        FileOutputStream os = null;
        long targetSize = -1L;
        try {
            int l;
            is = new FileInputStream(source);
            targetSize = target.length();
            os = new FileOutputStream(target, true);
            while ((l = is.read(buf)) != -1) {
                os.write(buf, 0, l);
            }
            os.flush();
        }
        catch (IOException ex) {
            if (os != null) {
                DataConsistentFileOutputStream.truncateFileToConsistentSize(os, targetSize);
            }
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    static void getModuleList(Logger logger, List<LogRecord> enabledRec, List<LogRecord> disabledRec) {
        SpecificationVersion specVersion;
        int i;
        LogRecord rec;
        ArrayList<ModuleInfo> enabled = new ArrayList<ModuleInfo>();
        ArrayList<ModuleInfo> disabled = new ArrayList<ModuleInfo>();
        for (ModuleInfo m : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (m.isEnabled()) {
                enabled.add(m);
                continue;
            }
            disabled.add(m);
        }
        if (!enabled.isEmpty()) {
            rec = new LogRecord(Level.INFO, "USG_ENABLED_MODULES");
            Object[] enabledNames = new String[enabled.size()];
            i = 0;
            for (ModuleInfo m : enabled) {
                specVersion = m.getSpecificationVersion();
                if (specVersion != null) {
                    enabledNames[i++] = m.getCodeName() + " [" + specVersion.toString() + "]";
                    continue;
                }
                enabledNames[i++] = m.getCodeName();
            }
            rec.setParameters(enabledNames);
            rec.setLoggerName(logger.getName());
            enabledRec.add(rec);
        }
        if (!disabled.isEmpty()) {
            rec = new LogRecord(Level.INFO, "USG_DISABLED_MODULES");
            Object[] disabledNames = new String[disabled.size()];
            i = 0;
            for (ModuleInfo m : disabled) {
                specVersion = m.getSpecificationVersion();
                if (specVersion != null) {
                    disabledNames[i++] = m.getCodeName() + " [" + specVersion.toString() + "]";
                    continue;
                }
                disabledNames[i++] = m.getCodeName();
            }
            rec.setParameters(disabledNames);
            rec.setLoggerName(logger.getName());
            disabledRec.add(rec);
        }
    }

    static LogRecord getClusterList(Logger logger) {
        LogRecord rec = new LogRecord(Level.INFO, "USG_INSTALLED_CLUSTERS");
        String dirs = System.getProperty("netbeans.dirs");
        String[] dirsArray = dirs.split(File.pathSeparator);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < dirsArray.length; ++i) {
            File f = new File(dirsArray[i]);
            if (!f.exists()) continue;
            list.add(f.getName());
        }
        rec.setParameters(list.toArray());
        rec.setLoggerName(logger.getName());
        return rec;
    }

    public static URL hintsURL() {
        return hintURL;
    }

    public static boolean isHintsMode() {
        return prefs.getBoolean("autoSubmitWhenFull", false);
    }

    static int timesSubmitted() {
        return prefs.getInt("submitted", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLogsSize() {
        UIHandler.waitFlushed();
        Object object = UIGESTURE_LOG_LOCK;
        synchronized (object) {
            return prefs.getInt("count", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readLogs(Handler handler) {
        UIHandler.waitFlushed();
        Object object = UIGESTURE_LOG_LOCK;
        synchronized (object) {
            File f = Installer.logFile(0);
            if (f == null || !f.exists()) {
                return;
            }
            Installer.closeLogStream();
            File f1 = Installer.logFile(1);
            if (logsSize < 1000 && f1 != null && f1.exists()) {
                Installer.scan(f1, handler);
            }
            Installer.scan(f, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String reportFileContent(File f) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            StringWriter sw = new StringWriter();
            while ((line = br.readLine()) != null) {
                sw.write(line);
                sw.write(10);
            }
            sw.close();
            String string = sw.toString();
            return string;
        }
        catch (IOException ioex) {
            String string = ioex.toString();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scan(File f, Handler handler) {
        block15: {
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                LogRecords.scan((InputStream)is, (Handler)handler);
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Broken uilogs file, not all UI actions will be submitted", ex);
                if (fileContentReported) break block15;
                try {
                    LOG.log(Level.INFO, "Problematic file content = " + Installer.reportFileContent(f));
                }
                finally {
                    fileContentReported = true;
                }
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Broken uilogs file, not all UI actions will be submitted", ex);
                }
            }
        }
    }

    static List<LogRecord> getLogs() {
        class H
        extends Handler {
            List<LogRecord> logs = new LinkedList<LogRecord>();

            H() {
            }

            @Override
            public void publish(LogRecord r) {
                this.logs.add(r);
                if (this.logs.size() > 1000) {
                    this.logs.remove(0);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        }
        H hndlr = new H();
        Installer.readLogs(hndlr);
        return hndlr.logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogRecord> getLogsMetrics() {
        Object object = METRICS_LOG_LOCK;
        synchronized (object) {
            class H
            extends Handler {
                List<LogRecord> logs = new LinkedList<LogRecord>();

                H() {
                }

                @Override
                public void publish(LogRecord r) {
                    this.logs.add(r);
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            }
            H hndlr;
            block19: {
                hndlr = new H();
                FileInputStream is = null;
                File f1 = Installer.logFileMetrics(1);
                if (f1 != null && f1.exists()) {
                    try {
                        is = new FileInputStream(f1);
                        LogRecords.scan((InputStream)is, (Handler)hndlr);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)"Broken metrics log file, not all metrics data will be submitted"));
                        if (fileContentReported) break block19;
                        try {
                            LOG.log(Level.INFO, "Problematic file content = " + Installer.reportFileContent(f1));
                        }
                        finally {
                            fileContentReported = true;
                        }
                    }
                    finally {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            return hndlr.logs;
        }
    }

    static File getDeadlockDumpFile() {
        return new File(Installer.logsDirectory(), "deadlock.dump");
    }

    static File logsDirectory() {
        String ud = System.getProperty("netbeans.user");
        if (ud == null || "memory".equals(ud)) {
            return null;
        }
        File userDir = new File(ud);
        return new File(new File(userDir, "var"), "log");
    }

    private static File logFile(int revision) {
        File logDir = Installer.logsDirectory();
        if (logDir == null) {
            return null;
        }
        String suffix = revision == 0 ? "" : "." + revision;
        File logFile = new File(logDir, "uigestures" + suffix);
        return logFile;
    }

    private static File logFileMetrics(int revision) {
        String ud = System.getProperty("netbeans.user");
        if (ud == null || "memory".equals(ud)) {
            return null;
        }
        String suffix = revision == 0 ? "" : "." + revision;
        File userDir = new File(ud);
        File logFile = new File(new File(new File(userDir, "var"), "log"), "metrics" + suffix);
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OutputStream logStream() throws FileNotFoundException {
        Class<Installer> clazz = Installer.class;
        synchronized (Installer.class) {
            Object os;
            if (logStream != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return logStream;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            File logFile = Installer.logFile(0);
            if (logFile != null) {
                logFile.getParentFile().mkdirs();
                os = new DataConsistentFileOutputStream(logFile, true);
            } else {
                os = new NullOutputStream();
            }
            Class<Installer> clazz2 = Installer.class;
            synchronized (Installer.class) {
                if (logStream != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return logStream;
                }
                logStream = os;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return logStream;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OutputStream logStreamMetrics() throws FileNotFoundException {
        Class<Installer> clazz = Installer.class;
        synchronized (Installer.class) {
            Object os;
            if (logStreamMetrics != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return logStreamMetrics;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            File logFile = Installer.logFileMetrics(0);
            if (logFile != null) {
                logFile.getParentFile().mkdirs();
                os = new DataConsistentFileOutputStream(logFile, true);
            } else {
                os = new NullOutputStream();
            }
            Class<Installer> clazz2 = Installer.class;
            synchronized (Installer.class) {
                if (logStreamMetrics != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return logStreamMetrics;
                }
                logStreamMetrics = os;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return logStreamMetrics;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeLogStream() {
        Class<Installer> clazz = Installer.class;
        synchronized (Installer.class) {
            OutputStream os = logStream;
            logStream = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (os == null) {
                return;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeLogStreamMetrics() {
        Class<Installer> clazz = Installer.class;
        synchronized (Installer.class) {
            OutputStream os = logStreamMetrics;
            logStreamMetrics = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (os == null) {
                return;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearLogs() {
        Object object = UIGESTURE_LOG_LOCK;
        synchronized (object) {
            File f;
            Installer.closeLogStream();
            int i = 0;
            while ((f = Installer.logFile(i)) != null && f.exists()) {
                f.delete();
                ++i;
            }
            logsSize = 0;
            if (preferencesWritable) {
                prefs.putInt("count", 0);
            }
        }
        UIHandler.SUPPORT.firePropertyChange(null, null, null);
    }

    public boolean closing() {
        UIHandler.waitFlushed();
        return true;
    }

    static void logDeactivated() {
        Logger log = Logger.getLogger("org.netbeans.ui");
        for (Deactivated a : Lookup.getDefault().lookupAll(Deactivated.class)) {
            a.deactivated(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean displaySummary(String msg, boolean explicit, boolean auto, boolean connectDialog, DataType dataType, List<LogRecord> recs, SlownessData slownData) {
        if (!DISPLAYING.compareAndSet(null, msg)) {
            return true;
        }
        boolean v = true;
        try {
            boolean dontAsk;
            if (!explicit && (dontAsk = prefs.getBoolean("ask.never.again." + msg, false))) {
                LOG.log(Level.INFO, "UI Gesture Collector's ask.never.again.{0} is true, exiting", msg);
                boolean bl = true;
                return bl;
            }
            Submit submit = auto ? new SubmitAutomatic(msg, Button.SUBMIT, dataType, recs) : new SubmitInteractive(msg, connectDialog, dataType, recs, slownData);
            submit.doShow(dataType);
            v = submit.okToExit;
        }
        finally {
            DISPLAYING.set(null);
        }
        return v;
    }

    public static boolean displaySummary(String msg, boolean explicit, boolean auto, boolean connectDialog) {
        return Installer.displaySummary(msg, explicit, auto, connectDialog, DataType.DATA_UIGESTURE, null, null);
    }

    static boolean displaySummary(String msg, boolean explicit, boolean auto, boolean connectDialog, SlownessData slownessData) {
        return Installer.displaySummary(msg, explicit, auto, connectDialog, DataType.DATA_UIGESTURE, null, slownessData);
    }

    static Throwable getThrown() {
        return Installer.getThrown(Installer.getLogs());
    }

    private static Throwable getThrown(List<LogRecord> recs) {
        LogRecord log = Installer.getThrownLog(recs);
        if (log == null) {
            return null;
        }
        return log.getThrown();
    }

    private static LogRecord getThrownLog(List<LogRecord> list) {
        String firstLine = null;
        String message = null;
        if (selectedExcParams != null) {
            if (selectedExcParams[0] instanceof String) {
                message = (String)selectedExcParams[0];
            }
            if (selectedExcParams[1] instanceof String) {
                firstLine = (String)selectedExcParams[1];
            }
        }
        ListIterator<LogRecord> it = list.listIterator(list.size());
        Throwable thr = null;
        while (it.hasPrevious()) {
            LogRecord result = it.previous();
            if (result.getLevel().intValue() >= Level.WARNING.intValue()) {
                StackTraceElement elem;
                String thrLine;
                StackTraceElement[] elems;
                thr = result.getThrown();
                if (thr != null && message != null && !thr.getMessage().equals(message)) {
                    thr = null;
                }
                if (thr != null && firstLine != null && (elems = thr.getStackTrace()) != null && elems.length != 0 && !(thrLine = (elem = elems[0]).getClassName() + "." + elem.getMethodName()).equals(firstLine)) {
                    thr = null;
                }
            }
            if (thr == null) continue;
            return result;
        }
        return null;
    }

    protected static void setSelectedExcParams(Object[] params) {
        selectedExcParams = params;
    }

    static void parseButtons(InputStream is, final Object defaultButton, final DialogDescriptor dd) throws IOException, ParserConfigurationException, SAXException, InterruptedException, InvocationTargetException {
        final ButtonsParser bp = new ButtonsParser(is);
        bp.parse();
        Runnable buttonsCreation = new Runnable(){

            @Override
            public void run() {
                bp.createButtons();
                List<Object> options = bp.getOptions();
                if (!bp.containsExitButton() && defaultButton != null) {
                    options.add(defaultButton);
                }
                dd.setOptions(options.toArray());
                dd.setAdditionalOptions(bp.getAditionalOptions().toArray());
                if (bp.getTitle() != null) {
                    dd.setTitle(bp.getTitle());
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            buttonsCreation.run();
        } else {
            EventQueue.invokeAndWait(buttonsCreation);
        }
    }

    static String decodeButtons(Object res, URL[] url) {
        return Installer.decodeButtons(res, url, DataType.DATA_UIGESTURE);
    }

    private static String decodeButtons(Object res, URL[] url, DataType dataType) {
        if (res instanceof JButton) {
            JButton b = (JButton)res;
            Object post = b.getClientProperty("url");
            if (post instanceof String) {
                String replace = null;
                if (dataType == DataType.DATA_UIGESTURE) {
                    replace = System.getProperty("org.netbeans.modules.uihandler.Submit");
                } else if (dataType == DataType.DATA_METRICS) {
                    replace = System.getProperty("org.netbeans.modules.uihandler.Metrics");
                }
                if (replace != null) {
                    post = replace;
                }
                try {
                    url[0] = new URL((String)post);
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.INFO, "Cannot decode URL: " + post, ex);
                    url[0] = null;
                    return null;
                }
            }
            return b.getActionCommand();
        }
        return res instanceof String ? (String)res : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL uploadLogs(URL postURL, String id, Map<String, String> attrs, List<LogRecord> recs, DataType dataType, boolean isErrorReport, SlownessData slownData, boolean isOOM) throws IOException {
        ProgressHandle h = null;
        if (dataType != DataType.DATA_METRICS) {
            h = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Installer.class, (String)"MSG_UploadProgressHandle"));
        }
        try {
            URL uRL = Installer.uLogs(h, postURL, id, attrs, recs, dataType, isErrorReport, slownData, isOOM);
            return uRL;
        }
        finally {
            if (h != null) {
                h.finish();
            }
        }
    }

    static URL uploadLogs(URL postURL, String id, Map<String, String> attrs, List<LogRecord> recs, boolean isErrorReport) throws IOException {
        return Installer.uploadLogs(postURL, id, attrs, recs, DataType.DATA_UIGESTURE, isErrorReport, null, false);
    }

    private static URL uLogs(ProgressHandle h, URL postURL, String id, Map<String, String> attrs, List<LogRecord> recs, DataType dataType, boolean isErrorReport, SlownessData slownData, boolean isOOM) throws IOException {
        if (dataType != DataType.DATA_METRICS) {
            int workUnits = isOOM ? 1100 : 100;
            h.start(workUnits + recs.size());
            h.progress(NbBundle.getMessage(Installer.class, (String)"MSG_UploadConnecting"));
        }
        boolean fileProtocol = "file".equals(postURL.getProtocol());
        LOG.log(Level.FINE, "uploadLogs, postURL = {0}", postURL);
        URLConnection conn = fileProtocol ? null : postURL.openConnection();
        if (dataType != DataType.DATA_METRICS) {
            h.progress(10);
        }
        if (!fileProtocol) {
            conn.setReadTimeout(60000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=--------konec<>bloku");
            conn.setRequestProperty("Pragma", "no-cache");
            conn.setRequestProperty("Cache-control", "no-cache");
            conn.setRequestProperty("User-Agent", "NetBeans");
        }
        if (dataType != DataType.DATA_METRICS) {
            h.progress(NbBundle.getMessage(Installer.class, (String)"MSG_UploadSending"), 20);
        }
        LOG.log(Level.FINE, "uploadLogs, header sent");
        PrintStream os = fileProtocol ? new PrintStream(new FileOutputStream(postURL.getFile())) : new PrintStream(conn.getOutputStream());
        for (Map.Entry<String, String> en : attrs.entrySet()) {
            os.println("----------konec<>bloku");
            os.println("Content-Disposition: form-data; name=\"" + en.getKey() + "\"");
            os.println();
            os.println(en.getValue().getBytes());
        }
        LOG.log(Level.FINE, "uploadLogs, attributes sent");
        if (dataType != DataType.DATA_METRICS) {
            h.progress(30);
        }
        os.println("----------konec<>bloku");
        if (id == null) {
            id = "uigestures";
        }
        if (dataType != DataType.DATA_METRICS && isErrorReport) {
            os.println("Content-Disposition: form-data; name=\"messages\"; filename=\"" + id + "_messages.gz\"");
            os.println("Content-Type: x-application/log");
            os.println();
            Installer.uploadMessagesLog(os);
            os.println();
            os.println("\n----------konec<>bloku");
        }
        if (slownData != null) {
            assert (slownData.getNpsContent() != null) : "nps param should be not null";
            assert (slownData.getNpsContent().length > 0) : "nps param should not be empty";
            os.println("Content-Disposition: form-data; name=\"slowness\"; filename=\"" + id + "_slowness.gz\"");
            os.println("Content-Type: x-application/nps");
            os.println();
            os.write(slownData.getNpsContent());
            os.println();
            os.println("\n----------konec<>bloku");
        }
        if (dataType != DataType.DATA_METRICS) {
            h.progress(70);
        }
        if (isOOM) {
            int read;
            File f = Installer.getHeapDump();
            assert (f != null);
            assert (f.exists() && f.canRead());
            assert (f.length() != 0L) : "Heapdump has zero size!";
            long progressUnit = f.length() / 1000L;
            if (progressUnit == 0L) {
                progressUnit = 1L;
            }
            long alreadyWritten = 0L;
            os.println("Content-Disposition: form-data; name=\"heapdump\"; filename=\"" + id + "_heapdump.gz\"");
            os.println("Content-Type: x-application/heap");
            os.println();
            GZIPOutputStream gzip = new GZIPOutputStream(os);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            byte[] heapDumpData = new byte[8192];
            while ((read = bis.read(heapDumpData)) != -1) {
                gzip.write(heapDumpData, 0, read);
                int workunit = (int)((alreadyWritten += (long)read) / progressUnit);
                if (workunit >= 1000) continue;
                h.progress(70 + workunit);
            }
            bis.close();
            gzip.finish();
            os.println();
            os.println("\n----------konec<>bloku");
            h.progress(1070);
        }
        os.println("Content-Disposition: form-data; name=\"logs\"; filename=\"" + id + "\"");
        os.println("Content-Type: x-application/gzip");
        os.println();
        GZIPOutputStream gzip = new GZIPOutputStream(os);
        DataOutputStream data = new DataOutputStream(gzip);
        data.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("utf-8"));
        data.write("<uigestures version='1.0'>\n".getBytes("utf-8"));
        int cnt = isOOM ? 1080 : 80;
        LOG.log(Level.FINE, "uploadLogs, sending records");
        for (LogRecord r : recs) {
            if (dataType != DataType.DATA_METRICS) {
                h.progress(cnt++);
            }
            if (r == null) continue;
            LogRecords.write((OutputStream)data, (LogRecord)r);
        }
        data.write("</uigestures>\n".getBytes("utf-8"));
        LOG.log(Level.FINE, "uploadLogs, flushing");
        data.flush();
        gzip.finish();
        os.println();
        os.println("----------konec<>bloku--");
        os.close();
        if (dataType != DataType.DATA_METRICS) {
            h.progress(NbBundle.getMessage(Installer.class, (String)"MSG_UploadReading"), cnt + 10);
        }
        StringBuffer redir = null;
        Matcher m = null;
        if (!fileProtocol) {
            int ch;
            LOG.log(Level.FINE, "uploadLogs, reading reply");
            InputStream is = conn.getInputStream();
            redir = new StringBuffer();
            while ((ch = is.read()) != -1) {
                redir.append((char)ch);
            }
            is.close();
            if (dataType != DataType.DATA_METRICS) {
                h.progress(cnt + 20);
            }
            LOG.log(Level.FINE, "uploadLogs, Reply from uploadLogs: {0}", redir);
            Pattern p = Pattern.compile("<meta\\s*http-equiv=.Refresh.\\s*content.*url=['\"]?([^'\" ]*)\\s*['\"]", 42);
            m = p.matcher(redir);
        }
        if (isOOM) {
            String submittedName;
            FileObject fo = FileUtil.createData((File)Installer.getHeapDump());
            FileObject folder = fo.getParent();
            FileObject submittedFO = folder.getFileObject(submittedName = fo.getName() + "_submitted", fo.getExt());
            if (submittedFO != null) {
                submittedFO.delete();
            }
            FileLock lock = fo.lock();
            fo.rename(lock, submittedName, fo.getExt());
            lock.releaseLock();
        }
        if (!fileProtocol) {
            if (m.find()) {
                LOG.log(Level.FINE, "uploadLogs, found url = {0}", m.group(1));
                return new URL(m.group(1));
            }
            File f = File.createTempFile("uipage", "html");
            f.deleteOnExit();
            FileWriter w = new FileWriter(f);
            w.write(redir.toString());
            w.close();
            LOG.log(Level.FINE, "uploadLogs, temporary url = {0}", Utilities.toURI((File)f));
            return Utilities.toURI((File)f).toURL();
        }
        return null;
    }

    private static File getMessagesLog() {
        File directory = Installer.logsDirectory();
        if (directory == null) {
            return null;
        }
        File messagesLog = new File(directory, "messages.log");
        return messagesLog;
    }

    private static File getHeapDump() {
        String heapDumpPath = null;
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> lst = RuntimemxBean.getInputArguments();
        for (String arg : lst) {
            if (!arg.contains("XX:HeapDumpPath")) continue;
            int index = arg.indexOf(61);
            heapDumpPath = arg.substring(index + 1);
        }
        if (heapDumpPath == null) {
            LOG.info("XX:HeapDumpPath parametter not specified");
            return null;
        }
        File heapDumpFile = new File(heapDumpPath);
        if (heapDumpFile.exists() && heapDumpFile.canRead() && heapDumpFile.length() > 0L) {
            return heapDumpFile;
        }
        LOG.log(Level.INFO, "heap dump was not created at {0}", heapDumpPath);
        LOG.log(Level.INFO, "heapdump file: exists():{0}, canRead():{1}, length:{2}", new Object[]{heapDumpFile.exists(), heapDumpFile.canRead(), heapDumpFile.length()});
        return null;
    }

    static void uploadMessagesLog(PrintStream os) throws IOException {
        Installer.flushSystemLogs();
        File messagesLog = Installer.getMessagesLog();
        if (messagesLog == null) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(messagesLog));
        GZIPOutputStream gzip = new GZIPOutputStream(os);
        byte[] buffer = new byte[4096];
        int readLength = is.read(buffer);
        while (readLength != -1) {
            gzip.write(buffer, 0, readLength);
            readLength = is.read(buffer);
        }
        is.close();
        gzip.finish();
    }

    private static void flushSystemLogs() {
        System.out.flush();
        System.err.flush();
    }

    public static String findIdentity() {
        int ind;
        Preferences p = NbPreferences.root().node("org/netbeans/modules/autoupdate");
        String id = p.get("qualifiedId", null);
        if (id != null && (ind = id.indexOf("0")) != -1) {
            id = id.substring(ind + 1);
        }
        LOG.log(Level.INFO, "findIdentity: {0}", id);
        return id;
    }

    static void copyWithEncoding(InputStream inputStream, OutputStream os) throws IOException {
        int len;
        byte[] arr = new byte[4096];
        String text = null;
        String enc = "utf-8";
        while ((len = inputStream.read(arr)) != -1) {
            boolean first = text == null;
            text = new String(arr, 0, len, enc);
            if (first) {
                Matcher m = ENCODING.matcher(text);
                if (m.find()) {
                    enc = m.group(1);
                    text = new String(arr, 0, len, enc);
                    block1: while (true) {
                        Matcher replace = ENCODING.matcher(text);
                        while (replace.find()) {
                            if ("UTF-8".equals(replace.group(1))) continue;
                            text = text.substring(0, replace.start(1)) + "UTF-8" + text.substring(replace.end(1));
                            continue block1;
                        }
                        break;
                    }
                    LOG.log(Level.FINE, "Downloaded with encoding ''{0}'':\n{1}", new Object[]{enc, text});
                } else {
                    LOG.log(Level.FINE, "Downloaded with utf-8:\n{0}", text);
                }
            }
            os.write(text.getBytes("UTF-8"));
        }
    }

    protected static String createMessage(Throwable thr) {
        int indexClassName;
        while (thr.getCause() != null && thr.getCause().getStackTrace().length != 0) {
            thr = thr.getCause();
        }
        String message = thr.toString();
        if (message.startsWith("java.lang.")) {
            message = message.substring(10);
        }
        if ((indexClassName = message.indexOf(58)) == -1 && thr.getStackTrace().length != 0) {
            StackTraceElement elem = thr.getStackTrace()[0];
            return message + " at " + elem.getClassName() + "." + elem.getMethodName();
        }
        return message;
    }

    static void dontWaitForUserInputInTests() {
        dontWaitForUserInputInTests = true;
    }

    static {
        logMetricsEnabled = false;
        logMetricsUploadFailed = false;
        logRecords = new ThreadLocal();
        corePref = NbPreferences.root().node(CORE_PREF_NODE);
        ENCODING = Pattern.compile("<meta.*http-equiv=['\"]Content-Type['\"].*content=.*charset=([A-Za-z0-9\\-]+)['\"]>", 2);
        preferencesWritable = false;
        long checkTime = System.currentTimeMillis();
        try {
            prefs.putLong(preferencesWritableKey, checkTime);
        }
        catch (IllegalArgumentException iae) {
            prefs.putLong(preferencesWritableKey, checkTime);
        }
        try {
            prefs.flush();
            prefs.sync();
            if (checkTime == prefs.getLong(preferencesWritableKey, 0L)) {
                preferencesWritable = true;
            }
        }
        catch (BackingStoreException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        UIGESTURE_LOG_LOCK = new Object();
        METRICS_LOG_LOCK = new Object();
        DISPLAYING = new AtomicReference();
        dontWaitForUserInputInTests = false;
    }

    static enum Button {
        EXIT("exit"),
        NEVER_AGAIN("never-again"),
        VIEW_DATA("view-data"),
        REDIRECT("redirect"),
        AUTO_SUBMIT("auto-submit"),
        SUBMIT("submit"),
        REFRESH("refresh"),
        PROXY("proxy");

        private final String name;

        private Button(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCommand(String s) {
            return this.name.equals(s);
        }

        public static boolean isKnown(String n) {
            for (Button b : Button.values()) {
                if (!n.equals(b.getName())) continue;
                return true;
            }
            return false;
        }

        public static boolean isSubmitTrigger(String n) {
            return SUBMIT.isCommand(n) || AUTO_SUBMIT.isCommand(n);
        }
    }

    private static enum DataType {
        DATA_UIGESTURE,
        DATA_METRICS;

    }

    static final class Form {
        final String url;
        String submitValue;

        public Form(String u) {
            this.url = u;
        }
    }

    private static final class PrefChangeListener
    implements PreferenceChangeListener {
        private PrefChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            boolean newVal;
            if (corePref.equals(evt.getNode()) && Installer.USAGE_STATISTICS_ENABLED.equals(evt.getKey()) && (newVal = Boolean.parseBoolean(evt.getNewValue())) != logMetricsEnabled) {
                corePref.putBoolean(Installer.USAGE_STATISTICS_SET_BY_IDE, true);
                logMetricsEnabled = newVal;
                Logger log = Logger.getLogger(Installer.METRICS_LOGGER_NAME);
                if (logMetricsEnabled) {
                    log.setUseParentHandlers(true);
                    log.setLevel(Level.FINEST);
                    log.addHandler(metrics);
                    MetricsHandler.setFlushOnRecord(false);
                } else {
                    MetricsHandler.flushImmediatelly();
                    Installer.closeLogStreamMetrics();
                    log.removeHandler(metrics);
                }
            }
        }
    }

    private static abstract class Submit
    implements ActionListener,
    Runnable {
        private AtomicBoolean isSubmiting;
        protected String exitMsg;
        protected DialogDescriptor dd;
        protected String msg;
        protected boolean report;
        protected boolean okToExit;
        protected ReportPanel reportPanel;
        private URL url;
        private DialogState dialogState = DialogState.NON_CREATED;
        private boolean checkingResult;
        private boolean refresh = false;
        protected boolean errorPage = false;
        protected DataType dataType = DataType.DATA_UIGESTURE;
        protected final List<LogRecord> recs;
        protected boolean isOOM = false;
        protected ExceptionsSettings settings;
        protected JProgressBar jpb = new JProgressBar();

        public Submit(String msg) {
            this(msg, DataType.DATA_UIGESTURE, null);
        }

        public Submit(String msg, DataType dataType, List<LogRecord> recs) {
            this.msg = msg;
            this.dataType = dataType;
            this.isSubmiting = new AtomicBoolean(false);
            this.recs = recs != null ? recs : (dataType == DataType.DATA_METRICS ? Installer.getLogsMetrics() : new ArrayList<LogRecord>(Installer.getLogs()));
            this.report = "ERROR_URL".equals(msg);
        }

        protected abstract void createDialog();

        protected abstract Object showDialogAndGetValue(DialogDescriptor var1);

        protected abstract void closeDialog();

        protected abstract void alterMessage(DialogDescriptor var1);

        protected abstract void viewData();

        protected abstract void assignInternalURL(URL var1);

        protected abstract void addMoreLogs(List<? super String> var1, boolean var2);

        protected abstract void showURL(URL var1, boolean var2);

        protected abstract SlownessData getSlownessData();

        DialogDescriptor findDD() {
            if (this.dd == null) {
                this.dd = this.report ? new DialogDescriptor(null, NbBundle.getMessage(Installer.class, (String)"ErrorDialogTitle")) : new DialogDescriptor(null, NbBundle.getMessage(Installer.class, (String)"MSG_SubmitDialogTitle"));
            }
            return this.dd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doShow(DataType dataType) {
            if (dataType == DataType.DATA_UIGESTURE) {
                try {
                    logRecords.set(this.recs);
                    Installer.logDeactivated();
                }
                finally {
                    logRecords.remove();
                }
            }
            this.findDD();
            this.exitMsg = NbBundle.getMessage(Installer.class, (String)("MSG_" + this.msg + "_EXIT"));
            String defaultURI = NbBundle.getMessage(Installer.class, (String)this.msg);
            String replace = System.getProperty("org.netbeans.modules.uihandler.LoadURI");
            if (replace != null) {
                defaultURI = replace;
            }
            LOG.log(Level.FINE, "doShow, exitMsg = {0}, defaultURI = {1}", new Object[]{this.exitMsg, defaultURI});
            if (defaultURI == null || defaultURI.length() == 0) {
                this.okToExit = true;
                return;
            }
            Submit submit = this;
            synchronized (submit) {
                RP_UI.post((Runnable)this);
                while (this.dialogState.equals((Object)DialogState.NON_CREATED)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.notifyAll();
            }
            if (this.dialogState.equals((Object)DialogState.FAILED)) {
                return;
            }
            LOG.log(Level.FINE, "doShow, dialog has been created");
            boolean firstRound = true;
            StringBuilder sb = new StringBuilder(1024);
            while (true) {
                try {
                    if (this.url == null) {
                        this.url = new URL(defaultURI);
                    }
                    LOG.log(Level.FINE, "doShow, reading from = {0}", this.url);
                    sb.append("doShow reading from: ").append(this.url).append("\n");
                    URLConnection conn = this.url.openConnection();
                    conn.setRequestProperty("User-Agent", "NetBeans");
                    conn.setConnectTimeout(5000);
                    File tmp = File.createTempFile("uigesture", ".html");
                    tmp.deleteOnExit();
                    FileOutputStream os = new FileOutputStream(tmp);
                    Installer.copyWithEncoding(conn.getInputStream(), os);
                    os.close();
                    conn.getInputStream().close();
                    LOG.log(Level.FINE, "doShow, all read from = {0}", this.url);
                    FileInputStream is = new FileInputStream(tmp);
                    byte[] arr = new byte[((InputStream)is).available()];
                    ((InputStream)is).read(arr);
                    sb.append("Content:\n").append(new String(arr)).append("\nEnd of Content");
                    ((InputStream)is).close();
                    is = new FileInputStream(tmp);
                    Installer.parseButtons(is, this.exitMsg, this.dd);
                    LOG.log(Level.FINE, "doShow, parsing buttons: {0}", Arrays.toString(this.dd.getOptions()));
                    this.alterMessage(this.dd);
                    ((InputStream)is).close();
                    this.url = Utilities.toURI((File)tmp).toURL();
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
                catch (InvocationTargetException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
                catch (ParserConfigurationException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
                catch (SAXException ex) {
                    LOG.log(Level.INFO, sb.toString());
                    LOG.log(Level.WARNING, this.url.toExternalForm(), ex);
                }
                catch (IllegalStateException ex) {
                    this.catchConnectionProblem(ex);
                    continue;
                }
                catch (SocketTimeoutException ex) {
                    this.catchConnectionProblem(ex);
                    continue;
                }
                catch (UnknownHostException ex) {
                    this.catchConnectionProblem(ex);
                    continue;
                }
                catch (NoRouteToHostException ex) {
                    this.catchConnectionProblem(ex);
                    continue;
                }
                catch (ConnectException ex) {
                    this.catchConnectionProblem(ex);
                    continue;
                }
                catch (IOException ex) {
                    if (firstRound) {
                        this.catchConnectionProblem(ex);
                        firstRound = false;
                        continue;
                    }
                    LOG.log(Level.WARNING, this.url.toExternalForm(), ex);
                }
                firstRound = true;
                LOG.log(Level.FINE, "doShow, assignInternalURL = {0}", this.url);
                this.assignInternalURL(this.url);
                this.refresh = false;
                Submit submit2 = this;
                synchronized (submit2) {
                    while (this.dialogState.equals((Object)DialogState.CREATED) && !this.refresh) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                if (!this.refresh) break;
                this.url = null;
            }
            LOG.log(Level.FINE, "doShow, dialogCreated, exiting");
        }

        protected final synchronized void doCloseDialog() {
            this.dialogState = DialogState.NON_CREATED;
            this.closeDialog();
            this.notifyAll();
            LOG.log(Level.FINE, "doCloseDialog");
        }

        private void catchConnectionProblem(Exception exception) {
            LOG.log(Level.INFO, this.url.toExternalForm(), exception);
            this.url = this.getUnknownHostExceptionURL();
            this.jpb.setVisible(false);
            this.errorPage = true;
        }

        private URL getUnknownHostExceptionURL() {
            try {
                URL resource = new URL("nbresloc:/org/netbeans/modules/uihandler/UnknownHostException.html");
                return resource;
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
                return this.getClass().getResource("UnknownHostException.html");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DialogState newState = DialogState.CREATED;
            try {
                this.createDialog();
            }
            catch (RuntimeException e) {
                newState = DialogState.FAILED;
                throw e;
            }
            finally {
                Submit submit = this;
                synchronized (submit) {
                    this.dialogState = newState;
                    this.notifyAll();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            LOG.log(Level.FINE, "run, showDialogAndGetValue");
            Object res = this.showDialogAndGetValue(this.dd);
            LOG.log(Level.FINE, "run, showDialogAndGetValue, res = {0}", res);
            if (res == this.exitMsg) {
                this.okToExit = true;
            }
            LOG.log(Level.FINE, "run, okToExit = {0}", this.okToExit);
            this.doCloseDialog();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            final URL[] universalResourceLocator = new URL[1];
            String actionURL = Installer.decodeButtons(e.getSource(), universalResourceLocator, this.dataType);
            LOG.log(Level.FINE, "actionPerformed: command = {0}", e.getActionCommand());
            boolean submit = Button.SUBMIT.isCommand(actionURL);
            if (Button.AUTO_SUBMIT.isCommand(e.getActionCommand())) {
                submit = true;
                if (preferencesWritable) {
                    prefs.putBoolean("autoSubmitWhenFull", true);
                }
            }
            if (submit) {
                JButton button = null;
                if (e.getSource() instanceof JButton) {
                    button = (JButton)e.getSource();
                    button.setEnabled(false);
                }
                final JButton submitButton = button;
                if (this.isSubmiting.getAndSet(true)) {
                    LOG.info("ALREADY SUBMITTING");
                    return;
                }
                if (this.report) {
                    this.reportPanel.showCheckingPassword();
                }
                RP_SUBMIT.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Submit.this.dataType == DataType.DATA_UIGESTURE) {
                            LogRecord userData = Submit.this.getUserData(true, Submit.this.reportPanel);
                            LogRecord thrownLog = Installer.getThrownLog(Submit.this.recs);
                            if (thrownLog != null) {
                                Submit.this.recs.add(thrownLog);
                            }
                            Submit.this.recs.add(BuildInfo.logBuildInfoRec());
                            SlownessData sd = Submit.this.getSlownessData();
                            if (sd != null) {
                                Submit.this.recs.add(sd.getLogRec());
                            } else {
                                Submit.this.recs.add(TimeToFailure.logFailure());
                            }
                            Submit.this.recs.add(userData);
                            if (Submit.this.report && !Submit.this.reportPanel.asAGuest() && !Submit.this.checkUserName(Submit.this.reportPanel)) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        submitButton.setEnabled(true);
                                        Submit.this.reportPanel.showWrongPassword();
                                    }
                                });
                                Submit.this.isSubmiting.set(false);
                                return;
                            }
                            LOG.fine("posting upload UIGESTURES");
                        } else if (Submit.this.dataType == DataType.DATA_METRICS) {
                            LOG.fine("posting upload METRICS");
                        }
                        final List<LogRecord> recsFinal = Submit.this.recs;
                        RP_SUBMIT.post(new Runnable(){

                            @Override
                            public void run() {
                                Submit.this.uploadAndPost(recsFinal, universalResourceLocator[0], Submit.this.dataType, Submit.this.getSlownessData());
                            }
                        });
                        Submit.this.okToExit = false;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Submit.this.doCloseDialog();
                            }
                        });
                    }
                });
                return;
            }
            if (Button.REDIRECT.isCommand(e.getActionCommand())) {
                if (universalResourceLocator[0] != null) {
                    this.showURL(universalResourceLocator[0], false);
                }
                this.doCloseDialog();
                return;
            }
            if (Button.PROXY.isCommand(e.getActionCommand())) {
                if (RP_OPT == null) {
                    RP_OPT = new RequestProcessor("UI Gestures - Show Options");
                }
                RP_OPT.post(new Runnable(){

                    @Override
                    public void run() {
                        OptionsDisplayer.getDefault().open("General");
                    }
                });
            }
            if (Button.REFRESH.isCommand(e.getActionCommand())) {
                this.refresh = true;
                this.errorPage = false;
                Submit submit2 = this;
                synchronized (submit2) {
                    this.notifyAll();
                }
                return;
            }
            if (Button.VIEW_DATA.isCommand(e.getActionCommand())) {
                this.viewData();
                return;
            }
            if (Button.NEVER_AGAIN.isCommand(e.getActionCommand())) {
                LOG.log(Level.FINE, "Assigning ask.never.again.{0} to true", this.msg);
                NbPreferences.forModule(Installer.class).putBoolean("ask.never.again." + this.msg, true);
                this.okToExit = true;
                this.doCloseDialog();
                return;
            }
            if (Button.EXIT.isCommand(e.getActionCommand())) {
                this.doCloseDialog();
                return;
            }
        }

        private boolean checkUserName(ReportPanel panel) {
            this.checkingResult = true;
            try {
                String login = URLEncoder.encode(panel.getUserName(), "UTF-8");
                String encryptedPasswd = URLEncoder.encode(PasswdEncryption.encrypt((String)new String(panel.getPasswdChars())), "UTF-8");
                char[] array = new char[100];
                URL checkingServerURL = new URL(NbBundle.getMessage(Installer.class, (String)"CHECKING_SERVER_URL", (Object)login, (Object)encryptedPasswd));
                URLConnection connection = checkingServerURL.openConnection();
                connection.setRequestProperty("User-Agent", "NetBeans");
                connection.setReadTimeout(20000);
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                int length = reader.read(array);
                this.checkingResult = Boolean.valueOf(new String(array, 0, length));
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (Exception exception) {
                Logger.getLogger(Installer.class.getName()).log(Level.INFO, "Checking password failed", exception);
            }
            return this.checkingResult;
        }

        private void uploadAndPost(List<LogRecord> recs, URL u, DataType dataType, SlownessData slownData) {
            URL nextURL;
            block7: {
                nextURL = null;
                if (preferencesWritable) {
                    prefs.putInt("submitted", 1 + prefs.getInt("submitted", 0));
                }
                try {
                    if (dataType == DataType.DATA_METRICS) {
                        logMetricsUploadFailed = false;
                    }
                    nextURL = Installer.uploadLogs(u, Installer.findIdentity(), Collections.<String, String>emptyMap(), recs, dataType, this.report, slownData, this.isOOM);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                    if (dataType == DataType.DATA_METRICS) {
                        logMetricsUploadFailed = true;
                    }
                    if (dataType == DataType.DATA_METRICS) break block7;
                    String txt = !this.report ? NbBundle.getMessage(Installer.class, (String)"MSG_ConnetionFailed", (Object)u.getHost(), (Object)u.toExternalForm()) : NbBundle.getMessage(Installer.class, (String)"MSG_ConnetionFailedReport", (Object)u.getHost(), (Object)u.toExternalForm());
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)txt, 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                }
            }
            if (dataType == DataType.DATA_METRICS && preferencesWritable) {
                prefs.putBoolean("metrics.upload.failed", logMetricsUploadFailed);
            }
            if (nextURL != null) {
                Installer.clearLogs();
                this.showURL(nextURL, this.report);
            }
        }

        protected final LogRecord getUserData(boolean openPasswd, ReportPanel panel) {
            ArrayList<String> params = new ArrayList<String>(6);
            params.add(Submit.getOS());
            params.add(Submit.getVM());
            params.add(Submit.getVersion());
            if (panel != null) {
                if (panel.asAGuest()) {
                    params.add("");
                } else {
                    params.add(panel.getUserName());
                }
            } else if (this.settings != null) {
                params.add(this.settings.getUserName());
            }
            this.addMoreLogs(params, openPasswd);
            LogRecord userData = new LogRecord(Level.CONFIG, Installer.USER_CONFIGURATION);
            userData.setResourceBundle(NbBundle.getBundle(Installer.class));
            userData.setResourceBundleName(Installer.class.getPackage().getName() + ".Bundle");
            userData.setParameters(params.toArray());
            return userData;
        }

        private static String getOS() {
            String unknown = "unknown";
            String str = System.getProperty("os.name", unknown) + ", " + System.getProperty("os.version", unknown) + ", " + System.getProperty("os.arch", unknown);
            return str;
        }

        private static String getVersion() {
            String str = "";
            try {
                str = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
            }
            catch (MissingResourceException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
            }
            return str;
        }

        private static String getVM() {
            return System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "") + ", " + System.getProperty("java.runtime.name", "unknown") + ", " + System.getProperty("java.runtime.version", "");
        }

        private static enum DialogState {
            NON_CREATED,
            CREATED,
            FAILED;

        }
    }

    private static final class SubmitAutomatic
    extends Submit {
        final Button def;
        private boolean urlComputed;

        public SubmitAutomatic(String msg, Button def, DataType dataType, List<LogRecord> recs) {
            super(msg, dataType, recs);
            this.def = def;
        }

        public SubmitAutomatic(String msg, Button def) {
            this(msg, def, DataType.DATA_UIGESTURE, null);
        }

        @Override
        protected void createDialog() {
        }

        @Override
        protected void closeDialog() {
        }

        @Override
        protected void viewData() {
            assert (false);
        }

        @Override
        protected synchronized void assignInternalURL(URL u) {
            this.urlComputed = true;
            this.notifyAll();
        }

        @Override
        protected void showURL(URL u, boolean inIDE) {
            hintURL = u;
        }

        @Override
        protected void addMoreLogs(List<? super String> params, boolean openPasswd) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object showDialogAndGetValue(final DialogDescriptor dd) {
            while (!this.urlComputed) {
                SubmitAutomatic submitAutomatic = this;
                synchronized (submitAutomatic) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            final JButton[] buttonPtr = new JButton[]{null};
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (Object o : dd.getOptions()) {
                            JButton b;
                            if (!(o instanceof JButton) || !SubmitAutomatic.this.def.isCommand((b = (JButton)o).getActionCommand())) continue;
                            SubmitAutomatic.this.actionPerformed(new ActionEvent(b, 0, b.getActionCommand()));
                            buttonPtr[0] = b;
                            break;
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return DialogDescriptor.CLOSED_OPTION;
        }

        @Override
        protected void alterMessage(DialogDescriptor dd) {
        }

        @Override
        protected SlownessData getSlownessData() {
            return null;
        }
    }

    static final class SubmitInteractive
    extends Submit
    implements HyperlinkListener {
        private boolean connectDialog;
        private Dialog d;
        private SubmitPanel panel;
        private JEditorPane browser;
        private boolean urlAssigned;
        private SlownessData slownData = null;

        public SubmitInteractive(String msg, boolean connectDialog) {
            this(msg, connectDialog, DataType.DATA_UIGESTURE);
        }

        public SubmitInteractive(String msg, boolean connectDialog, DataType dataType) {
            this(msg, connectDialog, dataType, null, null);
        }

        private SubmitInteractive(String msg, boolean connectDialog, DataType dataType, List<LogRecord> recs, SlownessData slownData) {
            super(msg, dataType, recs);
            this.connectDialog = connectDialog;
            this.slownData = slownData;
        }

        @Override
        protected void createDialog() {
            String message = null;
            if (this.slownData != null) {
                String time = Long.toString(this.slownData.getTime());
                message = this.slownData.getSlownessType() != null ? String.format("%1$s took %2$s ms.", this.slownData.getSlownessType(), time) : (this.slownData.getLatestActionName() != null ? String.format("Invoking %1$s took %2$s ms.", this.slownData.getLatestActionName(), time) : String.format("AWT thread blocked for %1$s ms.", time));
            } else {
                Throwable t = Installer.getThrown(this.recs);
                if (t != null && (message = Installer.createMessage(t)).contains("OutOfMemoryError") && Installer.getHeapDump() != null) {
                    this.isOOM = true;
                }
            }
            final String summary = message;
            this.settings = new ExceptionsSettings();
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LOG.log(Level.FINE, "Window system initialized:", WindowManager.getDefault().getMainWindow().isVisible());
                        if (SubmitInteractive.this.reportPanel == null) {
                            SubmitInteractive.this.reportPanel = new ReportPanel(SubmitInteractive.this.isOOM, SubmitInteractive.this.settings);
                        }
                        if (summary != null) {
                            SubmitInteractive.this.reportPanel.setSummary(summary);
                        }
                        Dimension dim = new Dimension(350, 50);
                        if ("ERROR_URL".equals(SubmitInteractive.this.msg)) {
                            dim = new Dimension(370, 250);
                        }
                        SubmitInteractive.this.browser = new JEditorPane();
                        try {
                            SubmitInteractive.this.browser.setEditable(false);
                            try {
                                URL resource = new URL("nbresloc:/org/netbeans/modules/uihandler/Connecting.html");
                                SubmitInteractive.this.browser.setPage(resource);
                            }
                            catch (IOException ex) {
                                LOG.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                            SubmitInteractive.this.browser.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
                            SubmitInteractive.this.browser.setPreferredSize(dim);
                            SubmitInteractive.this.browser.setBackground(new JLabel().getBackground());
                            SubmitInteractive.this.browser.addHyperlinkListener(SubmitInteractive.this);
                        }
                        catch (NullPointerException x) {
                            LOG.log(Level.WARNING, "Java bug #7050995?", x);
                        }
                        JScrollPane p = new JScrollPane();
                        p.setViewportView(SubmitInteractive.this.browser);
                        p.setBorder(BorderFactory.createEmptyBorder());
                        p.setPreferredSize(dim);
                        DialogDescriptor descr = SubmitInteractive.this.findDD();
                        JPanel jp = new JPanel();
                        BoxLayout l = new BoxLayout(jp, 1);
                        jp.setLayout(l);
                        SubmitInteractive.this.jpb.setVisible(true);
                        SubmitInteractive.this.jpb.setIndeterminate(true);
                        jp.add(p);
                        jp.add(SubmitInteractive.this.jpb);
                        descr.setMessage((Object)jp);
                        Object[] arr = new Object[]{SubmitInteractive.this.exitMsg};
                        descr.setOptions(arr);
                        descr.setClosingOptions(arr);
                        descr.setButtonListener((ActionListener)SubmitInteractive.this);
                        descr.setModal(true);
                        SubmitInteractive.this.d = DialogDisplayer.getDefault().createDialog(descr);
                    }
                });
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
            assert (this.d != null);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.showURL(e.getURL(), false);
            }
        }

        @Override
        protected void closeDialog() {
            if (this.d == null) {
                return;
            }
            this.reportPanel.saveUserData();
            RP_UI.post(new Runnable(){

                @Override
                public void run() {
                    SubmitInteractive.this.settings.save();
                }
            });
            this.dd.setValue(DialogDescriptor.CLOSED_OPTION);
            this.d.setVisible(false);
            this.d.dispose();
            this.d = null;
        }

        private void procesLog(LogRecord r, LinkedList<Node> nodes, StringBuilder builder) {
            Node n = UINode.create(r);
            nodes.add(n);
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int offset = builder.length();
                n.setValue("offset", (Object)offset);
                LogRecords.write((OutputStream)os, (LogRecord)r);
                builder.append(os.toString("UTF-8"));
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }

        @Override
        protected void viewData() {
            DialogDescriptor viewDD;
            if (this.panel == null) {
                TimeToFailure.logAction();
                this.panel = new SubmitPanel();
                RequestProcessor.getDefault().post((Runnable)new DataLoader());
                this.panel.setText(NbBundle.getMessage(Installer.class, (String)"LOADING_TEXT"));
                this.panel.getExplorerManager().setRootContext(Node.EMPTY);
            }
            if (!this.report) {
                viewDD = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(Installer.class, (String)"VIEW_DATA_TILTE"));
            } else {
                Installer.flushSystemLogs();
                JTabbedPane tabs = new JTabbedPane();
                tabs.addTab(NbBundle.getMessage(Installer.class, (String)"UI_TAB_TITLE"), this.panel);
                tabs.setPreferredSize(this.panel.getPreferredSize());
                File messagesLog = Installer.getMessagesLog();
                try {
                    JEditorPane pane = new JEditorPane(Utilities.toURI((File)messagesLog).toURL());
                    pane.setEditable(false);
                    pane.setPreferredSize(this.panel.getPreferredSize());
                    tabs.addTab(NbBundle.getMessage(Installer.class, (String)"IDE_LOG_TAB_TITLE"), new JScrollPane(pane));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                viewDD = new DialogDescriptor((Object)tabs, NbBundle.getMessage(Installer.class, (String)"VIEW_DATA_TILTE"));
            }
            viewDD.setModal(false);
            Object[] closingOption = new Object[]{DialogDescriptor.CANCEL_OPTION};
            viewDD.setOptions(closingOption);
            viewDD.setClosingOptions(closingOption);
            ArrayList<JButton> additionalButtons = new ArrayList<JButton>();
            if (this.slownData != null) {
                JButton slownButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)slownButton, (String)NbBundle.getMessage(Installer.class, (String)"SubmitPanel.profileData.text"));
                slownButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SubmitInteractive.this.showProfilerSnapshot(e);
                    }
                });
                additionalButtons.add(slownButton);
            }
            if (this.isOOM) {
                JButton heapDumpButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)heapDumpButton, (String)NbBundle.getMessage(Installer.class, (String)"SubmitPanel.heapDump.text"));
                heapDumpButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SubmitInteractive.this.showHeapDump(e);
                    }
                });
            }
            viewDD.setAdditionalOptions(additionalButtons.toArray());
            Dialog view = DialogDisplayer.getDefault().createDialog(viewDD);
            view.setVisible(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showProfilerSnapshot(ActionEvent e) {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("selfsampler", ".npss");
                tempFile = FileUtil.normalizeFile((File)tempFile);
                FileOutputStream os = new FileOutputStream(tempFile);
                ((OutputStream)os).write(this.slownData.getNpsContent());
                ((OutputStream)os).close();
                File gestures = new File(new File(new File(new File(System.getProperty("netbeans.user")), "var"), "log"), "uigestures");
                SelfSampleVFS fs = gestures.exists() ? new SelfSampleVFS(new String[]{"selfsampler.npss", "selfsampler.log"}, new File[]{tempFile, gestures}) : new SelfSampleVFS(new String[]{"selfsampler.npss"}, new File[]{tempFile});
                FileObject fo = fs.findResource("selfsampler.npss");
                Node obj = DataObject.find((FileObject)fo).getNodeDelegate();
                Action a = obj.getPreferredAction();
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(obj.getLookup());
                }
                a.actionPerformed(e);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (tempFile != null) {
                    tempFile.deleteOnExit();
                }
            }
        }

        private void showHeapDump(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void assignInternalURL(final URL u) {
            if (this.browser != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SubmitInteractive.this.browser.setPage(u);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            this.markAssigned();
        }

        private synchronized void markAssigned() {
            this.urlAssigned = true;
            this.notifyAll();
        }

        @Override
        protected void showURL(URL u, boolean inIDE) {
            LOG.log(Level.FINE, "opening URL: {0}", u);
            if (inIDE) {
                ReporterResultTopComponent.showUploadDone(u);
            } else {
                HtmlBrowser.URLDisplayer.getDefault().showURL(u);
            }
        }

        @Override
        protected void addMoreLogs(List<? super String> params, boolean openPasswd) {
            if (this.reportPanel != null && this.report) {
                params.add(this.reportPanel.getSummary());
                params.add(this.reportPanel.getComment());
                try {
                    char[] passwd = this.reportPanel.getPasswdChars();
                    if (openPasswd && passwd.length != 0 && !this.reportPanel.asAGuest()) {
                        String pwd = new String(passwd);
                        pwd = PasswdEncryption.encrypt((String)pwd);
                        params.add(pwd);
                    } else {
                        params.add("*********");
                    }
                }
                catch (GeneralSecurityException exc) {
                    LOG.log(Level.WARNING, "PASSWORD ENCRYPTION ERROR", exc);
                }
                catch (IOException exc) {
                    LOG.log(Level.WARNING, "PASSWORD ENCRYPTION ERROR", exc);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object showDialogAndGetValue(DialogDescriptor dd) {
            SubmitInteractive submitInteractive;
            if (!this.connectDialog) {
                submitInteractive = this;
                synchronized (submitInteractive) {
                    while (!this.urlAssigned) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            this.d.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    SubmitInteractive.this.doCloseDialog();
                }
            });
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SubmitInteractive.this.d.setModal(false);
                        SubmitInteractive.this.d.setVisible(true);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            submitInteractive = this;
            synchronized (submitInteractive) {
                while (this.d != null && !dontWaitForUserInputInTests) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return dd.getValue();
        }

        @Override
        protected void alterMessage(final DialogDescriptor dd) {
            if ("ERROR_URL".equals(this.msg) & dd.getOptions().length > 1) {
                Object obj = dd.getOptions()[0];
                AbstractButton abut = null;
                String rptr = null;
                if (obj instanceof AbstractButton) {
                    abut = (AbstractButton)obj;
                }
                if (abut != null) {
                    rptr = (String)abut.getClientProperty("alt");
                }
                if (this.reportPanel != null && "reportDialog".equals(rptr) && !this.errorPage) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dd.setMessage((Object)SubmitInteractive.this.reportPanel);
                            SubmitInteractive.this.reportPanel.setInitialFocus();
                        }
                    });
                }
            }
        }

        @Override
        protected SlownessData getSlownessData() {
            return this.slownData;
        }

        private class DataLoader
        implements Runnable {
            private final StringBuilder panelContent = new StringBuilder();
            private final AbstractNode root = new AbstractNode((Children)new Children.Array());

            private DataLoader() {
            }

            @Override
            public void run() {
                if (EventQueue.isDispatchThread()) {
                    SubmitInteractive.this.panel.setText(this.panelContent.toString());
                    SubmitInteractive.this.panel.getExplorerManager().setRootContext((Node)this.root);
                } else {
                    ArrayList displayedRecords = new ArrayList(SubmitInteractive.this.recs);
                    LinkedList nodes = new LinkedList();
                    this.root.setName("root");
                    this.root.setDisplayName(NbBundle.getMessage(Installer.class, (String)"MSG_RootDisplayName", (Object)(displayedRecords.size() + 1), (Object)new Date()));
                    this.root.setIconBaseWithExtension("org/netbeans/modules/uihandler/logs.gif");
                    for (LogRecord r : displayedRecords) {
                        SubmitInteractive.this.procesLog(r, nodes, this.panelContent);
                    }
                    SubmitInteractive.this.procesLog(SubmitInteractive.this.getUserData(false, SubmitInteractive.this.reportPanel), nodes, this.panelContent);
                    this.root.getChildren().add(nodes.toArray(new Node[0]));
                    EventQueue.invokeLater(this);
                }
            }
        }
    }
}

