/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SourceCodeCommentParser {
    private SourceParser parser;

    public SourceCodeCommentParser() {
        this.parser = new SourceParser();
    }

    public SourceCodeCommentParser(String lineComment, String blockStart, String blockEnd) {
        this.parser = new CommentParser(lineComment, blockStart, blockEnd);
    }

    public void setText(String text) {
        this.parser.setText(text);
    }

    public boolean nextRegion(CommentRegion reg) throws IOException {
        return this.parser.nextRegion(reg);
    }

    private static class CommentParser
    extends SourceParser {
        protected String lineComment;
        protected String blockStart;
        protected String blockEnd;

        public CommentParser(String lineComment) {
            this(lineComment, null, null);
        }

        public CommentParser(String lineComment, String blockStart, String blockEnd) {
            this.lineComment = lineComment;
            this.blockStart = blockStart;
            this.blockEnd = blockEnd;
            StringBuffer sb = new StringBuffer();
            boolean needor = false;
            if (lineComment != null) {
                this.appendEncodedChars(sb, lineComment);
                needor = true;
            }
            if (blockStart != null) {
                if (needor) {
                    sb.append('|');
                }
                this.appendEncodedChars(sb, blockStart);
            }
            this.pattern = Pattern.compile(sb.toString());
            this.matcher = null;
        }

        @Override
        public boolean nextRegion(CommentRegion reg) throws IOException {
            boolean ret = false;
            if (this.matcher != null && this.matcher.find(this.curr)) {
                String token = this.text.substring(this.matcher.start(), this.matcher.end());
                reg.start = this.matcher.start();
                if (this.lineComment != null && this.lineComment.equals(token)) {
                    int idx = this.text.indexOf("\n", reg.start);
                    reg.stop = idx != -1 ? idx : this.text.length();
                } else if (this.blockStart != null) {
                    int idx = this.text.indexOf(this.blockEnd, reg.start);
                    reg.stop = idx != -1 ? idx + this.blockEnd.length() : this.text.length();
                } else {
                    return false;
                }
                this.curr = reg.stop + 1;
                ret = true;
            }
            return ret;
        }
    }

    static class CommentRegion {
        public int start = 0;
        public int stop = 0;
    }

    private static class SourceParser {
        protected String text = null;
        protected int curr = 0;
        protected Matcher matcher = null;
        protected Pattern pattern;

        public boolean nextRegion(CommentRegion reg) throws IOException {
            if (this.text == null) {
                return false;
            }
            reg.start = this.curr;
            reg.stop = this.text.length();
            if (reg.start == reg.stop) {
                return false;
            }
            this.curr = reg.stop;
            return true;
        }

        public void setText(String text) {
            this.text = text;
            if (this.pattern != null) {
                this.matcher = this.pattern.matcher(text);
            }
        }

        protected void appendEncodedChars(StringBuffer buf, String str) {
            int len = str.length();
            for (int ii = 0; ii < len; ++ii) {
                String s = Integer.toHexString(str.charAt(ii));
                buf.append("\\u");
                int n = 4 - s.length();
                for (int i = 0; i < n; ++i) {
                    buf.append('0');
                }
                buf.append(s);
            }
        }
    }
}

