/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Status;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlStatus
implements ISVNStatus {
    protected Status _s;
    private SVNRevision.Number lastChangedRevision;
    private String lastChangedAuthor;
    private Date lastChangedDate;
    private boolean treeConflict = false;
    private ConflictDescriptor conflictDescriptor;
    private String conflictOld;
    private String conflictWorking;
    private String conflictNew;

    public JhlStatus(Status status, ISVNClient client) {
        this._s = status;
        try {
            if (client != null && this._s.isConflicted()) {
                this.populateInfo(client, this._s.getPath());
            }
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void populateInfo(ISVNClient aClient, String path) throws ClientException {
        class MyInfoCallback
        implements InfoCallback {
            Info info;

            MyInfoCallback() {
            }

            public void singleInfo(Info aInfo) {
                this.info = aInfo;
            }

            public Info getInfo() {
                return this.info;
            }
        }
        MyInfoCallback callback = new MyInfoCallback();
        aClient.info2(path, null, null, Depth.empty, null, (InfoCallback)callback);
        Info aInfo = callback.getInfo();
        if (aInfo == null) {
            return;
        }
        if (aInfo.getConflicts() != null) {
            for (ConflictDescriptor conflict : aInfo.getConflicts()) {
                switch (conflict.getKind()) {
                    case tree: {
                        this.treeConflict = true;
                        this.conflictDescriptor = conflict;
                        break;
                    }
                    case text: {
                        this.conflictOld = conflict.getBasePath();
                        this.conflictWorking = conflict.getMyPath();
                        this.conflictNew = conflict.getTheirPath();
                        break;
                    }
                }
            }
        }
    }

    public SVNUrl getUrl() {
        try {
            return this._s.getUrl() != null ? new SVNUrl(this._s.getUrl()) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getUrlString() {
        return this._s.getUrl();
    }

    public SVNRevision.Number getLastChangedRevision() {
        if (this.lastChangedRevision != null) {
            return this.lastChangedRevision;
        }
        if (this._s.getReposLastCmtAuthor() == null) {
            return JhlConverter.convertRevisionNumber(this._s.getLastChangedRevisionNumber());
        }
        if (this._s.getReposLastCmtRevisionNumber() == 0L) {
            return null;
        }
        return JhlConverter.convertRevisionNumber(this._s.getReposLastCmtRevisionNumber());
    }

    public SVNRevision.Number getReposLastChangedRevision() {
        return JhlConverter.convertRevisionNumber(this._s.getReposLastCmtRevisionNumber());
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate != null) {
            return this.lastChangedDate;
        }
        if (this._s.getReposLastCmtAuthor() == null) {
            return this._s.getLastChangedDate();
        }
        return this._s.getReposLastCmtDate();
    }

    public String getLastCommitAuthor() {
        if (this.lastChangedAuthor != null) {
            return this.lastChangedAuthor;
        }
        if (this._s.getReposLastCmtAuthor() == null) {
            return this._s.getLastCommitAuthor();
        }
        return this._s.getReposLastCmtAuthor();
    }

    public SVNStatusKind getTextStatus() {
        return JhlConverter.convertStatusKind(this._s.getTextStatus());
    }

    public SVNStatusKind getPropStatus() {
        return JhlConverter.convertStatusKind(this._s.getPropStatus());
    }

    public SVNRevision.Number getRevision() {
        return JhlConverter.convertRevisionNumber(this._s.getRevisionNumber());
    }

    public boolean isCopied() {
        return this._s.isCopied();
    }

    public boolean isWcLocked() {
        return this._s.isLocked();
    }

    public boolean isSwitched() {
        return this._s.isSwitched();
    }

    public String getPath() {
        return this._s.getPath();
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public SVNNodeKind getNodeKind() {
        SVNNodeKind nodeKind = this._s.getReposLastCmtAuthor() == null ? JhlConverter.convertNodeKind(this._s.getNodeKind()) : JhlConverter.convertNodeKind(this._s.getReposKind());
        return nodeKind;
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return JhlConverter.convertStatusKind(this._s.getRepositoryTextStatus());
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return JhlConverter.convertStatusKind(this._s.getRepositoryPropStatus());
    }

    public String toString() {
        return this.getPath() + " " + this.getTextStatus().toString();
    }

    public File getConflictNew() {
        String path = this.conflictNew;
        return path != null ? new File(path).getAbsoluteFile() : null;
    }

    public File getConflictOld() {
        String path = this.conflictOld;
        return path != null ? new File(path).getAbsoluteFile() : null;
    }

    public File getConflictWorking() {
        String path = this.conflictWorking;
        return path != null ? new File(path).getAbsoluteFile() : null;
    }

    public Date getLockCreationDate() {
        if (this._s.getLocalLock() == null) {
            return null;
        }
        return this._s.getLocalLock().getCreationDate();
    }

    public String getLockOwner() {
        if (this._s.getLocalLock() == null) {
            return null;
        }
        return this._s.getLocalLock().getOwner();
    }

    public String getLockComment() {
        if (this._s.getLocalLock() == null) {
            return null;
        }
        return this._s.getLocalLock().getComment();
    }

    public boolean hasTreeConflict() {
        return this.treeConflict;
    }

    public boolean isFileExternal() {
        return this._s.isFileExternal();
    }

    public SVNConflictDescriptor getConflictDescriptor() {
        return JhlConverter.convertConflictDescriptor(this.conflictDescriptor);
    }

    public void updateFromStatus(JhlStatus info) {
        this.lastChangedRevision = info.getLastChangedRevision();
        this.lastChangedAuthor = info.getLastCommitAuthor();
        this.lastChangedDate = info.getLastChangedDate();
    }

    public static class JhlStatusExternal
    extends JhlStatus {
        public JhlStatusExternal(JhlStatus status, ISVNClient client) {
            super(status._s, client);
        }

        public SVNStatusKind getTextStatus() {
            return SVNStatusKind.EXTERNAL;
        }
    }
}

