/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebAppMetadataHelper;
import org.netbeans.modules.web.project.ui.ServletScanObserver;
import org.netbeans.modules.web.project.ui.ServletUriPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public final class SetExecutionUriAction
extends NodeAction {
    private static final String IS_SERVLET_FILE = "org.netbeans.modules.web.IsServletFile";
    public static final String ATTR_EXECUTION_URI = "execution.uri";
    private static final MarkerClass MARKER = new MarkerClass();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] activatedNodes) {
        DataObject data;
        if (activatedNodes == null || activatedNodes.length != 1 || activatedNodes[0] == null || (data = (DataObject)activatedNodes[0].getCookie(DataObject.class)) == null) return;
        FileObject servletFo = data.getPrimaryFile();
        WebModule webModule = WebModule.getWebModule((FileObject)servletFo);
        String[] urlPatterns = SetExecutionUriAction.getServletMappings(webModule, servletFo);
        if (urlPatterns != null && urlPatterns.length > 0) {
            String oldUri = (String)servletFo.getAttribute(ATTR_EXECUTION_URI);
            ServletUriPanel uriPanel = new ServletUriPanel(urlPatterns, oldUri, false);
            DialogDescriptor desc = new DialogDescriptor((Object)uriPanel, NbBundle.getMessage(SetExecutionUriAction.class, (String)"TTL_setServletExecutionUri"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            if (!res.equals(NotifyDescriptor.YES_OPTION)) return;
            try {
                servletFo.setAttribute(ATTR_EXECUTION_URI, (Object)uriPanel.getServletUri());
                return;
            }
            catch (IOException ex) {}
            return;
        } else {
            String mes = MessageFormat.format(NbBundle.getMessage(SetExecutionUriAction.class, (String)"TXT_missingServletMappings"), servletFo.getName());
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        DataObject data;
        if (activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0] != null && (data = (DataObject)activatedNodes[0].getCookie(DataObject.class)) != null) {
            FileObject javaClass = data.getPrimaryFile();
            WebModule webModule = WebModule.getWebModule((FileObject)javaClass);
            if (SetExecutionUriAction.servletFilesScanning(webModule, javaClass)) {
                return false;
            }
            String mimetype = javaClass.getMIMEType();
            if (!"text/x-java".equals(mimetype)) {
                return false;
            }
            Boolean servletAttr = (Boolean)javaClass.getAttribute(IS_SERVLET_FILE);
            if (!Boolean.TRUE.equals(servletAttr)) {
                boolean isServletFile = SetExecutionUriAction.isServletFile(webModule, javaClass, false);
                if (isServletFile) {
                    try {
                        javaClass.setAttribute(IS_SERVLET_FILE, (Object)Boolean.TRUE);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                servletAttr = isServletFile;
            }
            return Boolean.TRUE.equals(servletAttr);
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SetExecutionUriAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(SetExecutionUriAction.class, (String)"LBL_serveltExecutionUriAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/web/project/ui/resources/servletUri.gif";
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isScanInProgress(WebModule webModule, FileObject fileObject, final ServletScanObserver observer) {
        boolean isScan;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ProjectWebModule prjWebModule = null;
        if (project != null) {
            prjWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
        }
        boolean bl = isScan = project != null;
        if (isScan) {
            isScan = SetExecutionUriAction.servletFilesScanning(webModule, fileObject);
            if (!isScan) {
                return false;
            }
            final ProjectWebModule source = prjWebModule;
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    MarkerClass marker;
                    String name = event.getPropertyName();
                    if ("lookup.item".equals(name) && event.getNewValue() != null && event.getNewValue() != MARKER && (marker = (MarkerClass)source.getLookup().lookup(MarkerClass.class)) != null && marker != MARKER && observer != null) {
                        observer.scanFinished();
                        source.removePropertyChangeListener(this);
                    }
                }
            };
            prjWebModule.addPropertyChangeListener(listener);
            isScan = SetExecutionUriAction.servletFilesScanning(webModule, fileObject);
            if (!isScan) {
                prjWebModule.removePropertyChangeListener(listener);
            }
        } else {
            isScan = false;
        }
        return isScan;
    }

    public static String[] getServletMappings(WebModule webModule, FileObject javaClass) {
        assert (SetExecutionUriAction.checkScanFinished(webModule, javaClass));
        if (webModule == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)javaClass, (String)"classpath/source");
        String className = classPath.getResourceName(javaClass, '.', false);
        try {
            List<ServletInfo> servlets = WebAppMetadataHelper.getServlets((MetadataModel<WebAppMetadata>)webModule.getMetadataModel());
            ArrayList mappingList = new ArrayList();
            for (ServletInfo si : servlets) {
                if (!className.equals(si.getServletClass())) continue;
                mappingList.addAll(si.getUrlPatterns());
            }
            String[] mappings = new String[mappingList.size()];
            mappingList.toArray(mappings);
            return mappings;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean checkScanFinished(WebModule webModule, FileObject fileObject) {
        ProjectWebModule prjWebModule;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (prjWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class)) != null) {
            MarkerClass marker = (MarkerClass)prjWebModule.getLookup().lookup(MarkerClass.class);
            return marker != null && marker != MARKER;
        }
        return true;
    }

    private static boolean servletFilesScanning(final WebModule webModule, final FileObject fileObject) {
        ProjectWebModule prjWebModule;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (prjWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class)) != null) {
            MarkerClass marker = (MarkerClass)prjWebModule.getLookup().lookup(MarkerClass.class);
            if (marker == null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SetExecutionUriAction.isServletFile(webModule, fileObject, true);
                        prjWebModule.removeCookie(MARKER);
                        prjWebModule.addCookie(new MarkerClass());
                    }
                };
                if (prjWebModule.getLookup().lookup(MarkerClass.class) == null) {
                    RequestProcessor.getDefault().post(runnable);
                    prjWebModule.addCookie(MARKER);
                }
                return true;
            }
            return marker == MARKER;
        }
        return false;
    }

    private static boolean isServletFile(WebModule webModule, FileObject javaClass, boolean initialScan) {
        if (webModule == null) {
            return false;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)javaClass, (String)"classpath/source");
        if (classPath == null) {
            return false;
        }
        String className = classPath.getResourceName(javaClass, '.', false);
        if (className == null) {
            return false;
        }
        try {
            MetadataModel metadataModel = webModule.getMetadataModel();
            boolean result = false;
            if (initialScan || metadataModel.isReady()) {
                List<ServletInfo> servlets = WebAppMetadataHelper.getServlets((MetadataModel<WebAppMetadata>)metadataModel);
                ArrayList<String> servletClasses = new ArrayList<String>(servlets.size());
                for (ServletInfo si : servlets) {
                    if (className.equals(si.getServletClass())) {
                        result = true;
                        continue;
                    }
                    servletClasses.add(si.getServletClass());
                }
                SetExecutionUriAction.setServletClasses(servletClasses, javaClass, initialScan);
            }
            return result;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static void setServletClasses(final List<String> servletClasses, final FileObject orig, boolean initial) {
        if (initial) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)orig);
            if (javaSource == null) {
                return;
            }
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        for (String servletClass : servletClasses) {
                            ElementHandle handle;
                            FileObject fileObject;
                            TypeElement typeElem = controller.getElements().getTypeElement(servletClass);
                            if (typeElem == null || (fileObject = SourceUtils.getFile((ElementHandle)(handle = ElementHandle.create((Element)typeElem)), (ClasspathInfo)controller.getClasspathInfo())) == null || Boolean.TRUE.equals(fileObject.getAttribute(SetExecutionUriAction.IS_SERVLET_FILE))) continue;
                            fileObject.setAttribute(SetExecutionUriAction.IS_SERVLET_FILE, (Object)Boolean.TRUE);
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SetExecutionUriAction.setServletClasses(servletClasses, orig, true);
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
    }

    private static class MarkerClass {
        private MarkerClass() {
        }
    }
}

