/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class EjbsNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        WebProject webProject = (WebProject)project.getLookup().lookup(WebProject.class);
        assert (webProject != null);
        return new EjbNodeList(webProject);
    }

    private static class EjbNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String KEY_EJBS = "ejbKey";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node view = null;
        private boolean isViewEmpty = true;
        private final J2eeProjectCapabilities projectCap;
        private static final RequestProcessor rp = new RequestProcessor();
        private RequestProcessor.Task checkTask = null;

        EjbNodeList(WebProject webProject) {
            this.project = webProject;
            this.projectCap = J2eeProjectCapabilities.forProject((Project)this.project);
        }

        public List<String> keys() {
            if (this.projectCap.isEjb31LiteSupported()) {
                this.checkView();
            }
            if (!this.isViewEmpty) {
                return Collections.singletonList(KEY_EJBS);
            }
            return Collections.EMPTY_LIST;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(String string) {
            if (KEY_EJBS.equals(string)) {
                return this.view;
            }
            return null;
        }

        public void addNotify() {
            if (this.projectCap.isEjb31LiteSupported()) {
                EjbJar ejbJar = this.project.getAPIEjbJar();
                this.view = J2eeProjectView.createEjbsView((EjbJar)ejbJar, (Project)this.project);
            }
            this.project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.project.evaluator().removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && (string.equals("j2ee.platform") || string.startsWith("/EnterpriseBeans/"))) {
                this.fireChange();
            }
        }

        private void fireChange() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EjbNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private synchronized void checkView() {
            if (this.checkTask != null) {
                this.checkTask.schedule(100);
                return;
            }
            this.checkTask = rp.post(new Runnable(){

                @Override
                public void run() {
                    Boolean bl = Boolean.TRUE;
                    try {
                        Future future = EjbNodeList.this.project.getAPIEjbJar().getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Boolean>(){

                            public Boolean run(EjbJarMetadata ejbJarMetadata) {
                                EnterpriseBeans enterpriseBeans;
                                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = ejbJarMetadata.getRoot();
                                if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
                                    enterpriseBeans.removePropertyChangeListener((PropertyChangeListener)EjbNodeList.this);
                                    enterpriseBeans.addPropertyChangeListener((PropertyChangeListener)EjbNodeList.this);
                                    if (enterpriseBeans.getEjbs().length > 0) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return Boolean.TRUE;
                            }
                        });
                        bl = (Boolean)future.get();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Exceptions.printStackTrace((Throwable)executionException);
                    }
                    if (bl ^ EjbNodeList.this.isViewEmpty) {
                        EjbNodeList.this.isViewEmpty = bl;
                        EjbNodeList.this.fireChange();
                    }
                }
            }, 100);
        }
    }
}

