/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.jaxws;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.WebProjectWebServicesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.ProjectJAXWSSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectJAXWSSupport
extends ProjectJAXWSSupport {
    private WebProject project;
    private static final String servletClassName = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String servletListener = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";

    public WebProjectJAXWSSupport(WebProject webProject, AntProjectHelper antProjectHelper) {
        super((Project)webProject, antProjectHelper);
        this.project = webProject;
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        FileObject fileObject;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (fileObject = webModule.getWebInf()) != null) {
            FileObject fileObject2 = fileObject.getFileObject("wsdl");
            if (fileObject2 != null) {
                return fileObject2;
            }
            if (bl) {
                return fileObject.createFolder("wsdl");
            }
        }
        return null;
    }

    public String getWsdlLocation(String string) {
        String string2;
        String string3;
        String string4 = string + ".wsdl";
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (string3 = jaxWsModel.findServiceByName(string)) != null && (string2 = string3.getLocalWsdlFile()) != null) {
            string4 = string2;
        }
        string3 = "WEB-INF/wsdl/";
        return string3 + string + "/" + string4;
    }

    private void addServiceEntriesToDD(String string) {
        String string2 = string;
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            Servlet servlet = null;
            Listener listener = null;
            try {
                servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{string2, servletClassName}, "ServletName");
                servlet.setLoadOnStartup(new BigInteger("1"));
                ServletMapping servletMapping = (ServletMapping)webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{string2, "/" + string}, "ServletName");
                if (!this.webAppHasListener(webApp, servletListener)) {
                    listener = (Listener)webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{servletListener}, "ListenerClass");
                }
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, classNotFoundException.getLocalizedMessage());
            }
            catch (NameAlreadyUsedException nameAlreadyUsedException) {
                Logger.getLogger("global").log(Level.INFO, nameAlreadyUsedException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, iOException.getLocalizedMessage());
            }
        }
    }

    protected void addServletElement(Project project, String string, String string2) throws IOException {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            J2eePlatform j2eePlatform;
            Map map;
            String string3;
            boolean bl = false;
            JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
            if (jAXWSSupport != null && (string3 = (String)(map = jAXWSSupport.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(string3)) != null && j2eePlatform.isToolSupported("JaxWs-in-j2ee14-supported")) {
                bl = true;
            }
            if (bl) {
                try {
                    map = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{string, string2}, "ServletName");
                    map.setLoadOnStartup(new BigInteger("1"));
                    string3 = (ServletMapping)webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{string, "/" + string}, "UrlPattern");
                    webApp.write(this.getDeploymentDescriptor());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger("global").log(Level.INFO, classNotFoundException.getLocalizedMessage());
                }
                catch (NameAlreadyUsedException nameAlreadyUsedException) {
                    Logger.getLogger("global").log(Level.INFO, nameAlreadyUsedException.getLocalizedMessage());
                }
            }
        }
    }

    private void removeServiceEntriesFromDD(String string) {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            boolean bl = this.removeNonJsr109ServletsFromDD(webApp, string);
            boolean bl2 = false;
            Servlet[] servletArray = webApp.getServlet();
            for (int i = 0; i < servletArray.length; ++i) {
                if (!servletArray[i].getServletClass().equals(servletClassName)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                Listener[] listenerArray = webApp.getListener();
                for (int i = 0; i < listenerArray.length; ++i) {
                    Listener listener = listenerArray[i];
                    if (!listener.getListenerClass().equals(servletListener)) continue;
                    webApp.removeListener(listener);
                    bl = true;
                    break;
                }
            }
            if (bl) {
                try {
                    webApp.write(this.getDeploymentDescriptor());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private boolean removeNonJsr109ServletsFromDD(WebApp webApp, String string) {
        boolean bl = false;
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            Servlet servlet = servletArray[i];
            if (!servlet.getServletName().equals(string)) continue;
            webApp.removeServlet(servlet);
            bl = true;
            break;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            ServletMapping servletMapping = servletMappingArray[i];
            if (!servletMapping.getServletName().equals(string)) continue;
            webApp.removeServletMapping(servletMapping);
            bl = true;
        }
        return bl;
    }

    private boolean webAppHasListener(WebApp webApp, String string) {
        Listener[] listenerArray = webApp.getListener();
        for (int i = 0; i < listenerArray.length; ++i) {
            Listener listener = listenerArray[i];
            if (!string.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    public FileObject getDeploymentDescriptorFolder() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            return webModule.getWebInf();
        }
        return null;
    }

    private WebApp getWebApp() {
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject != null) {
                return DDProvider.getDefault().getDDRoot(fileObject);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, iOException.getLocalizedMessage());
        }
        return null;
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!projectArray[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    private FileObject getDeploymentDescriptor() throws IOException {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            FileObject fileObject;
            FileObject fileObject2 = webModule.getDeploymentDescriptor();
            if (fileObject2 == null && (fileObject = webModule.getWebInf()) != null) {
                fileObject2 = DDHelper.createWebXml((Profile)webModule.getJ2eeProfile(), (FileObject)fileObject);
            }
            return fileObject2;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJaxwsArtifacts(Project project, String string, String string2) throws Exception {
        Library library;
        FileObject fileObject;
        Object object;
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        if (sourceGroupArray.length > 0 && (object = (fileObject = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile")).findResource("com/sun/tools/ws/ant/WsImport.class")) == null) {
            library = LibraryManager.getDefault().getLibrary("metro");
            if (library != null) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException iOException) {
                    throw new Exception("Unable to add Metro library", iOException);
                }
            } else {
                throw new Exception("Unable to add Metro Library");
            }
        }
        this.addServiceEntriesToDD(string);
        fileObject = this.getDeploymentDescriptorFolder();
        if (fileObject != null) {
            object = fileObject.getFileObject("sun-jaxws.xml");
            if (object == null) {
                WSUtils.generateSunJaxwsFile((FileObject)fileObject);
            }
            object = fileObject.getFileObject("sun-jaxws.xml");
            library = EndpointsProvider.getDefault().getEndpoints(object);
            Endpoint endpoint = library.newEndpoint();
            endpoint.setEndpointName(string);
            endpoint.setImplementation(string2);
            endpoint.setUrlPattern("/" + string);
            library.addEnpoint(endpoint);
            FileLock fileLock = null;
            OutputStream outputStream = null;
            WebProjectJAXWSSupport webProjectJAXWSSupport = this;
            synchronized (webProjectJAXWSSupport) {
                try {
                    fileLock = object.lock();
                    outputStream = object.getOutputStream(fileLock);
                    library.write(outputStream);
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
        }
        object = NbBundle.getMessage(WebProjectJAXWSSupport.class, (String)"MSG_CannotFindWEB-INF");
        library = new NotifyDescriptor.Message(object, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)library);
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getWebModule().getConfDir();
    }

    public void serviceFromJavaRemoved(String string) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Boolean bl = jaxWsModel.getJsr109();
        if (bl != null && !bl.booleanValue()) {
            try {
                this.removeNonJsr109Entries(string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            try {
                this.removeJsr109Entries(string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNonJsr109Entries(String string) throws IOException {
        this.removeServiceEntriesFromDD(string);
        FileObject fileObject = this.getDeploymentDescriptorFolder();
        if (fileObject != null) {
            FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
            if (fileObject2 != null) {
                FileLock fileLock = null;
                JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
                if (jaxWsModel.getServices().length == 0) {
                    WebProjectJAXWSSupport webProjectJAXWSSupport = this;
                    synchronized (webProjectJAXWSSupport) {
                        try {
                            fileLock = fileObject2.lock();
                            fileObject2.delete(fileLock);
                        }
                        finally {
                            if (fileLock != null) {
                                fileLock.releaseLock();
                            }
                        }
                    }
                }
                Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject2);
                Endpoint endpoint = endpoints.findEndpointByName(string);
                if (endpoint != null) {
                    endpoints.removeEndpoint(endpoint);
                    OutputStream outputStream = null;
                    WebProjectJAXWSSupport webProjectJAXWSSupport = this;
                    synchronized (webProjectJAXWSSupport) {
                        try {
                            fileLock = fileObject2.lock();
                            outputStream = fileObject2.getOutputStream(fileLock);
                            endpoints.write(outputStream);
                        }
                        finally {
                            if (fileLock != null) {
                                fileLock.releaseLock();
                            }
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                    }
                }
            }
        } else {
            String string2 = NbBundle.getMessage(WebProjectJAXWSSupport.class, (String)"MSG_CannotFindDDDirectory");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public void removeJsr109Entries(String string) throws IOException {
        boolean bl;
        Service service;
        JaxWsModel jaxWsModel;
        WebApp webApp = this.getWebApp();
        if (webApp != null && (jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class)) != null && (service = jaxWsModel.findServiceByName(string)) != null && (bl = this.removeJsr109ServletsFromDD(webApp, service))) {
            try {
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private boolean removeJsr109ServletsFromDD(WebApp webApp, Service service) {
        boolean bl = false;
        String string = service.getImplementationClass();
        if (string != null) {
            String string2 = null;
            for (Servlet servlet : webApp.getServlet()) {
                if (!string.equals(servlet.getServletClass())) continue;
                webApp.removeServlet(servlet);
                string2 = servlet.getServletName();
                bl = true;
                break;
            }
            if (string2 != null) {
                for (Servlet servlet : webApp.getServletMapping()) {
                    if (!servlet.getServletName().equals(string2)) continue;
                    webApp.removeServletMapping((ServletMapping)servlet);
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public String addService(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        FileObject fileObject = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fileObject == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
                this.logWsDetected();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return super.addService(string, string2, string3, string4, string5, string6, bl, bl2);
    }

    public void addService(String string, String string2, boolean bl) {
        FileObject fileObject = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fileObject == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
                this.logWsDetected();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        super.addService(string, string2, bl);
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        return this.project.getWebModule().getWebservicesMetadataModel();
    }

    private void logWsDetected() {
        Object[] objectArray = new Object[]{"JAX-WS", this.project.getClass().getName(), "SERVICE"};
        LogUtils.logWsDetect((Object[])objectArray);
    }

    protected String getProjectJavaEEVersion() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            if (Profile.JAVA_EE_6_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_6_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_5.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-15";
            }
        }
        return "java-ee-version-none";
    }
}

