/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class WebPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
EntityClassScopeProvider,
PropertyChangeListener {
    private final WebProject project;
    private final PropertyEvaluator evaluator;
    private final ClassPathProviderImpl cpProvider;
    private final ScopeImpl scopeImpl = new ScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.scopeImpl);
    private final EntityClassScope entityClassScope = EntityClassScopeFactory.createEntityClassScope((EntityClassScopeImplementation)this.scopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private final EntityMappingsMetadataModelHelper modelHelper;
    private static final RequestProcessor RP = new RequestProcessor();
    private final PropertyChangeListener scopeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            if (Boolean.TRUE.equals(object)) {
                WebPersistenceProvider.this.puChanged();
            }
        }
    };
    private ClassPath projectSourcesClassPath;

    public WebPersistenceProvider(WebProject webProject, PropertyEvaluator propertyEvaluator, ClassPathProviderImpl classPathProviderImpl) {
        this.project = webProject;
        this.evaluator = propertyEvaluator;
        this.cpProvider = classPathProviderImpl;
        this.modelHelper = this.createEntityMappingsHelper();
        propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.locationChanged();
    }

    public FileObject getLocation() {
        return this.project.getWebModule().getPersistenceXmlDir();
    }

    public FileObject createLocation() throws IOException {
        FileObject fileObject = this.project.getWebModule().getPersistenceXmlDir();
        if (fileObject == null) {
            fileObject = FileUtil.createFolder((File)this.project.getWebModule().getPersistenceXmlDirAsFile());
        }
        return fileObject;
    }

    public PersistenceScope findPersistenceScope(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            WebPersistenceProvider webPersistenceProvider = (WebPersistenceProvider)project.getLookup().lookup(WebPersistenceProvider.class);
            return webPersistenceProvider.getPersistenceScope();
        }
        return null;
    }

    public EntityClassScope findEntityClassScope(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            WebPersistenceProvider webPersistenceProvider = (WebPersistenceProvider)project.getLookup().lookup(WebPersistenceProvider.class);
            return webPersistenceProvider.getEntityClassScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    private PersistenceScope getPersistenceScope() {
        FileObject fileObject = this.persistenceScope.getPersistenceXml();
        if (fileObject != null && fileObject.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    private EntityClassScope getEntityClassScope() {
        return this.entityClassScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        WebPersistenceProvider webPersistenceProvider = this;
        synchronized (webPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                ClassPathProviderImpl classPathProviderImpl = this.project.getClassPathProvider();
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPathProviderImpl.getProjectSourcesClassPath("classpath/source"), classPathProviderImpl.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null || string.equals("persistence.xml.dir")) {
            this.locationChanged();
        }
    }

    private void locationChanged() {
        File file = this.project.getWebModule().getPersistenceXmlDirAsFile();
        if (file != null) {
            File file2 = new File(file, "persistence.xml");
            this.scopesHelper.changePersistenceScope(this.persistenceScope, file2);
            this.modelHelper.changePersistenceXml(file2);
            this.scopesHelper.getPersistenceScopes().addPropertyChangeListener(this.scopeListener);
        } else {
            this.scopesHelper.changePersistenceScope(null, null);
            this.modelHelper.changePersistenceXml(null);
        }
    }

    private void puChanged() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        SourceGroup[] sourceGroupArray;
                        SourceGroup sourceGroup;
                        FileObject fileObject;
                        ClassPath classPath;
                        String string;
                        String string2;
                        EditableProperties editableProperties = WebPersistenceProvider.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                        String string3 = editableProperties.getProperty("annotation.processing.processors.list");
                        if (string3 == null) {
                            string3 = "";
                        }
                        if ((string2 = editableProperties.getProperty("annotation.processing.processor.options")) == null) {
                            string2 = "";
                        }
                        boolean bl = false;
                        if (string2.indexOf("eclipselink.canonicalmodel.use_static_factory") == -1) {
                            string = (string2.length() > 0 ? " " : "") + "-Aeclipselink.canonicalmodel.use_static_factory=false";
                            string2 = string2 + string;
                            editableProperties.setProperty("annotation.processing.processor.options", string2);
                            bl = true;
                        }
                        if (string3.length() > 0 && string3.indexOf("org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProcessor") == -1 && (classPath = ClassPath.getClassPath((FileObject)(fileObject = (sourceGroup = (sourceGroupArray = (string = ProjectUtils.getSources((Project)WebPersistenceProvider.this.project)).getSourceGroups("java"))[0]).getRootFolder()), (String)"classpath/processor")).findResource("org/eclipse/persistence/internal/jpa/modelgen/CanonicalModelProcessor.class") != null) {
                            boolean bl2 = (string3 = string3.trim()).length() == 0;
                            string3 = string3 + (string3.length() > 0 ? "," : "") + "org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProcessor";
                            editableProperties.setProperty("annotation.processing.processors.list", string3);
                            bl = true;
                            if (bl2) {
                                editableProperties.setProperty("annotation.processing.run.all.processors", "false");
                            }
                        }
                        if (!"true".equals(editableProperties.getProperty("annotation.processing.enabled.in.editor"))) {
                            editableProperties.setProperty("annotation.processing.enabled.in.editor", "true");
                            bl = true;
                        }
                        if (bl) {
                            WebPersistenceProvider.this.project.getUpdateHelper().putProperties("nbproject/project.properties", editableProperties);
                            try {
                                ProjectManager.getDefault().saveProject((Project)WebPersistenceProvider.this.project);
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                Exceptions.printStackTrace((Throwable)illegalArgumentException);
                            }
                        }
                    }
                });
            }
        });
    }

    private final class ScopeImpl
    implements PersistenceScopeImplementation,
    EntityClassScopeImplementation {
        private ScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject fileObject = WebPersistenceProvider.this.getLocation();
            if (fileObject == null) {
                return null;
            }
            return fileObject.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return WebPersistenceProvider.this.getProjectSourcesClassPath();
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String string) {
            return WebPersistenceProvider.this.modelHelper.getEntityMappingsModel(string);
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(boolean bl) {
            return WebPersistenceProvider.this.modelHelper.getDefaultEntityMappingsModel(bl);
        }
    }
}

