/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectweb.carol.cmi.Config;
import org.objectweb.carol.util.configuration.CarolDefaultValues;
import org.objectweb.carol.util.configuration.RMIConfigurationException;

public class RMIConfiguration {
    public String rmiName = null;
    private String pro = null;
    private String nameServiceName = null;
    private int port = 0;
    private String interPref = null;
    private Properties jndiProperties = null;

    public RMIConfiguration(String name, Properties carolProperties) throws RMIConfigurationException {
        String current;
        String rmiPref = CarolDefaultValues.CAROL_PREFIX + "." + name;
        String urlPref = CarolDefaultValues.CAROL_PREFIX + "." + name + "." + CarolDefaultValues.URL_PREFIX;
        String factoryPref = CarolDefaultValues.CAROL_PREFIX + "." + name + "." + CarolDefaultValues.FACTORY_PREFIX;
        if (name.equals("cmi")) {
            Config.setProperties(carolProperties);
        }
        this.rmiName = name;
        this.pro = carolProperties.getProperty(rmiPref + "." + CarolDefaultValues.PRO_PREFIX).trim();
        if (carolProperties.getProperty(rmiPref + "." + CarolDefaultValues.NS_PREFIX) != null) {
            this.nameServiceName = carolProperties.getProperty(rmiPref + "." + CarolDefaultValues.NS_PREFIX).trim();
        }
        this.interPref = carolProperties.getProperty(CarolDefaultValues.CAROL_PREFIX + "." + name + "." + CarolDefaultValues.INTERCEPTOR_PKGS_PREFIX);
        String interValues = carolProperties.getProperty(CarolDefaultValues.CAROL_PREFIX + "." + name + "." + CarolDefaultValues.INTERCEPTOR_VALUES_PREFIX);
        if (this.interPref != null && interValues != null) {
            Properties jvmProps = new Properties();
            jvmProps.putAll((Map<?, ?>)System.getProperties());
            StringTokenizer st = new StringTokenizer(interValues, ",");
            while (st.hasMoreTokens()) {
                current = st.nextToken().trim();
                jvmProps.setProperty(this.interPref + "." + current, "");
            }
            System.setProperties(jvmProps);
        }
        this.jndiProperties = new Properties();
        Enumeration<?> e = carolProperties.propertyNames();
        while (e.hasMoreElements()) {
            current = ((String)e.nextElement()).trim();
            if (current.startsWith(urlPref)) {
                this.jndiProperties.setProperty(CarolDefaultValues.JNDI_URL_PREFIX, carolProperties.getProperty(current));
                continue;
            }
            if (!current.startsWith(factoryPref)) continue;
            this.jndiProperties.setProperty(CarolDefaultValues.JNDI_FACTORY_PREFIX, carolProperties.getProperty(current));
        }
        this.port = RMIConfiguration.getPortOfUrl(this.jndiProperties.getProperty(CarolDefaultValues.JNDI_URL_PREFIX));
    }

    public String getName() {
        return this.rmiName;
    }

    public String getPro() {
        return this.pro;
    }

    public Properties getJndiProperties() {
        return this.jndiProperties;
    }

    public int getPort() {
        return this.port;
    }

    public String getNameService() {
        return this.nameServiceName;
    }

    public String getInterceptorPrefix() {
        return this.interPref;
    }

    static int getPortOfUrl(String url) {
        int portNumber = 0;
        try {
            StringTokenizer st = new StringTokenizer(url, ":");
            st.nextToken();
            st.nextToken();
            if (st.hasMoreTokens()) {
                StringTokenizer lastst = new StringTokenizer(st.nextToken(), "/");
                String pts = lastst.nextToken().trim();
                int i = pts.indexOf(44);
                if (i > 0) {
                    pts = pts.substring(0, i);
                }
                portNumber = new Integer(pts);
            }
            return portNumber;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

