/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.jndi.ns.NameServiceManager;
import org.objectweb.carol.util.configuration.CarolDefaultValues;
import org.objectweb.carol.util.configuration.RMIConfiguration;
import org.objectweb.carol.util.configuration.RMIConfigurationException;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.objectweb.util.monolog.api.LoggerFactory;

public class CarolConfiguration {
    private static boolean configurationLoaded = false;
    private static boolean startNS;
    private static boolean startRMI;
    private static boolean startJNDI;
    private static Properties defaultsProps;
    private static Properties carolProps;
    private static Properties jndiProps;
    private static String protocols;
    private static boolean multiRMI;
    private static Hashtable rmiConfigurationTable;
    private static String defaultRMI;
    private static String jndiRMIName;
    public static final String DEFAULTS_FILE_NAME = "carol-defaults.properties";
    public static final String CAROL_FILE_NAME = "carol.properties";
    public static final String JNDI_FILE_NAME = "jndi.properties";

    public static void init() throws RMIConfigurationException {
        new CarolConfiguration();
    }

    public static void init(LoggerFactory lf) throws RMIConfigurationException {
        TraceCarol.configure(lf);
        new CarolConfiguration();
    }

    public CarolConfiguration() throws RMIConfigurationException {
        if (!configurationLoaded) {
            CarolConfiguration.loadCarolConfiguration();
        }
    }

    public static RMIConfiguration getRMIConfiguration(String name) throws RMIConfigurationException {
        if (configurationLoaded) {
            return (RMIConfiguration)rmiConfigurationTable.get(name);
        }
        CarolConfiguration.loadCarolConfiguration();
        return (RMIConfiguration)rmiConfigurationTable.get(name);
    }

    public static Hashtable getAllRMIConfiguration() throws RMIConfigurationException {
        if (configurationLoaded) {
            return rmiConfigurationTable;
        }
        CarolConfiguration.loadCarolConfiguration();
        return rmiConfigurationTable;
    }

    public static RMIConfiguration getDefaultProtocol() throws RMIConfigurationException {
        if (configurationLoaded) {
            return (RMIConfiguration)rmiConfigurationTable.get(defaultRMI);
        }
        CarolConfiguration.loadCarolConfiguration();
        return (RMIConfiguration)rmiConfigurationTable.get(defaultRMI);
    }

    public static void loadCarolConfiguration() throws RMIConfigurationException {
        try {
            defaultsProps = CarolConfiguration.getDefaultsProperties();
            carolProps = CarolConfiguration.getCarolProperties();
            jndiProps = CarolConfiguration.getJndiProperties();
        }
        catch (Exception e) {
            TraceCarol.error("Exception occur when loading default/carol/jndi configuration file: ", e);
            throw new RMIConfigurationException("Exception occur when loading default/carol/jndi configuration file");
        }
        boolean cc = CarolConfiguration.checkCarolConfiguration();
        if (!cc) {
            throw new RMIConfigurationException("Can't start Carol, configuration check fail");
        }
        if (jndiProps != null) {
            jndiProps = CarolConfiguration.jndi2Carol(jndiProps);
        }
        Properties allProps = new Properties();
        allProps.putAll((Map<?, ?>)defaultsProps);
        if (jndiProps != null) {
            allProps.putAll((Map<?, ?>)jndiProps);
        }
        if (carolProps != null) {
            allProps.putAll((Map<?, ?>)carolProps);
        }
        CarolConfiguration.loadCarolConfiguration(allProps);
    }

    public static synchronized void loadCarolConfiguration(Properties allProps) throws RMIConfigurationException {
        String pkey;
        String pkey2;
        Enumeration<?> e;
        StringTokenizer pTok;
        String jvmPref = CarolDefaultValues.CAROL_PREFIX + "." + CarolDefaultValues.JVM_PREFIX;
        String jndiPref = CarolDefaultValues.CAROL_PREFIX + "." + CarolDefaultValues.JNDI_PREFIX;
        String act = allProps.getProperty(CarolDefaultValues.PROTOCOLS_KEY);
        if (act != null) {
            protocols = act.trim();
            allProps.remove(CarolDefaultValues.PROTOCOLS_KEY);
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Carol use carol file to activate RMI: " + protocols);
            }
        } else if (jndiRMIName != null) {
            protocols = jndiRMIName;
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Carol use jndi file to activate RMI: " + protocols);
            }
        } else {
            protocols = allProps.getProperty(CarolDefaultValues.DEFAULT_PROTOCOLS_KEY).trim();
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Carol use default file to activate RMI " + protocols);
            }
        }
        startNS = new Boolean(allProps.getProperty(CarolDefaultValues.START_NS_KEY).trim());
        startRMI = new Boolean(allProps.getProperty(CarolDefaultValues.START_RMI_KEY).trim());
        startJNDI = new Boolean(allProps.getProperty(CarolDefaultValues.START_JNDI_KEY).trim());
        if (TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("--- Global Carol configuration: ---");
            TraceCarol.debugCarol("Multiple RMI is " + multiRMI);
            TraceCarol.debugCarol(CarolDefaultValues.START_NS_KEY + "=" + startNS);
            TraceCarol.debugCarol(CarolDefaultValues.START_RMI_KEY + "=" + startRMI);
            TraceCarol.debugCarol(CarolDefaultValues.START_JNDI_KEY + "=" + startJNDI);
        }
        if ((pTok = new StringTokenizer(protocols, ",")).countTokens() > 1) {
            multiRMI = true;
            e = allProps.propertyNames();
            while (e.hasMoreElements()) {
                pkey2 = ((String)e.nextElement()).trim();
                if (!pkey2.startsWith(CarolDefaultValues.MULTI_RMI_PREFIX)) continue;
                allProps.setProperty(pkey2.substring(CarolDefaultValues.MULTI_RMI_PREFIX.length() + 1), allProps.getProperty(pkey2).trim());
                allProps.remove(pkey2);
            }
        } else {
            multiRMI = false;
            e = allProps.propertyNames();
            while (e.hasMoreElements()) {
                pkey2 = ((String)e.nextElement()).trim();
                if (!pkey2.startsWith(CarolDefaultValues.MULTI_RMI_PREFIX)) continue;
                allProps.remove(pkey2);
            }
        }
        if (TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("--- Carol RMI configuration ---");
        }
        defaultRMI = pTok.nextToken().trim();
        RMIConfiguration rmiConfDefault = new RMIConfiguration(defaultRMI, allProps);
        rmiConfigurationTable.put(defaultRMI, rmiConfDefault);
        if (TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("Carol RMI " + defaultRMI + " configuration:");
            TraceCarol.debugCarol(defaultRMI + " is default");
            String rmiDP = CarolDefaultValues.CAROL_PREFIX + "." + defaultRMI;
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(allProps);
            Iterator<Object> e2 = map.keySet().iterator();
            while (e2.hasNext()) {
                String k = (String)e2.next();
                if (!k.startsWith(rmiDP)) continue;
                TraceCarol.debugCarol(k + "=" + allProps.getProperty(k));
            }
        }
        while (pTok.hasMoreTokens()) {
            String rmiName = pTok.nextToken().trim();
            RMIConfiguration rmiConf = new RMIConfiguration(rmiName, allProps);
            rmiConfigurationTable.put(rmiName, rmiConf);
            if (!TraceCarol.isDebugCarol()) continue;
            TraceCarol.debugCarol("Carol RMI " + rmiName + " configuration:");
            String rmiDP = CarolDefaultValues.CAROL_PREFIX + "." + rmiName;
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(allProps);
            Iterator<Object> e3 = map.keySet().iterator();
            while (e3.hasNext()) {
                String k = (String)e3.next();
                if (!k.startsWith(rmiDP)) continue;
                TraceCarol.debugCarol(k + "=" + allProps.getProperty(k));
            }
        }
        if (TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("--- Carol JVM configuration --- (without " + jvmPref + " prefix)");
        }
        Properties jvmProps = new Properties();
        jvmProps.putAll((Map<?, ?>)System.getProperties());
        Enumeration<?> e4 = allProps.propertyNames();
        while (e4.hasMoreElements()) {
            pkey = ((String)e4.nextElement()).trim();
            if (!pkey.startsWith(jvmPref)) continue;
            jvmProps.setProperty(pkey.substring(jvmPref.length() + 1), allProps.getProperty(pkey).trim());
            if (!TraceCarol.isDebugCarol()) continue;
            TraceCarol.debugCarol(pkey.substring(jvmPref.length() + 1) + "=" + allProps.getProperty(pkey));
        }
        e4 = allProps.propertyNames();
        while (e4.hasMoreElements()) {
            pkey = ((String)e4.nextElement()).trim();
            if (!pkey.startsWith(jndiPref)) continue;
            jvmProps.setProperty(pkey.substring(jndiPref.length() + 1), allProps.getProperty(pkey).trim());
            if (!TraceCarol.isDebugCarol()) continue;
            TraceCarol.debugCarol(pkey.substring(jndiPref.length() + 1) + "=" + allProps.getProperty(pkey));
        }
        if (startRMI) {
            jvmProps.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", CarolDefaultValues.MULTI_PROD);
        }
        if (startJNDI) {
            jvmProps.setProperty("java.naming.factory.initial", CarolDefaultValues.MULTI_JNDI);
        }
        System.setProperties(jvmProps);
        configurationLoaded = true;
        if (startNS) {
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Start non started Name Servers");
            }
            try {
                NameServiceManager.startNonStartedNS();
            }
            catch (NameServiceException nse) {
                String msg = "Can't start Name Servers";
                TraceCarol.error(msg, nse);
                throw new RMIConfigurationException(msg);
            }
        }
    }

    private static Properties jndi2Carol(Properties p) {
        TraceCarol.debugCarol("map properties found in jndi.properties to CAROL ones");
        Properties result = new Properties();
        jndiRMIName = CarolDefaultValues.getRMIProtocol(p.getProperty(CarolDefaultValues.JNDI_URL_PREFIX));
        TraceCarol.debugCarol("rmi used=" + jndiRMIName);
        TraceCarol.debugCarol("initial properties = " + p);
        if (jndiRMIName == null) {
            return null;
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String current = ((String)e.nextElement()).trim();
            if (current.trim().equals(CarolDefaultValues.JNDI_URL_PREFIX)) {
                result.setProperty(CarolDefaultValues.CAROL_PREFIX + "." + jndiRMIName + "." + CarolDefaultValues.URL_PREFIX, p.getProperty(current));
                continue;
            }
            if (current.trim().equals(CarolDefaultValues.JNDI_FACTORY_PREFIX)) {
                result.setProperty(CarolDefaultValues.CAROL_PREFIX + "." + jndiRMIName + "." + CarolDefaultValues.FACTORY_PREFIX, p.getProperty(current));
                continue;
            }
            result.setProperty(CarolDefaultValues.CAROL_PREFIX + "." + CarolDefaultValues.JNDI_PREFIX + "." + current, p.getProperty(current));
        }
        TraceCarol.debugCarol("resulting properties = " + result);
        return result;
    }

    private static Properties loadPropertiesFile(String fName, ClassLoader cl) throws Exception {
        Properties result = null;
        InputStream fInputStream = cl.getResourceAsStream(fName + ".properties");
        if (fInputStream == null) {
            ResourceBundle rb = ResourceBundle.getBundle(fName, Locale.getDefault(), cl);
            if (rb.getKeys().hasMoreElements()) {
                result = new Properties();
                Enumeration<String> e = rb.getKeys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    result.setProperty(key, rb.getString(key));
                }
                if (TraceCarol.isDebugCarol()) {
                    TraceCarol.debugCarol("Carol file used is " + fName + ".properties through URLClassLoader");
                }
            }
        } else {
            result = new Properties();
            result.load(fInputStream);
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Carol file used is " + fName + ".properties in " + cl.getResource(fName + ".properties").getPath());
            }
        }
        if (result == null && TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("No " + fName + ".properties file found");
        }
        return result;
    }

    private static Properties getDefaultsProperties() throws Exception {
        return CarolConfiguration.loadPropertiesFile("carol-defaults", Thread.currentThread().getContextClassLoader());
    }

    private static Properties getCarolProperties() throws Exception {
        Properties props = null;
        try {
            props = CarolConfiguration.loadPropertiesFile("carol", Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            TraceCarol.debugCarol("carol.properties file not found: " + e);
        }
        return props;
    }

    private static Properties getJndiProperties() {
        Properties props = null;
        try {
            props = CarolConfiguration.loadPropertiesFile("jndi", Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            TraceCarol.debugCarol("jndi.properties file not found: " + e);
        }
        return props;
    }

    public static boolean checkCarolConfiguration() {
        return true;
    }

    public static String getCarolConfiguration() {
        String result = "";
        try {
            result = CarolConfiguration.loadPropertiesFile("carol-defaults", Thread.currentThread().getContextClassLoader()) + "\n";
            result = CarolConfiguration.loadPropertiesFile("carol", Thread.currentThread().getContextClassLoader()) + "\n";
            result = CarolConfiguration.loadPropertiesFile("jndi", Thread.currentThread().getContextClassLoader()) + "\n";
        }
        catch (Exception e) {
            result = result + "There is a problem with the configuration loading:" + e;
        }
        if (defaultsProps == null) {
            result = result + "Default carol configuration file missing\n";
        }
        Properties allProps = new Properties();
        if (defaultsProps != null) {
            allProps.putAll((Map<?, ?>)defaultsProps);
        }
        if (jndiProps != null) {
            allProps.putAll((Map<?, ?>)jndiProps);
        }
        if (carolProps != null) {
            allProps.putAll((Map<?, ?>)carolProps);
        }
        result = result + "Global Carol configuration is:";
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(allProps);
        Iterator<Object> e = map.keySet().iterator();
        while (e.hasNext()) {
            String k = (String)e.next();
            result = result + k + "=" + allProps.getProperty(k);
        }
        return result;
    }

    public static String getProtocols() {
        return protocols;
    }

    public static void addInterceptors(String protocolName, String interceptorInitializer) throws RMIConfigurationException {
        String pref;
        RMIConfiguration rc = CarolConfiguration.getRMIConfiguration(protocolName);
        if (rc != null && (pref = rc.getInterceptorPrefix()) != null) {
            System.setProperty(pref + "." + interceptorInitializer, "");
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Add Initializer for " + protocolName + ": " + pref + "." + interceptorInitializer);
            }
        }
    }

    static {
        defaultsProps = null;
        carolProps = null;
        jndiProps = null;
        rmiConfigurationTable = new Hashtable();
        defaultRMI = null;
        jndiRMIName = null;
    }
}

