/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.bootstrap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.carol.util.bootstrap.ProcessException;

public class JVMConfiguration
implements Serializable {
    public boolean server = false;
    public boolean debug = false;
    public Properties properties = new Properties();
    public Vector classpath = new Vector();
    public String jarName = null;
    public String className = null;
    public String mainArgs = "";
    public boolean verbose = false;
    public boolean verboseClass = false;
    public boolean verboseGC = false;
    public boolean verboseJNI = false;
    public Vector nonStandard = new Vector();

    public JVMConfiguration() {
    }

    public JVMConfiguration(String commandLine) throws ProcessException {
        StringTokenizer st = new StringTokenizer(commandLine);
        while (st.hasMoreTokens()) {
            String opt = st.nextToken();
            if (opt.equals("-server")) {
                this.setServer();
                continue;
            }
            if (opt.equals("-debug")) {
                this.setDebug();
                continue;
            }
            if (opt.equals("-verbose")) {
                this.setVerbose();
                continue;
            }
            if (opt.equals("-verbose:class")) {
                this.setVerboseClass();
                continue;
            }
            if (opt.equals("-verbose:gc")) {
                this.setVerboseGC();
                continue;
            }
            if (opt.equals("-verbose:jni")) {
                this.setVerboseJNI();
                continue;
            }
            if (opt.startsWith("-D")) {
                StringTokenizer prop = new StringTokenizer(opt.substring(2), "=");
                if (prop.countTokens() == 2) {
                    this.addProperty(prop.nextToken(), prop.nextToken());
                    continue;
                }
                throw new ProcessException("-D option is not valid");
            }
            if (opt.startsWith("-X")) {
                this.addNonStandard(opt.substring(2));
                continue;
            }
            if (opt.startsWith("-classpath") || opt.startsWith("-cp")) {
                StringTokenizer classP = new StringTokenizer(st.nextToken(), System.getProperty("path.separator"));
                if (classP.countTokens() != 0) {
                    while (classP.hasMoreTokens()) {
                        this.addPath(classP.nextToken());
                    }
                    continue;
                }
                throw new ProcessException("-classpath or -cp option is not a valid path option");
            }
            if (opt.equals("-jar")) {
                this.setJar(st.nextToken());
                if (!st.hasMoreTokens()) break;
                this.mainArgs = " ";
                while (st.hasMoreTokens()) {
                    this.mainArgs = this.mainArgs + " " + st.nextToken();
                }
            } else {
                this.setClass(opt);
                if (!st.hasMoreTokens()) break;
                this.mainArgs = " ";
                while (st.hasMoreTokens()) {
                    this.mainArgs = this.mainArgs + " " + st.nextToken();
                }
            }
            break;
        }
    }

    public void setServer() {
        this.server = true;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void addPath(String path) {
        this.classpath.add(path);
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void setVerboseClass() {
        this.verboseClass = true;
    }

    public void setVerboseGC() {
        this.verboseGC = true;
    }

    public void setVerboseJNI() {
        this.verboseJNI = true;
    }

    public void addNonStandard(String option) {
        this.nonStandard.add(option);
    }

    public void setClass(String cName) throws ProcessException {
        if (this.jarName != null) {
            throw new ProcessException("Can not set className when there is a jar name with (-jar option)");
        }
        this.className = cName;
    }

    public void setJar(String jName) throws ProcessException {
        if (this.className != null) {
            throw new ProcessException("Can not set jar Name when there is a main class define");
        }
        this.jarName = jName;
    }

    public void addArgs(String args) throws ProcessException {
        this.mainArgs = this.mainArgs + " " + args;
    }

    public String getCommandString() throws ProcessException {
        String command = " ";
        if (this.server) {
            command = command + "-server ";
        }
        if (this.debug) {
            command = command + "-debug ";
        }
        if (this.verbose) {
            command = command + "-verbose ";
        }
        if (this.verboseClass) {
            command = command + "-verbose:class ";
        }
        if (this.verboseGC) {
            command = command + "-verbose:gc ";
        }
        if (this.verboseJNI) {
            command = command + "-verbose:jni ";
        }
        Enumeration<Object> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyKey = (String)e.nextElement();
            command = command + "-D" + propertyKey + "=" + this.properties.getProperty(propertyKey) + " ";
        }
        if (this.classpath.size() != 0) {
            String pathSeparator = System.getProperty("path.separator");
            command = command + "-classpath ";
            Enumeration e2 = this.classpath.elements();
            while (e2.hasMoreElements()) {
                command = command + e2.nextElement();
                if (!e2.hasMoreElements()) continue;
                command = command + pathSeparator;
            }
            command = command + " ";
        }
        if (this.nonStandard.size() != 0) {
            e = this.nonStandard.elements();
            while (e.hasMoreElements()) {
                command = command + "-X" + e.nextElement() + " ";
            }
        }
        if (this.jarName != null) {
            command = command + "-jar " + this.jarName;
        } else if (this.className != null) {
            command = command + this.className;
        } else {
            throw new ProcessException("Class or jar name missing");
        }
        command = command + " " + this.mainArgs;
        return command;
    }
}

