/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;

public class JacORBCosNaming
implements NameService {
    private static final int SLEEP_TIME = 2000;
    private static final int DEFAULT_PORT_NUMBER = 38693;
    private static final String JACORB_PROPERTIES_FILE = "jacorb.properties";
    private static final String SSL_PROPERTY = "jacorb.security.support_ssl";
    private int port = 38693;
    private boolean started = false;
    private boolean isSsl = false;
    private Process jacORBNameServerProcess = null;
    private static ORB orb = null;

    public void start() throws NameServiceException {
        block18: {
            if (this.isStarted()) {
                throw new IllegalStateException("Cannot start the server as the service is already running.");
            }
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("start() on port : '" + this.port + "'");
            }
            try {
                InputStream fInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(JACORB_PROPERTIES_FILE);
                if (fInputStream != null) {
                    Properties jacorbProps = new Properties();
                    jacorbProps.load(fInputStream);
                    String sslProp = jacorbProps.getProperty(SSL_PROPERTY);
                    if (sslProp.equalsIgnoreCase("on")) {
                        this.isSsl = true;
                    }
                }
            }
            catch (IOException ioe) {
                if (!TraceCarol.isDebugJndiCarol()) break block18;
                TraceCarol.debugJndiCarol("Cannot load 'jacorb.properties' file from classpath :" + ioe.getMessage());
            }
        }
        try {
            if (!this.isRemoteNameServiceStarted()) {
                InputStream cosOut;
                String jvmProperties = "-Djava.endorsed.dirs=" + System.getProperty("java.endorsed.dirs") + " " + "-Djacorb.orb.print_version=on " + "-Djacorb.log.default.verbosity=4 " + "-Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB " + "-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton " + "-DOAPort=";
                if (this.isSsl) {
                    jvmProperties = jvmProperties + Integer.toString(this.port);
                    jvmProperties = jvmProperties + " -DORBInitRef.NameService=corbaloc:ssliiop:localhost:" + Integer.toString(this.port + 1);
                    jvmProperties = jvmProperties + " -DOASSLPort=" + Integer.toString(this.port + 1) + " ";
                } else {
                    jvmProperties = jvmProperties + Integer.toString(this.port);
                    jvmProperties = jvmProperties + " -DORBInitRef.NameService=corbaloc:iiop:localhost:" + Integer.toString(this.port) + " ";
                }
                if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Launching NS with JVM properties: '" + jvmProperties + "'");
                }
                this.jacORBNameServerProcess = Runtime.getRuntime().exec(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java " + jvmProperties + "org.jacorb.naming.NameServer");
                Thread.sleep(2000L);
                InputStream cosError = this.jacORBNameServerProcess.getErrorStream();
                if (cosError.available() != 0) {
                    byte[] b = new byte[cosError.available()];
                    cosError.read(b);
                    cosError.close();
                    if (TraceCarol.isDebugJndiCarol()) {
                        TraceCarol.debugJndiCarol("JacORBCosNaming:");
                        TraceCarol.debugJndiCarol(new String(b));
                    }
                }
                if ((cosOut = this.jacORBNameServerProcess.getInputStream()).available() != 0) {
                    byte[] b = new byte[cosOut.available()];
                    cosOut.read(b);
                    cosOut.close();
                    if (TraceCarol.isDebugJndiCarol()) {
                        TraceCarol.debugJndiCarol("JacORBCosNaming:");
                        TraceCarol.debugJndiCarol(new String(b));
                    }
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            JacORBCosNaming.this.stop();
                        }
                        catch (Exception e) {
                            TraceCarol.error("OpenORBCosNaming ShutdownHook problem", e);
                        }
                    }
                });
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JacORBCosNaming is already start on port : '" + this.port + "'.");
            }
        }
        catch (Exception e) {
            TraceCarol.error("Cannot start JacORBCosNaming for an unknown reason", e);
            throw new NameServiceException("cannot start cosnaming daemon: " + e);
        }
        this.started = true;
    }

    public void stop() throws NameServiceException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Cannot stop the server as the service is not running.");
        }
        try {
            if (this.jacORBNameServerProcess != null) {
                this.jacORBNameServerProcess.destroy();
            }
            this.jacORBNameServerProcess = null;
        }
        catch (Exception e) {
            TraceCarol.error("Cannot stop JacORBCosNaming for an unknown reason", e);
            throw new NameServiceException("cannot start cosnaming daemon: " + e);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setPort(int p) {
        if (this.isStarted()) {
            throw new IllegalStateException("The port cannot be changed as the server is running.");
        }
        if (p <= 0) {
            throw new IllegalArgumentException("The number for the port is incorrect. It must be a value > 0. Value was '" + this.port + "'");
        }
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    private boolean isRemoteNameServiceStarted() {
        Properties prop = new Properties();
        prop.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        prop.put("java.naming.provider.url", "corbaloc:iiop:localhost:" + Integer.toString(this.port) + "/StandardNS/NameServer-POA/_root");
        if (orb == null) {
            orb = ORB.init((String[])new String[0], null);
        }
        prop.put("java.naming.corba.orb", orb);
        try {
            new InitialContext(prop);
        }
        catch (CommunicationException jcm) {
            return false;
        }
        catch (TRANSIENT ct) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static ORB getOrb() {
        return orb;
    }
}

