/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.jndi.registry.ManageableRegistry;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JRMPRegistry
implements NameService {
    public static int port = 1099;
    public static Registry registry = null;

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.start() on port:" + port);
        }
        try {
            if (!this.isStarted()) {
                if (port >= 0) {
                    registry = ManageableRegistry.createManagableRegistry(port);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                JRMPRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("JRMPRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start JRMPRegistry, port=" + port + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JRMPRegistry is already start on port:" + port);
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start rmi registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.stop()");
        }
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            registry = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop rmi registry: " + e);
        }
    }

    public static boolean isLocal() {
        return registry != null;
    }

    public boolean isStarted() {
        if (registry != null) {
            return true;
        }
        try {
            LocateRegistry.getRegistry(port).list();
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }

    public void setPort(int p) {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JRMPRegistry.setPort(" + p + ")");
        }
        if (p != 0) {
            port = p;
        }
    }

    public int getPort() {
        return port;
    }
}

