/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.objectweb.carol.cmi.ClusterId;
import org.objectweb.carol.cmi.CmiInputStream;
import org.objectweb.carol.cmi.CmiOutputStream;

public class StubData {
    private ClusterId id;
    private byte[] serializedStub;
    private Object stub;
    private int factor;
    private double loadIncr;

    public StubData(ClusterId id, byte[] serStub, int factor) throws RemoteException {
        if (factor < 1) {
            throw new RemoteException("bad load factor : " + factor);
        }
        this.id = id;
        this.serializedStub = serStub;
        this.stub = null;
        this.factor = factor;
        this.loadIncr = 1.0 / (double)factor;
    }

    public StubData(ClusterId id, Remote stub, int factor) throws RemoteException {
        if (factor < 1) {
            throw new RemoteException("bad load factor : " + factor);
        }
        this.id = id;
        this.serializedStub = null;
        this.stub = stub;
        this.factor = factor;
        this.loadIncr = 1.0 / (double)factor;
    }

    StubData(Remote stub) {
        this.id = null;
        this.serializedStub = null;
        this.stub = stub;
        this.factor = 100;
        this.loadIncr = 0.01;
    }

    public ClusterId getId() {
        return this.id;
    }

    public byte[] getSerializedStub() throws IOException {
        if (this.serializedStub == null) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            CmiOutputStream out = new CmiOutputStream(outStream);
            out.writeObject(this.stub);
            out.flush();
            this.serializedStub = outStream.toByteArray();
        }
        return this.serializedStub;
    }

    public Remote getStub() throws RemoteException {
        Object s = this.getStubOrException();
        if (s instanceof Remote) {
            return (Remote)s;
        }
        throw (RemoteException)s;
    }

    public Object getStubOrException() {
        if (this.stub == null) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.serializedStub);
            try {
                CmiInputStream in = new CmiInputStream(inStream);
                this.stub = (Remote)in.readObject();
            }
            catch (IOException e) {
                this.stub = new RemoteException(e.toString());
            }
            catch (ClassNotFoundException e) {
                this.stub = new RemoteException(e.toString());
            }
        }
        return this.stub;
    }

    public double getLoadIncr() {
        return this.loadIncr;
    }

    public int getFactor() {
        return this.factor;
    }

    public String toString() {
        String str = "[id:" + this.id + ",stub:";
        Object o = this.getStubOrException();
        if (o instanceof Remote) {
            return str + o.toString() + "]";
        }
        return str + "serialized]";
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (!(obj instanceof StubData)) {
            return false;
        }
        StubData sd = (StubData)obj;
        return this.id.equals(sd.id);
    }
}

