/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.util.Collection;
import java.util.Iterator;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.NoMoreStubException;
import org.objectweb.carol.cmi.SecureRandom;
import org.objectweb.carol.cmi.StubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.StubLBFilter;

public class RoundRobin
extends StubLB {
    private ClusterStubData csd;
    private int len;
    private StubData[] sd;
    private double[] load;
    private double minLoad;
    private static StubLBFilter emptyFilter = new StubLBFilter();

    public RoundRobin(ClusterStubData csd, Collection c) {
        int i;
        this.csd = csd;
        this.len = c.size();
        this.sd = new StubData[this.len];
        this.load = new double[this.len];
        Iterator it = c.iterator();
        for (i = 0; i < this.len; ++i) {
            StubData s;
            this.sd[i] = s = (StubData)it.next();
        }
        for (i = 0; i < SecureRandom.getInt(this.len); ++i) {
            this.load[i] = this.sd[i].getLoadIncr();
        }
    }

    private synchronized void ensureCapacity(int minCapacity) {
        int old = this.sd.length;
        if (old >= minCapacity) {
            return;
        }
        int l = old * 3 / 2 + 1;
        if (l < minCapacity) {
            l = minCapacity;
        }
        StubData[] nsd = new StubData[l];
        double[] nload = new double[l];
        System.arraycopy(this.sd, 0, nsd, 0, old);
        System.arraycopy(this.load, 0, nload, 0, old);
        this.sd = nsd;
        this.load = nload;
    }

    synchronized void add(StubData sd) {
        this.ensureCapacity(this.len + 1);
        this.sd[this.len] = sd;
        this.load[this.len] = this.minLoad;
        ++this.len;
    }

    synchronized void removeCallback(StubData s) {
        for (int i = 0; i < this.len; ++i) {
            if (this.sd[i] != s) continue;
            --this.len;
            this.sd[i] = this.sd[this.len];
            this.sd[this.len] = null;
            this.load[i] = this.load[this.len];
            return;
        }
    }

    public synchronized StubData get() throws NoMoreStubException {
        return this.get(emptyFilter);
    }

    public synchronized StubData get(StubLBFilter f) throws NoMoreStubException {
        int i;
        double min = Double.MAX_VALUE;
        double minOk = Double.MAX_VALUE;
        int index = -1;
        for (i = 0; i < this.len; ++i) {
            double l = this.load[i];
            if (!(l < minOk)) continue;
            if (!f.contains(this.sd[i])) {
                minOk = l;
                index = i;
            }
            if (!(l < min)) continue;
            min = l;
        }
        if (index < 0) {
            throw new NoMoreStubException();
        }
        if (min >= 100.0) {
            i = 0;
            while (i < this.len) {
                int n = i++;
                this.load[n] = this.load[n] - min;
            }
            min = 0.0;
        }
        StubData s = this.sd[index];
        int n = index;
        this.load[n] = this.load[n] + s.getLoadIncr();
        return s;
    }

    public void remove(StubData s) {
        this.csd.removeStubData(s);
    }
}

