/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.rmi.server.RMIClassLoader;

public class CmiInputStream
extends ObjectInputStream {
    public CmiInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        Object annotation = this.readLocation();
        String className = classDesc.getName();
        try {
            return super.resolveClass(classDesc);
        }
        catch (ClassNotFoundException e) {
            if (annotation != null && annotation instanceof String) {
                String location = (String)annotation;
                return RMIClassLoader.loadClass(location, className);
            }
            return RMIClassLoader.loadClass((String)null, className);
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader;
        Object annotation = this.readLocation();
        if (annotation != null && annotation instanceof String) {
            String location = (String)annotation;
            loader = RMIClassLoader.getClassLoader(location);
        } else {
            loader = RMIClassLoader.getClassLoader(null);
        }
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = Class.forName(interfaces[i], false, loader);
        }
        return Proxy.getProxyClass(loader, classObjs);
    }

    protected Object readLocation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }
}

