/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.objectweb.carol.cmi.WeakCache;

public class ClusterId
implements Serializable {
    private static WeakCache wc = new WeakCache();
    private transient byte[] id;
    private transient int hash = 0;
    private transient String str;

    private ClusterId() {
    }

    private ClusterId(byte[] id) {
        if (id.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Too long array for a cluster ID");
        }
        this.id = id;
        this.redoHash();
    }

    public static ClusterId toClusterId(byte[] id) {
        ClusterId cid = new ClusterId(id);
        return (ClusterId)wc.getCached(cid);
    }

    private void redoHash() {
        int h = 0;
        int l = this.id.length;
        int n = 1;
        for (int i = 0; i < l; ++i) {
            h += this.id[i] * n;
            n *= 31;
        }
        this.hash = h;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean match(byte[] ar) {
        return Arrays.equals(this.id, ar);
    }

    public boolean equals(Object o) {
        if (o instanceof ClusterId) {
            ClusterId i = (ClusterId)o;
            return this.match(i.id);
        }
        return false;
    }

    public String toString() {
        if (this.str != null) {
            return this.str;
        }
        String s = "";
        for (int i = 0; i < this.id.length; ++i) {
            int n = this.id[i];
            if (n < 0) {
                n += 256;
            }
            if (i > 0) {
                s = s + "-";
            }
            s = s + n;
        }
        this.str = s;
        return s;
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.id.length);
        out.write(this.id);
    }

    public static ClusterId read(DataInput in) throws IOException {
        short l = in.readShort();
        byte[] a = new byte[l];
        in.readFully(a);
        ClusterId id = new ClusterId();
        id.id = a;
        id.redoHash();
        return (ClusterId)wc.getCached(id);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(this.id.length);
        out.write(this.id, 0, this.id.length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        short l = in.readShort();
        this.id = new byte[l];
        in.readFully(this.id);
        this.redoHash();
    }
}

