/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.container.CompositeSniffer;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.ApplicationInfoProvider;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SnifferManagerImpl
implements SnifferManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SnifferManagerImpl.class);
    @Inject
    protected Habitat habitat;

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.addAll(this.habitat.getAllByContract(Sniffer.class));
        Collections.sort(sniffers, new Comparator<Sniffer>(){

            @Override
            public int compare(Sniffer o1, Sniffer o2) {
                return o1.getModuleType().compareTo(o2.getModuleType());
            }
        });
        return sniffers;
    }

    public Collection<CompositeSniffer> getCompositeSniffers() {
        return this.habitat.getAllByContract(CompositeSniffer.class);
    }

    public final boolean hasNoSniffers() {
        return this.getSniffers().isEmpty();
    }

    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.getSniffers()) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    public Collection<Sniffer> getSniffers(DeploymentContext context) {
        ArrayList<Sniffer> nonCompositeSniffers = new ArrayList<Sniffer>();
        for (Sniffer sniffer : this.getSniffers()) {
            if (sniffer instanceof CompositeSniffer) continue;
            nonCompositeSniffers.add(sniffer);
        }
        List<Sniffer> appSniffers = this.getApplicableSniffers(context, nonCompositeSniffers, true);
        for (Sniffer sniffer : nonCompositeSniffers) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(context.getSource(), context.getClassLoader())) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    public boolean canBeIsolated(Sniffer sniffer) {
        return sniffer.getModuleType().equalsIgnoreCase("osgi");
    }

    public Collection<CompositeSniffer> getCompositeSniffers(DeploymentContext context) {
        List<CompositeSniffer> appSniffers = this.getApplicableSniffers(context, this.getCompositeSniffers(), false);
        for (CompositeSniffer sniffer : this.getCompositeSniffers()) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(context)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    public <T extends Sniffer> List<T> getApplicableSniffers(DeploymentContext context, Collection<T> sniffers, boolean checkPath) {
        if (sniffers == null || sniffers.isEmpty()) {
            return Collections.emptyList();
        }
        Types types = (Types)context.getTransientAppMetaData(Types.class.getName(), Types.class);
        List<URI> uris = this.getURIs(context);
        ArrayList<Sniffer> result = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            Class[] annotations = sniffer.getAnnotationTypes();
            if (annotations == null) continue;
            block1: for (Class annotationType : annotations) {
                Type type = types.getBy(annotationType.getName());
                if (!(type instanceof AnnotationType)) continue;
                Collection elements = ((AnnotationType)type).allAnnotatedTypes();
                for (AnnotatedElement element : elements) {
                    if (checkPath) {
                        Object t = element instanceof Member ? ((Member)element).getDeclaringType() : (Type)element;
                        if (!t.wasDefinedIn(uris)) continue;
                        result.add(sniffer);
                        continue block1;
                    }
                    result.add(sniffer);
                    continue block1;
                }
            }
        }
        return result;
    }

    public void validateSniffers(Collection<? extends Sniffer> snifferCol, DeploymentContext context) {
        for (Sniffer sniffer : snifferCol) {
            String[] incompatTypes = sniffer.getIncompatibleSnifferTypes();
            if (incompatTypes == null) {
                return;
            }
            for (String type : incompatTypes) {
                for (Sniffer sniffer2 : snifferCol) {
                    if (!sniffer2.getModuleType().equals(type)) continue;
                    throw new IllegalArgumentException(localStrings.getLocalString("invalidarchivepackaging", "Invalid archive packaging {2}", new Object[]{sniffer.getModuleType(), type, context.getSourceDir().getPath()}));
                }
            }
        }
    }

    private List<URI> getURIs(DeploymentContext context) {
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(context.getSource().getURI());
        try {
            File f = new File(context.getSource().getURI());
            if (f.exists() && f.isDirectory()) {
                uris.add(new URI(context.getSource().getURI().toString() + "WEB-INF/classes/"));
            }
            if (context instanceof ExtendedDeploymentContext) {
                if (((ExtendedDeploymentContext)context).getParentContext() == null) {
                    List moduleLibraries = DeploymentUtils.getModuleLibraryJars((DeploymentContext)context);
                    for (URL url : moduleLibraries) {
                        uris.add(Util.toURI((URL)url));
                    }
                } else {
                    ApplicationInfoProvider appInfoProvider = (ApplicationInfoProvider)this.habitat.getComponent(ApplicationInfoProvider.class);
                    if (appInfoProvider != null) {
                        List libraryJars = appInfoProvider.getLibraryJars(context);
                        for (URL url : libraryJars) {
                            uris.add(Util.toURI((URL)url));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            context.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        return uris;
    }
}

