/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets.frametypes;

import com.sun.grizzly.websockets.BaseFrameType;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.StrictUtf8;
import com.sun.grizzly.websockets.Utf8Utils;
import com.sun.grizzly.websockets.WebSocket;

public class TextFrameType
extends BaseFrameType {
    public void setPayload(DataFrame frame, byte[] data) {
        frame.setPayload(data);
    }

    public byte[] getBytes(DataFrame dataFrame) {
        byte[] bytes = dataFrame.getBytes();
        if (bytes == null) {
            this.setPayload(dataFrame, Utf8Utils.encode(new StrictUtf8(), dataFrame.getTextPayload()));
        }
        return dataFrame.getBytes();
    }

    public void respond(WebSocket socket, DataFrame frame) {
        if (frame.isLast()) {
            socket.onMessage(frame.getTextPayload());
        } else {
            socket.onFragment(frame.isLast(), frame.getTextPayload());
        }
    }
}

