/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.NetworkHandler;
import java.security.SecureRandom;

public class Masker {
    private final NetworkHandler handler;
    private byte[] mask;
    private int index = 0;

    public Masker(NetworkHandler handler) {
        this.handler = handler;
    }

    public byte unmask() {
        byte b = this.handler.get();
        return this.mask == null ? b : (byte)(b ^ this.mask[this.index++ % 4]);
    }

    public byte[] unmask(int count) {
        byte[] bytes = this.handler.get(count);
        if (this.mask != null) {
            int i = 0;
            while (i < bytes.length) {
                int n = i++;
                bytes[n] = (byte)(bytes[n] ^ this.mask[this.index++ % 4]);
            }
        }
        return bytes;
    }

    public void generateMask() {
        this.mask = new byte[4];
        new SecureRandom().nextBytes(this.mask);
    }

    public void mask(byte[] bytes, int location, byte b) {
        bytes[location] = this.mask == null ? b : (byte)(b ^ this.mask[this.index++ % 4]);
    }

    public void mask(byte[] target, int location, byte[] bytes) {
        if (bytes != null && target != null) {
            for (int i = 0; i < bytes.length; ++i) {
                target[location + i] = this.mask == null ? bytes[i] : (byte)(bytes[i] ^ this.mask[this.index++ % 4]);
            }
        }
    }

    public byte[] maskAndPrepend(byte[] packet, Masker masker) {
        byte[] masked = new byte[packet.length + 4];
        System.arraycopy(masker.getMask(), 0, masked, 0, 4);
        masker.mask(masked, 4, packet);
        return masked;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public void setMask(byte[] mask) {
        this.mask = mask;
    }
}

