/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsSupport;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public final class PlatformComponentFactory {
    private static final Color INVALID_PLAF_COLOR = UIManager.getColor("nb.errorForeground");
    private static Set<String> userSuites = new TreeSet<Object>(Collator.getInstance());

    private PlatformComponentFactory() {
    }

    public static JComboBox getNbPlatformsComboxBox() {
        JComboBox plafComboBox = new JComboBox(new NbPlatformListModel());
        plafComboBox.setRenderer(new NbPlatformListRenderer());
        return plafComboBox;
    }

    public static JList getNbPlatformsList() {
        JList plafList = new JList(new NbPlatformListModel());
        plafList.setSelectionMode(0);
        plafList.setCellRenderer(new NbPlatformListRenderer());
        return plafList;
    }

    public static JComboBox getSuitesComboBox() {
        SuiteListModel model = new SuiteListModel(userSuites);
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            String suiteDir = SuiteUtils.getSuiteDirectoryPath(projects[i]);
            if (suiteDir == null) continue;
            model.addElement(suiteDir);
        }
        JComboBox suiteCombo = new JComboBox(model);
        if (model.getSize() > 0) {
            suiteCombo.setSelectedIndex(0);
        }
        return suiteCombo;
    }

    public static void addUserSuite(String suiteDir) {
        userSuites.add(suiteDir);
    }

    public static ListCellRenderer getURLListRenderer() {
        return new URLListRenderer();
    }

    static final class JavadocRootsModel
    extends AbstractListModel {
        private static final RequestProcessor RP = new RequestProcessor(JavadocRootsModel.class);
        private JavadocRootsProvider jrp;
        private URL[] javadocRoots;

        JavadocRootsModel(final JavadocRootsProvider jrp) {
            this.jrp = jrp;
            this.javadocRoots = new URL[0];
            RP.post(new Runnable(){

                @Override
                public void run() {
                    final URL[] roots = jrp.getJavadocRoots();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JavadocRootsModel.access$102(JavadocRootsModel.this, roots);
                            JavadocRootsModel.this.fireContentsChanged(this, 0, JavadocRootsModel.this.javadocRoots.length);
                        }
                    });
                }
            });
        }

        @Override
        public Object getElementAt(int index) {
            return this.javadocRoots[index];
        }

        @Override
        public int getSize() {
            return this.javadocRoots.length;
        }

        void removeJavadocRoots(URL[] jdRootToRemove) {
            try {
                this.jrp.removeJavadocRoots(jdRootToRemove);
                this.javadocRoots = this.jrp.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void addJavadocRoot(URL jdRootToAdd) {
            try {
                this.jrp.addJavadocRoot(jdRootToAdd);
                this.javadocRoots = this.jrp.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveJavadocRootsDown(int[] toMoveDown) {
            try {
                for (int i = 0; i < toMoveDown.length; ++i) {
                    this.jrp.moveJavadocRootDown(toMoveDown[i]);
                }
                this.javadocRoots = this.jrp.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveJavadocRootsUp(int[] toMoveUp) {
            try {
                for (int i = 0; i < toMoveUp.length; ++i) {
                    this.jrp.moveJavadocRootUp(toMoveUp[i]);
                }
                this.javadocRoots = this.jrp.getJavadocRoots();
                this.fireContentsChanged(this, 0, this.javadocRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        boolean containsRoot(URL rootToAdd) {
            return JavadocRootsSupport.containsRoot(this.jrp, rootToAdd);
        }

        static /* synthetic */ URL[] access$102(JavadocRootsModel x0, URL[] x1) {
            x0.javadocRoots = x1;
            return x1;
        }
    }

    static class ModuleEntryListModel
    extends AbstractListModel {
        private ModuleEntry[] mes;

        ModuleEntryListModel(ModuleEntry[] mes) {
            this.mes = mes;
        }

        @Override
        public int getSize() {
            return this.mes.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.mes[index].getLocalizedName();
        }
    }

    public static class NbPlatformListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private NbPlatform[] nbPlafs;
        private Object selectedPlaf;

        private static NbPlatform[] getSortedPlatforms(NbPlatform extra) {
            Set<NbPlatform> _platforms = NbPlatform.getPlatforms();
            if (extra != null) {
                _platforms.add(extra);
            }
            NbPlatform[] platforms = _platforms.toArray(new NbPlatform[_platforms.size()]);
            Arrays.sort(platforms, new Comparator<NbPlatform>(){

                @Override
                public int compare(NbPlatform p1, NbPlatform p2) {
                    int res = Collator.getInstance().compare(p1.getLabel(), p2.getLabel());
                    if (res != 0) {
                        return res;
                    }
                    return System.identityHashCode(p1) - System.identityHashCode(p2);
                }
            });
            return platforms;
        }

        public NbPlatformListModel() {
            this.nbPlafs = NbPlatformListModel.getSortedPlatforms(null);
            if (this.nbPlafs.length > 0) {
                this.selectedPlaf = this.nbPlafs[0];
            }
        }

        public NbPlatformListModel(NbPlatform initiallySelected) {
            this.nbPlafs = NbPlatformListModel.getSortedPlatforms(initiallySelected);
            this.selectedPlaf = initiallySelected;
        }

        @Override
        public int getSize() {
            return this.nbPlafs.length;
        }

        @Override
        public Object getElementAt(int index) {
            return index < this.nbPlafs.length ? this.nbPlafs[index] : null;
        }

        @Override
        public void setSelectedItem(Object plaf) {
            assert (plaf == null || plaf instanceof NbPlatform);
            if (this.selectedPlaf != plaf) {
                this.selectedPlaf = plaf;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedPlaf;
        }

        void removePlatform(NbPlatform plaf) {
            try {
                NbPlatform.removePlatform(plaf);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms(null);
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        NbPlatform addPlatform(String id, String destdir, String label) {
            try {
                NbPlatform def = NbPlatform.getDefaultPlatform();
                NbPlatform plaf = def != null ? NbPlatform.addPlatform(id, new File(destdir), def.getHarnessLocation(), label) : NbPlatform.addPlatform(id, new File(destdir), label);
                this.nbPlafs = NbPlatformListModel.getSortedPlatforms(null);
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
                return plaf;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
                return null;
            }
        }
    }

    private static class NbPlatformListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public NbPlatformListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            NbPlatform plaf = (NbPlatform)value;
            String text = plaf == null ? "" : plaf.getLabel();
            this.setText(text);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (plaf != null && !plaf.isValid()) {
                this.setForeground(INVALID_PLAF_COLOR);
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    static final class SourceRootsModel
    extends AbstractListModel {
        private SourceRootsProvider srcRP;
        private URL[] srcRoots;

        SourceRootsModel(SourceRootsProvider srp) {
            this.srcRP = srp;
            this.srcRoots = srp.getSourceRoots();
        }

        @Override
        public Object getElementAt(int index) {
            return this.srcRoots[index];
        }

        @Override
        public int getSize() {
            return this.srcRoots.length;
        }

        void removeSourceRoot(URL[] srcRootToRemove) {
            try {
                this.srcRP.removeSourceRoots(srcRootToRemove);
                this.srcRoots = this.srcRP.getSourceRoots();
                this.fireContentsChanged(this, 0, srcRootToRemove.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void addSourceRoot(URL srcRootToAdd) {
            try {
                this.srcRP.addSourceRoot(srcRootToAdd);
                this.srcRoots = this.srcRP.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveSourceRootsDown(int[] toMoveDown) {
            try {
                for (int i = 0; i < toMoveDown.length; ++i) {
                    this.srcRP.moveSourceRootDown(toMoveDown[i]);
                }
                this.srcRoots = this.srcRP.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        void moveSourceRootsUp(int[] toMoveUp) {
            try {
                for (int i = 0; i < toMoveUp.length; ++i) {
                    this.srcRP.moveSourceRootUp(toMoveUp[i]);
                }
                this.srcRoots = this.srcRP.getSourceRoots();
                this.fireContentsChanged(this, 0, this.srcRoots.length);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(256, (Throwable)e);
            }
        }

        boolean containsRoot(URL srcRootToAdd) {
            return SourceRootsSupport.containsRoot(this.srcRP, srcRootToAdd);
        }
    }

    private static class SuiteListModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private Set<String> suites = new TreeSet<Object>(Collator.getInstance());
        private String selectedSuite;

        SuiteListModel(Set<String> suites) {
            this.suites.addAll(suites);
        }

        @Override
        public void setSelectedItem(Object suite) {
            if (suite == null) {
                return;
            }
            if (this.selectedSuite != suite) {
                this.selectedSuite = (String)suite;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedSuite;
        }

        @Override
        public int getSize() {
            return this.suites.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.suites.toArray()[index];
        }

        public void addElement(Object obj) {
            this.suites.add((String)obj);
            this.fireIntervalAdded(this, 0, this.suites.size());
        }

        public void insertElementAt(Object obj, int index) {
            assert (false) : "Who needs to insertElementAt?";
        }

        @Override
        public void removeElement(Object obj) {
            assert (false) : "Who needs to removeElement?";
        }

        @Override
        public void removeElementAt(int index) {
            assert (false) : "Who needs to call removeElementAt?";
        }
    }

    static final class URLListRenderer
    extends DefaultListCellRenderer {
        URLListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            URL u = (URL)value;
            File f = FileUtil.archiveOrDirForURL((URL)u);
            String text = f != null ? f.getAbsolutePath() : u.toString();
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }
}

