/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.suite.SuiteBrandingModel;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;

public final class SuiteProperties
extends ModuleProperties {
    public static final String DISABLED_MODULES_PROPERTY = "disabled.modules";
    public static final String ENABLED_CLUSTERS_PROPERTY = "enabled.clusters";
    public static final String DISABLED_CLUSTERS_PROPERTY = "disabled.clusters";
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String ACTIVE_NB_PLATFORM_PROPERTY = "nbplatform.active";
    public static final String ACTIVE_NB_PLATFORM_DIR_PROPERTY = "nbplatform.active.dir";
    public static final String CLUSTER_PATH_PROPERTY = "cluster.path";
    public static final String CLUSTER_PATH_WDC_PROPERTY = "cluster.path.with.disabled.clusters";
    public static final String CLUSTER_SRC_PREFIX = "extcluster.";
    private static final String PLATFORM_PROPERTIES = "nbproject/platform.properties";
    @NullAllowed
    private NbPlatform activePlatform;
    private JavaPlatform activeJavaPlatform;
    private SuiteProject project;
    private Set<NbModuleProject> origSubModules;
    private Set<NbModuleProject> subModules;
    private CustomizerComponentFactory.SuiteSubModulesListModel moduleListModel;
    private String[] disabledModules;
    private String[] enabledClusters;
    private boolean changedDisabledModules;
    private boolean changedEnabledClusters;
    private boolean clusterPathChanged;
    private final BrandingModel brandingModel;
    private Set<ClusterInfo> clusterPath;
    private boolean refreshBuildScripts;
    private EditableProperties platformProperties;
    private boolean platformPropertiesChanged;

    public SuiteProperties(SuiteProject project, AntProjectHelper helper, PropertyEvaluator evaluator, Set<NbModuleProject> subModules) {
        super(helper, evaluator);
        this.project = project;
        this.refresh(subModules);
        this.disabledModules = SuiteProperties.getArrayProperty(evaluator, DISABLED_MODULES_PROPERTY);
        this.enabledClusters = SuiteProperties.getArrayProperty(evaluator, ENABLED_CLUSTERS_PROPERTY);
        if (this.enabledClusters.length == 0 && this.activePlatform != null) {
            TreeSet<String> clusters = new TreeSet<String>();
            for (ModuleEntry module : this.activePlatform.getModules()) {
                clusters.add(module.getClusterDirectory().getName());
            }
            clusters.removeAll(Arrays.asList(SuiteProperties.getArrayProperty(evaluator, DISABLED_CLUSTERS_PROPERTY)));
            this.enabledClusters = new String[clusters.size()];
            int i = 0;
            for (String cluster : clusters) {
                this.enabledClusters[i++] = SingleModuleProperties.clusterBaseName(cluster);
            }
        }
        this.brandingModel = new SuiteBrandingModel(this);
        this.brandingModel.init();
    }

    @Override
    public void reloadProperties() {
        super.reloadProperties();
        this.platformProperties = this.getHelper().getProperties(PLATFORM_PROPERTIES);
        this.platformPropertiesChanged = false;
    }

    void refresh(Set<NbModuleProject> subModules) {
        this.reloadProperties();
        this.origSubModules = Collections.unmodifiableSet(subModules);
        this.subModules = subModules;
        this.moduleListModel = null;
        this.activePlatform = this.project.getPlatform(true);
        this.activeJavaPlatform = this.getJavaPlatform();
        this.firePropertiesRefreshed();
    }

    public SuiteProject getProject() {
        return this.project;
    }

    @Override
    Map<String, String> getDefaultValues() {
        return Collections.emptyMap();
    }

    @CheckForNull
    public NbPlatform getActivePlatform() {
        return this.activePlatform;
    }

    void setActivePlatform(@NonNull NbPlatform newPlaf) {
        NbPlatform oldPlaf = this.activePlatform;
        this.activePlatform = newPlaf;
        if (this.clusterPath != null) {
            EditableProperties ep = new EditableProperties(false);
            this.storeClusterPath(ep);
            PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.fixedPropertyProvider((Map)ep), new PropertyProvider(){

                public Map<String, String> getProperties() {
                    return SuiteProperties.this.getEvaluator().getProperties();
                }

                public void addChangeListener(ChangeListener l) {
                }

                public void removeChangeListener(ChangeListener l) {
                }
            }});
            this.clusterPath = ClusterUtils.evaluateClusterPath(this.getProjectDirectoryFile(), pe, newPlaf.getDestDir());
        }
        this.firePropertyChange(NB_PLATFORM_PROPERTY, oldPlaf, newPlaf);
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform nue) {
        JavaPlatform old = this.activeJavaPlatform;
        if (nue != old) {
            this.activeJavaPlatform = nue;
            this.firePropertyChange("nbjdk.active", old, nue);
        }
    }

    String[] getEnabledClusters() {
        return this.enabledClusters;
    }

    String[] getDisabledModules() {
        return this.disabledModules;
    }

    public void setEnabledClusters(String[] value) {
        if (((Object)Arrays.asList(this.enabledClusters)).equals(Arrays.asList(value))) {
            return;
        }
        this.enabledClusters = (String[])value.clone();
        this.changedEnabledClusters = true;
    }

    public void setDisabledModules(String[] value) {
        if (((Object)Arrays.asList(this.disabledModules)).equals(Arrays.asList(value))) {
            return;
        }
        this.disabledModules = (String[])value.clone();
        this.changedDisabledModules = true;
    }

    public static String[] getArrayProperty(PropertyEvaluator evaluator, String p) {
        String s = evaluator.getProperty(p);
        String[] arr = null;
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            arr = new String[tok.countTokens()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = tok.nextToken().trim();
            }
        }
        return arr == null ? new String[]{} : arr;
    }

    @Override
    public void storeProperties() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        NbPlatform plaf = this.getActivePlatform();
        ModuleProperties.storePlatform(this.getHelper(), plaf);
        ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
        this.getBrandingModel().store();
        CustomizerComponentFactory.SuiteSubModulesListModel model = this.getModulesListModel();
        if (model.isChanged()) {
            SuiteUtils.replaceSubModules(this);
        }
        if (this.changedDisabledModules || this.changedEnabledClusters || this.clusterPathChanged || this.platformPropertiesChanged) {
            int i;
            String[] separated;
            if (this.changedDisabledModules) {
                separated = (String[])this.disabledModules.clone();
                for (i = 0; i < this.disabledModules.length - 1; ++i) {
                    separated[i] = this.disabledModules[i] + ',';
                }
                this.platformProperties.setProperty(DISABLED_MODULES_PROPERTY, separated);
                this.setProperty(DISABLED_MODULES_PROPERTY, (String)null);
            }
            if (this.changedEnabledClusters) {
                separated = new String[this.enabledClusters.length];
                for (i = 0; i < this.enabledClusters.length; ++i) {
                    separated[i] = SuiteProperties.representationOfCluster(this.enabledClusters[i], plaf);
                    if (i >= this.enabledClusters.length - 1) continue;
                    separated[i] = separated[i] + ',';
                }
                this.platformProperties.setProperty(ENABLED_CLUSTERS_PROPERTY, separated);
                this.setProperty(ENABLED_CLUSTERS_PROPERTY, (String)null);
                if ((plaf == null || plaf.getHarnessVersion().compareTo(HarnessVersion.V50u1) < 0) && this.activePlatform != null) {
                    TreeSet<String> disabledClusters = new TreeSet<String>();
                    Set<ModuleEntry> modules = this.activePlatform.getModules();
                    for (ModuleEntry entry : modules) {
                        disabledClusters.add(entry.getClusterDirectory().getName());
                    }
                    disabledClusters.removeAll(Arrays.asList(this.enabledClusters));
                    separated = disabledClusters.toArray(new String[disabledClusters.size()]);
                    for (int i2 = 0; i2 < separated.length - 1; ++i2) {
                        separated[i2] = separated[i2] + ',';
                    }
                    this.platformProperties.setProperty(DISABLED_CLUSTERS_PROPERTY, separated);
                    this.platformProperties.setComment(DISABLED_CLUSTERS_PROPERTY, new String[]{"# Deprecated since 5.0u1; for compatibility with 5.0:"}, false);
                }
            }
            if (this.clusterPathChanged) {
                this.storeClusterPath(this.platformProperties);
            }
            this.getHelper().putProperties(PLATFORM_PROPERTIES, this.platformProperties);
            if (this.refreshBuildScripts) {
                try {
                    Set<NbModuleProject> subprojects = SuiteUtils.getSubProjects(this.getProject());
                    for (NbModuleProject prj : subprojects) {
                        prj.refreshBuildScripts(false, plaf);
                    }
                    this.getProject().refreshBuildScripts(false);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.changedDisabledModules = false;
            this.changedEnabledClusters = false;
            this.clusterPathChanged = false;
            this.platformPropertiesChanged = false;
            this.refreshBuildScripts = false;
        }
        super.storeProperties();
    }

    private static String representationOfCluster(String physicalName, NbPlatform platform) {
        if (platform != null && platform.getHarnessVersion().compareTo(HarnessVersion.V65) >= 0) {
            return SingleModuleProperties.clusterBaseName(physicalName);
        }
        return physicalName;
    }

    public Set<ClusterInfo> getClusterPath() {
        NbPlatform plaf;
        if (this.clusterPath == null && (plaf = this.activePlatform) != null) {
            this.clusterPath = ClusterUtils.evaluateClusterPath(this.getProjectDirectoryFile(), this.getEvaluator(), plaf.getDestDir());
        }
        return this.clusterPath;
    }

    public void setClusterPath(List<ClusterInfo> clusterPathList) {
        LinkedHashSet<ClusterInfo> newClusterPath = new LinkedHashSet<ClusterInfo>(clusterPathList);
        if (((Object)newClusterPath).equals(this.getClusterPath())) {
            return;
        }
        if (this.clusterPath.isEmpty()) {
            this.refreshBuildScripts = true;
        }
        this.clusterPath = newClusterPath;
        this.clusterPathChanged = true;
    }

    public static String toPlatformClusterEntry(String cluster) {
        return "${nbplatform.active.dir}/" + SingleModuleProperties.clusterBaseName(cluster);
    }

    Set<NbModuleProject> getSubModules() {
        return this.getModulesListModel().getSubModules();
    }

    Set<NbModuleProject> getOrigSubModules() {
        return this.origSubModules;
    }

    CustomizerComponentFactory.SuiteSubModulesListModel getModulesListModel() {
        if (this.moduleListModel == null) {
            this.moduleListModel = new CustomizerComponentFactory.SuiteSubModulesListModel(this.subModules);
        }
        return this.moduleListModel;
    }

    @NonNull
    public BrandingModel getBrandingModel() {
        return this.brandingModel;
    }

    private void storeClusterPath(EditableProperties ep) {
        ArrayList<String> cp = new ArrayList<String>();
        ArrayList<String> cpwdc = new ArrayList<String>();
        boolean anyDisabled = false;
        for (ClusterInfo ci : this.clusterPath) {
            String propName;
            if (ci.isPlatformCluster()) {
                String cluster = ci.getClusterDir().getName();
                String entry = SuiteProperties.toPlatformClusterEntry(cluster);
                cp.add(entry);
                cpwdc.add(entry);
                continue;
            }
            String entry = PropertyUtils.relativizeFile((File)this.getProjectDirectoryFile(), (File)ci.getClusterDir());
            if (entry == null) {
                entry = ci.getClusterDir().getAbsolutePath();
            }
            if (ci.isEnabled()) {
                cp.add(entry);
            } else {
                anyDisabled = true;
            }
            cpwdc.add(entry);
            if (!ci.isExternalCluster()) continue;
            if (ci.getSourceRoots() != null) {
                propName = CLUSTER_SRC_PREFIX + entry + ".sources";
                ep.setProperty(propName, ApisupportAntUtils.urlsToAntPath(ci.getSourceRoots()));
            }
            if (ci.getJavadocRoots() != null) {
                propName = CLUSTER_SRC_PREFIX + entry + ".javadoc";
                ep.setProperty(propName, ApisupportAntUtils.urlsToAntPath(ci.getJavadocRoots()));
            }
            ModuleList.refreshClusterModuleList(ci.getClusterDir());
        }
        if (anyDisabled) {
            ep.setProperty(CLUSTER_PATH_WDC_PROPERTY, SuiteUtils.getAntProperty(cpwdc));
        } else {
            ep.remove((Object)CLUSTER_PATH_WDC_PROPERTY);
        }
        ep.setProperty(CLUSTER_PATH_PROPERTY, SuiteUtils.getAntProperty(cp));
        ep.remove((Object)ENABLED_CLUSTERS_PROPERTY);
    }

    public void setPlatformProperty(String key, String value) {
        if (value != null) {
            this.platformProperties.put(key, value);
        } else {
            this.platformProperties.remove((Object)key);
        }
        this.platformPropertiesChanged = true;
        this.firePropertyChange(key, null, value);
    }

    public String getPlatformProperty(String key) {
        return this.platformProperties.get((Object)key);
    }
}

