/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.apisupport.project.ui.ShowJavadocAction;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ActionFilterNode
extends FilterNode {
    private static final int MODE_PACKAGE = 2;
    private static final int MODE_FILE = 3;
    private static final int MODE_FILE_CONTENT = 4;
    private final int mode;
    private Action[] actionCache;

    static ActionFilterNode create(Node original) {
        ProxyLookup lkp;
        FileObject root;
        DataObject dobj = (DataObject)original.getLookup().lookup(DataObject.class);
        if (dobj != null) {
            root = dobj.getPrimaryFile();
            lkp = new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)new JavadocProvider(root, root))});
        } else {
            root = null;
            lkp = new ProxyLookup(new Lookup[]{original.getLookup()});
            Logger.getLogger(ActionFilterNode.class.getName()).log(Level.WARNING, "DataObject not found in lookup of " + original.getDisplayName() + ", returning dummy node.");
        }
        return new ActionFilterNode(original, 2, root, (Lookup)lkp);
    }

    private ActionFilterNode(Node original, int mode, FileObject cpRoot, FileObject resource) {
        this(original, mode, cpRoot, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)new JavadocProvider(cpRoot, resource))}));
    }

    private ActionFilterNode(Node original, int mode) {
        super(original, (Children)(original.isLeaf() ? FilterNode.Children.LEAF : new ActionFilterChildren(original, mode, null)));
        this.mode = mode;
    }

    private ActionFilterNode(Node original, int mode, FileObject root, Lookup lkp) {
        super(original, (Children)(original.isLeaf() ? FilterNode.Children.LEAF : new ActionFilterChildren(original, mode, root)), lkp);
        this.mode = mode;
    }

    public Action[] getActions(boolean context) {
        Action[] result = this.initActions();
        return result;
    }

    public Action getPreferredAction() {
        Action[] actions;
        if (this.mode == 3 && (actions = this.initActions()).length > 0 && (actions[0] instanceof OpenAction || actions[0] instanceof EditAction)) {
            return actions[0];
        }
        return null;
    }

    private Action[] initActions() {
        if (this.actionCache == null) {
            ArrayList<Action> result = new ArrayList<Action>(2);
            if (this.mode == 3) {
                for (Action superAction : super.getActions(false)) {
                    if (!(superAction instanceof OpenAction) && !(superAction instanceof EditAction)) continue;
                    result.add(superAction);
                }
                result.add((Action)SystemAction.get(ShowJavadocAction.class));
            } else if (this.mode == 2) {
                result.add((Action)SystemAction.get(ShowJavadocAction.class));
                for (Action superAction : super.getActions(false)) {
                    if (!(superAction instanceof FindAction)) continue;
                    result.add(superAction);
                }
            }
            this.actionCache = result.toArray(new Action[result.size()]);
        }
        return this.actionCache;
    }

    private static class ActionFilterChildren
    extends FilterNode.Children {
        private final int mode;
        private final FileObject cpRoot;

        ActionFilterChildren(Node original, int mode, FileObject cpRooot) {
            super(original);
            this.mode = mode;
            this.cpRoot = cpRooot;
        }

        protected Node[] createNodes(Node n) {
            switch (this.mode) {
                case 2: {
                    FileObject fobj = (FileObject)n.getLookup().lookup(FileObject.class);
                    if (fobj == null) {
                        return super.createNodes(n);
                    }
                    if (fobj.isFolder()) {
                        return new Node[]{new ActionFilterNode(n, 2, this.cpRoot, fobj)};
                    }
                    return new Node[]{new ActionFilterNode(n, 3, this.cpRoot, fobj)};
                }
                case 3: 
                case 4: {
                    return new Node[]{new ActionFilterNode(n, 4)};
                }
            }
            assert (false) : "Unknown mode";
            return new Node[0];
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final FileObject cpRoot;
        private final FileObject resource;

        JavadocProvider(FileObject cpRoot, FileObject resource) {
            this.cpRoot = cpRoot;
            this.resource = resource;
        }

        @Override
        public boolean hasJavadoc() {
            boolean rNotNull = this.resource != null;
            int jLength = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.toURL()).getRoots().length;
            return rNotNull && jLength > 0;
        }

        @Override
        public void showJavadoc() {
            URL pageURL;
            String relativeName = FileUtil.getRelativePath((FileObject)this.cpRoot, (FileObject)this.resource);
            URL[] urls = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.toURL()).getRoots();
            if (relativeName.length() == 0) {
                pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
                if (pageURL == null) {
                    pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
                }
            } else if (this.resource.isFolder()) {
                pageURL = ShowJavadocAction.findJavadoc(relativeName + "/package-summary.html", urls);
            } else {
                String javadocFileName = relativeName.substring(0, relativeName.lastIndexOf(46)) + ".html";
                pageURL = ShowJavadocAction.findJavadoc(javadocFileName, urls);
            }
            ShowJavadocAction.showJavaDoc(pageURL, relativeName.replace('/', '.'));
        }
    }
}

