/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    public static final String BOOTCLASSPATH_PREPEND = "bootclasspath.prepend";
    private final NbModuleProject project;
    private ClassPath boot;
    private ClassPath source;
    private ClassPath compile;
    private ClassPath execute;
    private ClassPath testSource;
    private ClassPath testCompile;
    private ClassPath testExecute;
    private ClassPath funcTestSource;
    private ClassPath funcTestCompile;
    private ClassPath funcTestExecute;
    private Map<FileObject, ClassPath> extraCompilationUnitsCompile = null;
    private Map<FileObject, ClassPath> extraCompilationUnitsExecute = null;
    private static final Logger LOG = Logger.getLogger(ClassPathProviderImpl.class.getName());

    public ClassPathProviderImpl(NbModuleProject project) {
        this.project = project;
    }

    /*
     * Unable to fully structure code
     */
    public ClassPath findClassPath(FileObject file, String type) {
        block32: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block31: {
                                if (type.equals("classpath/boot")) {
                                    if (this.boot == null) {
                                        this.boot = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])new ClassPathImplementation[]{this.createPathFromProperty("bootclasspath.prepend"), this.createPathFromProperty("nbjdk.bootclasspath")}));
                                    }
                                    return this.boot;
                                }
                                srcDir = this.project.getSourceDirectory();
                                testSrcDir = this.project.getTestSourceDirectory("unit");
                                funcTestSrcDir = this.project.getTestSourceDirectory("qa-functional");
                                dir = this.project.getClassesDirectory();
                                classesDir = (dir = FileUtil.normalizeFile((File)dir)).exists() != false ? FileUtil.toFileObject((File)dir) : null;
                                dir = this.project.getTestClassesDirectory("unit");
                                dir = FileUtil.normalizeFile((File)dir);
                                testClassesDir = dir.exists() != false ? FileUtil.toFileObject((File)dir) : null;
                                generatedClasses = FileUtil.urlForArchiveOrDir((File)this.project.getGeneratedClassesDirectory());
                                generatedUnitTestClasses = FileUtil.urlForArchiveOrDir((File)this.project.getTestGeneratedClassesDirectory("unit"));
                                generatedFunctionalTestClasses = FileUtil.urlForArchiveOrDir((File)this.project.getTestGeneratedClassesDirectory("qa-functional"));
                                fileU = file.toURL().toString();
                                if (srcDir == null || generatedClasses == null || !FileUtil.isParentOf((FileObject)srcDir, (FileObject)file) && file != srcDir && !fileU.startsWith(generatedClasses.toString())) break block31;
                                if (type.equals("classpath/compile")) {
                                    if (this.compile == null) {
                                        this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createCompileClasspath());
                                        ClassPathProviderImpl.LOG.log(Level.FINE, "compile/execute-time classpath for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), this.project, this.compile});
                                    }
                                    return this.compile;
                                }
                                if (type.equals("classpath/execute") || type.equals("classpath/processor")) {
                                    if (this.execute == null) {
                                        this.execute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createExecuteClasspath());
                                    }
                                    return this.execute;
                                }
                                if (type.equals("classpath/source")) {
                                    if (this.source == null) {
                                        this.source = ClassPathSupport.createClassPath((URL[])new URL[]{srcDir.toURL(), generatedClasses});
                                    }
                                    return this.source;
                                }
                                break block32;
                            }
                            if (testSrcDir == null || generatedUnitTestClasses == null || !FileUtil.isParentOf((FileObject)testSrcDir, (FileObject)file) && file != testSrcDir && !fileU.startsWith(generatedUnitTestClasses.toString())) break block33;
                            if (type.equals("classpath/compile")) {
                                if (this.testCompile == null) {
                                    this.testCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestCompileClasspath("unit"));
                                    ClassPathProviderImpl.LOG.log(Level.FINE, "compile-time classpath for tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), this.project, this.testCompile});
                                }
                                return this.testCompile;
                            }
                            if (type.equals("classpath/execute") || type.equals("classpath/processor")) {
                                if (this.testExecute == null) {
                                    this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath("unit"));
                                    ClassPathProviderImpl.LOG.log(Level.FINE, "runtime classpath for tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), this.project, this.testExecute});
                                }
                                return this.testExecute;
                            }
                            if (type.equals("classpath/source")) {
                                if (this.testSource == null) {
                                    this.testSource = ClassPathSupport.createClassPath((URL[])new URL[]{testSrcDir.toURL(), generatedUnitTestClasses});
                                }
                                return this.testSource;
                            }
                            break block32;
                        }
                        if (funcTestSrcDir == null || generatedFunctionalTestClasses == null || !FileUtil.isParentOf((FileObject)funcTestSrcDir, (FileObject)file) && file != funcTestSrcDir && !fileU.startsWith(generatedFunctionalTestClasses.toString())) break block34;
                        if (type.equals("classpath/source")) {
                            if (this.funcTestSource == null) {
                                this.funcTestSource = ClassPathSupport.createClassPath((URL[])new URL[]{funcTestSrcDir.toURL(), generatedFunctionalTestClasses});
                            }
                            return this.funcTestSource;
                        }
                        if (type.equals("classpath/compile")) {
                            if (this.funcTestCompile == null) {
                                this.funcTestCompile = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestCompileClasspath("qa-functional"));
                                ClassPathProviderImpl.LOG.log(Level.FINE, "compile-time classpath for func tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), this.project, this.funcTestCompile});
                            }
                            return this.funcTestCompile;
                        }
                        if (type.equals("classpath/execute") || type.equals("classpath/processor")) {
                            if (this.funcTestExecute == null) {
                                this.funcTestExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath("qa-functional"));
                            }
                            return this.funcTestExecute;
                        }
                        break block32;
                    }
                    if (classesDir == null || !classesDir.equals(file) && !FileUtil.isParentOf((FileObject)classesDir, (FileObject)file)) break block35;
                    if ("classpath/execute".equals(type)) {
                        roots = new ArrayList<PathResourceImplementation>();
                        roots.add(ClassPathSupport.createResource((URL)classesDir.toURL()));
                        roots.addAll(this.createCompileClasspath().getResources());
                        return ClassPathSupport.createClassPath(roots);
                    }
                    break block32;
                }
                if (testClassesDir == null || !testClassesDir.equals(file) && !FileUtil.isParentOf((FileObject)testClassesDir, (FileObject)file)) break block36;
                if ("classpath/execute".equals(type)) {
                    if (this.testExecute == null) {
                        this.testExecute = ClassPathFactory.createClassPath((ClassPathImplementation)this.createTestExecuteClasspath("unit"));
                        ClassPathProviderImpl.LOG.log(Level.FINE, "runtime classpath for tests for file ''{0}'' (prj: {1}): {2}", new Object[]{file.getPath(), this.project, this.testExecute});
                    }
                    return this.testExecute;
                }
                break block32;
            }
            if (FileUtil.getArchiveFile((FileObject)file) == null || !file.equals(FileUtil.getArchiveRoot((FileObject)FileUtil.getArchiveFile((FileObject)file)))) ** GOTO lbl-1000
            moduleJar = this.project.getModuleJarLocation();
            if (FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)file)).equals(moduleJar)) {
                if ("classpath/execute".equals(type)) {
                    roots = new ArrayList<PathResourceImplementation>();
                    roots.add(ClassPathSupport.createResource((URL)FileUtil.urlForArchiveOrDir((File)moduleJar)));
                    roots.addAll(this.createCompileClasspath().getResources());
                    return ClassPathSupport.createClassPath(roots);
                }
            } else lbl-1000:
            // 2 sources

            {
                this.calculateExtraCompilationUnits();
                for (Map.Entry<FileObject, ClassPath> entry : this.extraCompilationUnitsCompile.entrySet()) {
                    pkgroot = entry.getKey();
                    if (!FileUtil.isParentOf((FileObject)pkgroot, (FileObject)file) && file != pkgroot) continue;
                    if (type.equals("classpath/compile")) {
                        return entry.getValue();
                    }
                    if (type.equals("classpath/execute")) {
                        return this.extraCompilationUnitsExecute.get(pkgroot);
                    }
                    if (!type.equals("classpath/source")) break;
                    return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{pkgroot});
                }
            }
        }
        if (type.equals("classpath/source") && (properties = this.project.evaluator().getProperties()) != null) {
            for (Map.Entry<K, V> entry : properties.entrySet()) {
                if (!((String)entry.getKey()).startsWith("source.reference.") || (jar = this.project.getHelper().resolveFileObject((String)entry.getValue())) == null || (root = FileUtil.getArchiveRoot((FileObject)jar)) == null || root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root});
            }
        }
        return null;
    }

    private ClassPathImplementation createPathFromProperty(String prop) {
        return ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.project.getProjectDirectoryFile(), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{prop});
    }

    private ClassPathImplementation createCompileClasspath() {
        return this.createPathFromProperty("cp");
    }

    private void addPathFromProjectEvaluated(List<PathResourceImplementation> entries, String path) {
        if (path != null) {
            for (String piece : PropertyUtils.tokenizePath((String)path)) {
                URL url = FileUtil.urlForArchiveOrDir((File)this.project.getHelper().resolveFile(piece));
                if (url == null) continue;
                entries.add(ClassPathSupport.createResource((URL)url));
            }
        }
    }

    private ClassPathImplementation createTestCompileClasspath(String testType) {
        return this.createPathFromProperty("test." + testType + ".cp");
    }

    private ClassPathImplementation createTestExecuteClasspath(String testType) {
        return this.createPathFromProperty("test." + testType + ".run.cp");
    }

    private ClassPathImplementation createExecuteClasspath() {
        return this.createPathFromProperty("run.cp");
    }

    private void calculateExtraCompilationUnits() {
        if (this.extraCompilationUnitsCompile != null) {
            return;
        }
        this.extraCompilationUnitsCompile = new HashMap<FileObject, ClassPath>();
        this.extraCompilationUnitsExecute = new HashMap<FileObject, ClassPath>();
        for (Map.Entry<FileObject, Element> entry : this.project.getExtraCompilationUnits().entrySet()) {
            final FileObject pkgroot = entry.getKey();
            Element pkgrootEl = entry.getValue();
            Element classpathEl = XMLUtil.findElement((Element)pkgrootEl, (String)"classpath", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            assert (classpathEl != null) : "no <classpath> in " + pkgrootEl;
            final String classpathS = XMLUtil.findText((Node)classpathEl);
            if (classpathS == null) {
                this.extraCompilationUnitsCompile.put(pkgroot, ClassPathSupport.createClassPath((URL[])new URL[0]));
                this.extraCompilationUnitsExecute.put(pkgroot, ClassPathSupport.createClassPath((URL[])new URL[0]));
                continue;
            }
            class CPI
            implements ClassPathImplementation,
            PropertyChangeListener,
            AntProjectListener {
                final Set<String> relevantProperties = new HashSet<String>();
                final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
                String cpS = classpathS;

                CPI() {
                    ClassPathProviderImpl.this.project.evaluator().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ClassPathProviderImpl.this.project.evaluator()));
                    ClassPathProviderImpl.this.project.getHelper().addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this, (Object)ClassPathProviderImpl.this.project.getHelper()));
                    Matcher m = Pattern.compile("\\$\\{([^{}]+)\\}").matcher(this.cpS);
                    while (m.find()) {
                        this.relevantProperties.add(m.group(1));
                    }
                }

                public List<? extends PathResourceImplementation> getResources() {
                    ArrayList resources = new ArrayList();
                    ClassPathProviderImpl.this.addPathFromProjectEvaluated(resources, ClassPathProviderImpl.this.project.evaluator().evaluate(this.cpS));
                    return resources;
                }

                public void addPropertyChangeListener(PropertyChangeListener listener) {
                    this.pcs.addPropertyChangeListener(listener);
                }

                public void removePropertyChangeListener(PropertyChangeListener listener) {
                    this.pcs.removePropertyChangeListener(listener);
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (this.relevantProperties.contains(evt.getPropertyName())) {
                        this.pcs.firePropertyChange("resources", null, null);
                    }
                }

                public void configurationXmlChanged(AntProjectEvent ev) {
                    Element pkgrootEl = ClassPathProviderImpl.this.project.getExtraCompilationUnits().get(pkgroot);
                    Element classpathEl = XMLUtil.findElement((Element)pkgrootEl, (String)"classpath", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                    assert (classpathEl != null) : "no <classpath> in " + pkgrootEl;
                    this.cpS = XMLUtil.findText((Node)classpathEl);
                    this.pcs.firePropertyChange("resources", null, null);
                }

                public void propertiesChanged(AntProjectEvent ev) {
                }
            }
            CPI ecuCompile = new CPI();
            this.extraCompilationUnitsCompile.put(pkgroot, ClassPathFactory.createClassPath((ClassPathImplementation)ecuCompile));
            ArrayList<PathResourceImplementation> extraEntries = new ArrayList<PathResourceImplementation>();
            for (Element kid : XMLUtil.findSubElements((Element)pkgrootEl)) {
                if (!kid.getLocalName().equals("built-to")) continue;
                String rawtext = XMLUtil.findText((Node)kid);
                assert (rawtext != null) : "Null content for <built-to> in " + this.project;
                String text = this.project.evaluator().evaluate(rawtext);
                if (text == null) continue;
                this.addPathFromProjectEvaluated(extraEntries, text);
            }
            this.extraCompilationUnitsExecute.put(pkgroot, ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupport.createProxyClassPathImplementation((ClassPathImplementation[])new ClassPathImplementation[]{ecuCompile, ClassPathSupport.createClassPathImplementation(extraEntries)})));
        }
    }

    public ClassPath[] getProjectClassPaths(String type) {
        FileObject srcDir;
        if ("classpath/boot".equals(type) && (srcDir = this.project.getSourceDirectory()) != null) {
            return new ClassPath[]{this.findClassPath(srcDir, "classpath/boot")};
        }
        ArrayList<ClassPath> paths = new ArrayList<ClassPath>(3);
        if ("classpath/compile".equals(type)) {
            FileObject srcDir2 = this.project.getSourceDirectory();
            if (srcDir2 != null) {
                paths.add(this.findClassPath(srcDir2, "classpath/compile"));
            }
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null) continue;
                paths.add(this.findClassPath(testSrcDir, "classpath/compile"));
            }
            this.calculateExtraCompilationUnits();
            paths.addAll(this.extraCompilationUnitsCompile.values());
        } else if ("classpath/execute".equals(type)) {
            FileObject srcDir3 = this.project.getSourceDirectory();
            if (srcDir3 != null) {
                paths.add(this.findClassPath(srcDir3, "classpath/execute"));
            }
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null) continue;
                paths.add(this.findClassPath(testSrcDir, "classpath/execute"));
            }
            this.calculateExtraCompilationUnits();
            paths.addAll(this.extraCompilationUnitsExecute.values());
        } else if ("classpath/source".equals(type)) {
            FileObject srcDir4 = this.project.getSourceDirectory();
            if (srcDir4 != null) {
                paths.add(this.findClassPath(srcDir4, "classpath/source"));
            }
            for (String testType : this.project.supportedTestTypes()) {
                FileObject testSrcDir = this.project.getTestSourceDirectory(testType);
                if (testSrcDir == null) continue;
                paths.add(this.findClassPath(testSrcDir, "classpath/source"));
            }
            this.calculateExtraCompilationUnits();
            for (FileObject root : this.extraCompilationUnitsCompile.keySet()) {
                paths.add(ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root}));
            }
        }
        return paths.toArray(new ClassPath[paths.size()]);
    }
}

