/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11.filters;

import com.sun.grizzly.lzma.compression.lzma.Encoder;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LzmaOutputFilter
implements OutputFilter {
    private static final boolean isLog = Boolean.getBoolean("lzma-filter.isLog");
    private static final Logger logger = Logger.getLogger(LzmaOutputFilter.class.getName());
    public static final String ENCODING_NAME = "lzma";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected OutputBuffer buffer;
    protected Encoder encoder;
    protected final LzmaProperties lzmaProperties = new LzmaProperties();
    protected final ReusableByteArrayInputStream byteArrayInputStream = new ReusableByteArrayInputStream();
    protected OutputStream fakeOutputStream = new FakeOutputStream();

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (this.encoder == null) {
            this.initEncoder();
        }
        this.byteArrayInputStream.setArray(chunk.getBytes(), chunk.getStart(), chunk.getLength());
        this.encoder.Code((InputStream)this.byteArrayInputStream, this.fakeOutputStream, -1L, -1L, null);
        this.fakeOutputStream.flush();
        return chunk.getLength();
    }

    public void setResponse(Response response) {
    }

    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    public long end() throws IOException {
        if (this.encoder == null) {
            this.initEncoder();
        }
        this.fakeOutputStream.flush();
        return ((OutputFilter)this.buffer).end();
    }

    public void recycle() {
        this.encoder = null;
    }

    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    private void initEncoder() throws IOException {
        this.encoder = new Encoder();
        this.encoder.SetAlgorithm(this.lzmaProperties.getAlgorithm());
        this.encoder.SetDictionarySize(this.lzmaProperties.getDictionarySize());
        this.encoder.SetNumFastBytes(this.lzmaProperties.getNumFastBytes());
        this.encoder.SetMatchFinder(this.lzmaProperties.getMatchFinder());
        this.encoder.SetLcLpPb(this.lzmaProperties.getLc(), this.lzmaProperties.getLp(), this.lzmaProperties.getPb());
        this.encoder.SetEndMarkerMode(true);
        this.encoder.WriteCoderProperties(this.fakeOutputStream);
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected ByteChunk outputChunk = new ByteChunk();
        protected byte[] singleByteBuffer = new byte[4096];
        protected int offset = 0;

        protected FakeOutputStream() {
        }

        public void write(int b) throws IOException {
            if (this.offset >= this.singleByteBuffer.length) {
                this.flush();
            }
            this.singleByteBuffer[this.offset++] = (byte)(b & 0xFF);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.flush();
            if (isLog) {
                this.log(b, off, len);
            }
            this.outputChunk.setBytes(b, off, len);
            LzmaOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        public void flush() throws IOException {
            if (this.offset > 0) {
                int localOffset = this.offset;
                this.offset = 0;
                this.outputChunk.setBytes(this.singleByteBuffer, 0, localOffset);
                if (isLog) {
                    this.log(this.singleByteBuffer, 0, localOffset);
                }
                LzmaOutputFilter.this.buffer.doWrite(this.outputChunk, null);
            }
        }

        public void close() throws IOException {
            this.flush();
        }

        protected void log(byte[] buffer, int offset, int length) {
            StringBuilder sb = new StringBuilder();
            for (int i = offset; i < length; ++i) {
                sb.append(Integer.toHexString(buffer[i] & 0xFF));
                sb.append(' ');
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("LzmaOutputFilter write: " + sb.toString());
            }
        }
    }

    public static class LzmaProperties {
        private int algorithm = 2;
        private int dictionarySize = 65536;
        private int numFastBytes = 128;
        private int matchFinder = 1;
        private int lc = 3;
        private int lp = 0;
        private int pb = 2;

        public LzmaProperties() {
            LzmaProperties.loadProperties(this);
        }

        public LzmaProperties(int algorithm, int dictionarySize, int numFastBytes, int matchFinder, int lc, int lp, int pb) {
            this.algorithm = algorithm;
            this.dictionarySize = dictionarySize;
            this.numFastBytes = numFastBytes;
            this.matchFinder = matchFinder;
            this.lc = lc;
            this.lp = lp;
            this.pb = pb;
        }

        public int getLc() {
            return this.lc;
        }

        public void setLc(int Lc) {
            this.lc = Lc;
        }

        public int getLp() {
            return this.lp;
        }

        public void setLp(int Lp) {
            this.lp = Lp;
        }

        public int getPb() {
            return this.pb;
        }

        public void setPb(int Pb) {
            this.pb = Pb;
        }

        public int getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(int algorithm) {
            this.algorithm = algorithm;
        }

        public int getDictionarySize() {
            return this.dictionarySize;
        }

        public void setDictionarySize(int dictionarySize) {
            this.dictionarySize = dictionarySize;
        }

        public int getMatchFinder() {
            return this.matchFinder;
        }

        public void setMatchFinder(int matchFinder) {
            this.matchFinder = matchFinder;
        }

        public int getNumFastBytes() {
            return this.numFastBytes;
        }

        public void setNumFastBytes(int numFastBytes) {
            this.numFastBytes = numFastBytes;
        }

        public static void loadProperties(LzmaProperties properties) {
            properties.algorithm = Integer.getInteger("lzma-filter.algorithm", 2);
            properties.dictionarySize = 1 << Integer.getInteger("lzma-filter.dictionary-size", 16);
            properties.numFastBytes = Integer.getInteger("lzma-filter.num-fast-bytes", 128);
            properties.matchFinder = Integer.getInteger("lzma-filter.match-finder", 1);
            properties.lc = Integer.getInteger("lzma-filter.lc", 3);
            properties.lp = Integer.getInteger("lzma-filter.lp", 0);
            properties.pb = Integer.getInteger("lzma-filter.pb", 2);
        }
    }

    public static class ReusableByteArrayInputStream
    extends ByteArrayInputStream {
        private static final byte[] ZERO_ARRAY = new byte[0];

        public ReusableByteArrayInputStream() {
            super(ZERO_ARRAY);
        }

        public void setArray(byte[] array) {
            this.setArray(array, 0, array.length);
        }

        public void setArray(byte[] array, int offset, int length) {
            this.buf = array;
            this.pos = offset;
            this.count = Math.min(offset + length, this.buf.length);
            this.mark = offset;
        }
    }
}

