/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Configuration;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ConfigurationsManager {
    private static final String RULE_PREFIX = "rule_config_";
    private static final String KEY_CONFIGURATIONS_VERSION = "configurations.version";
    private static final int CURRENT_CONFIGURATIONS_VERSION = 1;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static ConfigurationsManager instance;
    private ArrayList<Configuration> configs = new ArrayList();

    private ConfigurationsManager() {
        this.init();
    }

    public static synchronized ConfigurationsManager getDefault() {
        if (instance == null) {
            instance = new ConfigurationsManager();
        }
        return instance;
    }

    public Configuration getDefaultConfiguration() {
        return this.getConfiguration(0);
    }

    public List<Configuration> getConfigurations() {
        return Collections.unmodifiableList(this.configs);
    }

    public Configuration getConfiguration(int i) {
        return this.configs.get(i);
    }

    public int size() {
        return this.configs.size();
    }

    private void init() {
        Preferences prefs = NbPreferences.forModule(this.getClass());
        try {
            for (String kid : prefs.childrenNames()) {
                if (!kid.startsWith(RULE_PREFIX)) continue;
                Preferences p = NbPreferences.forModule(this.getClass()).node(kid);
                String displayName = p.get("display.name", "unknown");
                this.create(kid.substring(RULE_PREFIX.length()), displayName);
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        int configurationsVersion = prefs.getInt(KEY_CONFIGURATIONS_VERSION, 0);
        if (this.configs.isEmpty()) {
            this.create("default", NbBundle.getMessage(ConfigurationsManager.class, (String)"DN_Default"));
            Configuration jdk7 = this.create("jdk7", NbBundle.getMessage(ConfigurationsManager.class, (String)"DN_ConvertToJDK7"));
            jdk7.enable("Javac_canUseDiamond");
            jdk7.enable("org.netbeans.modules.java.hints.jdk.ConvertToStringSwitch");
            jdk7.enable("org.netbeans.modules.java.hints.jdk.ConvertToARM");
            jdk7.enable("org.netbeans.modules.java.hints.jdk.JoinCatches");
            jdk7.enable("org.netbeans.modules.java.hints.jdk.UseSpecificCatch");
        }
        if (configurationsVersion < 1 && !this.configurationExists("organizeImports")) {
            Configuration organizeImports = this.create("organizeImports", NbBundle.getMessage(ConfigurationsManager.class, (String)"DN_OrganizeImports"));
            organizeImports.enable("org.netbeans.modules.java.hints.OrganizeImports");
        }
        prefs.putInt(KEY_CONFIGURATIONS_VERSION, 1);
    }

    private boolean configurationExists(String id) {
        for (Configuration c : this.configs) {
            if (!id.equals(c.id())) continue;
            return true;
        }
        return false;
    }

    public Configuration create(String id, String displayName) {
        assert (!id.startsWith(RULE_PREFIX));
        Configuration config = new Configuration(RULE_PREFIX + id, displayName);
        this.configs.add(config);
        this.changeSupport.fireChange();
        return config;
    }

    public Configuration duplicate(Configuration orig, String id, String displayName) {
        assert (!id.startsWith(RULE_PREFIX));
        Configuration config = new Configuration(RULE_PREFIX + id, displayName);
        this.configs.add(config);
        Preferences oldOne = NbPreferences.forModule(this.getClass()).node(orig.id());
        Preferences newOne = NbPreferences.forModule(this.getClass()).node(config.id());
        try {
            for (String name : oldOne.childrenNames()) {
                Preferences node = oldOne.node(name);
                for (String key : node.keys()) {
                    String old = node.get(key, null);
                    newOne.node(name).put(key, old);
                }
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changeSupport.fireChange();
        return config;
    }

    public void remove(Configuration config) {
        this.configs.remove(config);
        Preferences prefs = NbPreferences.forModule(this.getClass()).node(config.id());
        try {
            prefs.removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }
}

