/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class AbstractApplyHintsRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin,
ProgressHandleWrapper.ProgressHandleAbstraction {
    private final AbstractRefactoring refactoring;
    protected final AtomicBoolean cancel = new AtomicBoolean();
    private int lastWorkDone;

    protected AbstractApplyHintsRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void cancelRequest() {
        this.cancel.set(true);
    }

    protected final Problem messagesToProblem(Collection<MessageImpl> problems) throws IllegalStateException {
        Problem current = null;
        for (MessageImpl problem : problems) {
            Problem p = new Problem(problem.kind == HintContext.MessageKind.ERROR, problem.text);
            if (current != null) {
                p.setNext(current);
            }
            current = p;
        }
        return current;
    }

    protected Collection<MessageImpl> performApplyPattern(Iterable<? extends HintDescription> pattern, BatchSearch.Scope scope, RefactoringElementsBag refactoringElements) {
        ProgressHandleWrapper w = new ProgressHandleWrapper((ProgressHandleWrapper.ProgressHandleAbstraction)this, new int[]{30, 70});
        BatchSearch.BatchResult candidates = BatchSearch.findOccurrences(pattern, (BatchSearch.Scope)scope, (ProgressHandleWrapper)w);
        ArrayList fileChanges = new ArrayList();
        LinkedList<MessageImpl> problems = new LinkedList<MessageImpl>(candidates.problems);
        HashMap changesPerFix = new HashMap();
        Collection res = BatchUtilities.applyFixes((BatchSearch.BatchResult)candidates, (ProgressHandleWrapper)w, (AtomicBoolean)this.cancel, fileChanges, changesPerFix, problems);
        Set<ModificationResult> enabled = Collections.newSetFromMap(new IdentityHashMap());
        HashMap<FileObject, Map<JavaFix, ModificationResult>> file2Fixes2Changes = new HashMap<FileObject, Map<JavaFix, ModificationResult>>();
        HashMap<FileObject, Set<FileObject>> affectedFiles = new HashMap<FileObject, Set<FileObject>>();
        HashMap<FileObject, ArrayList<ModificationResultElement>> file2Changes = new HashMap<FileObject, ArrayList<ModificationResultElement>>();
        for (Map.Entry changesPerFixEntry : changesPerFix.entrySet()) {
            enabled.add((ModificationResult)changesPerFixEntry.getValue());
            for (FileObject file : ((ModificationResult)changesPerFixEntry.getValue()).getModifiedFileObjects()) {
                ArrayList<ModificationResultElement> currentFileChanges = (ArrayList<ModificationResultElement>)file2Changes.get(file);
                if (currentFileChanges == null) {
                    currentFileChanges = new ArrayList<ModificationResultElement>();
                    file2Changes.put(file, currentFileChanges);
                }
                currentFileChanges.add(new ModificationResultElement(file, (JavaFix)changesPerFixEntry.getKey(), (ModificationResult)changesPerFixEntry.getValue(), enabled));
                HashMap perFile = (HashMap)file2Fixes2Changes.get(file);
                if (perFile == null) {
                    perFile = new HashMap();
                    file2Fixes2Changes.put(file, perFile);
                }
                perFile.put(changesPerFixEntry.getKey(), changesPerFixEntry.getValue());
                HashSet aff = (HashSet)affectedFiles.get(file);
                if (aff == null) {
                    aff = new HashSet();
                    affectedFiles.put(file, aff);
                }
                aff.addAll(((ModificationResult)changesPerFixEntry.getValue()).getModifiedFileObjects());
            }
        }
        for (List changes : file2Changes.values()) {
            Collections.sort(changes, new Comparator<RefactoringElementImplementation>(){

                @Override
                public int compare(RefactoringElementImplementation o1, RefactoringElementImplementation o2) {
                    return o1.getPosition().getBegin().getOffset() - o2.getPosition().getBegin().getOffset();
                }
            });
            refactoringElements.addAll(this.refactoring, (Collection)changes);
        }
        refactoringElements.registerTransaction((Transaction)new DelegatingTransaction(enabled, file2Fixes2Changes, affectedFiles, res));
        for (RefactoringElementImplementation fileChange : fileChanges) {
            refactoringElements.addFileChange(this.refactoring, fileChange);
        }
        w.finish();
        return problems;
    }

    protected final void prepareElements(BatchSearch.BatchResult candidates, ProgressHandleWrapper w, final RefactoringElementsBag refactoringElements, final boolean verify, List<MessageImpl> problems) {
        if (verify) {
            BatchSearch.getVerifiedSpans((BatchSearch.BatchResult)candidates, (ProgressHandleWrapper)w, (BatchSearch.VerifiedSpansCallBack)new BatchSearch.VerifiedSpansCallBack(){

                public void groupStarted() {
                }

                public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> hints) throws Exception {
                    LinkedList<PositionBounds> spans = new LinkedList<PositionBounds>();
                    for (ErrorDescription errorDescription : hints) {
                        spans.add(errorDescription.getRange());
                    }
                    refactoringElements.addAll(AbstractApplyHintsRefactoringPlugin.this.refactoring, Utilities.createRefactoringElementImplementation(r.getResolvedFile(), spans, verify));
                    return true;
                }

                public void groupFinished() {
                }

                public void cannotVerifySpan(BatchSearch.Resource r) {
                    refactoringElements.addAll(AbstractApplyHintsRefactoringPlugin.this.refactoring, Utilities.createRefactoringElementImplementation(r.getResolvedFile(), AbstractApplyHintsRefactoringPlugin.prepareSpansFor(r), verify));
                }
            }, problems, (AtomicBoolean)this.cancel);
        } else {
            int[] parts = new int[candidates.getResources().size()];
            int index = 0;
            for (Collection resources : candidates.getResources()) {
                parts[index++] = resources.size();
            }
            ProgressHandleWrapper inner = w.startNextPartWithEmbedding(parts);
            for (Collection it : candidates.getResources()) {
                inner.startNextPart(it.size());
                for (BatchSearch.Resource r : it) {
                    refactoringElements.addAll(this.refactoring, Utilities.createRefactoringElementImplementation(r.getResolvedFile(), AbstractApplyHintsRefactoringPlugin.prepareSpansFor(r), verify));
                    inner.tick();
                }
            }
        }
    }

    private static List<PositionBounds> prepareSpansFor(BatchSearch.Resource r) {
        return Utilities.prepareSpansFor(r.getResolvedFile(), r.getCandidateSpans());
    }

    public void start(int totalWork) {
        this.fireProgressListenerStart(-1, totalWork);
        this.lastWorkDone = 0;
    }

    public void progress(int currentWorkDone) {
        while (this.lastWorkDone < currentWorkDone) {
            this.fireProgressListenerStep(currentWorkDone);
            ++this.lastWorkDone;
        }
    }

    public void progress(String message) {
    }

    public void finish() {
        this.fireProgressListenerStop();
    }

    private static final class DelegatingTransaction
    implements Transaction {
        private final Set<ModificationResult> enabled;
        private final Map<FileObject, Map<JavaFix, ModificationResult>> file2Fixes2Changes;
        private final Map<FileObject, Set<FileObject>> affectedFiles;
        private final Collection<? extends ModificationResult> completeModificationResult;
        private Transaction delegate;

        public DelegatingTransaction(Set<ModificationResult> enabled, Map<FileObject, Map<JavaFix, ModificationResult>> file2Fixes2Changes, Map<FileObject, Set<FileObject>> affectedFiles, Collection<? extends ModificationResult> completeModificationResult) {
            this.enabled = enabled;
            this.file2Fixes2Changes = file2Fixes2Changes;
            this.affectedFiles = affectedFiles;
            this.completeModificationResult = completeModificationResult;
        }

        public synchronized void commit() {
            if (this.delegate == null) {
                HashSet<FileObject> toRecompute = new HashSet<FileObject>();
                for (ModificationResult modificationResult : this.completeModificationResult) {
                    for (FileObject modified : modificationResult.getModifiedFileObjects()) {
                        if (!this.affectedFiles.containsKey(modified)) {
                            assert (modificationResult.getDifferences(modified).isEmpty());
                            continue;
                        }
                        block2: for (FileObject affected : this.affectedFiles.get(modified)) {
                            for (Map.Entry entry : this.file2Fixes2Changes.get(affected).entrySet()) {
                                if (this.enabled.contains(entry.getValue())) continue;
                                toRecompute.add(affected);
                                continue block2;
                            }
                        }
                    }
                }
                HashMap toRun = new HashMap();
                for (FileObject r : toRecompute) {
                    for (ModificationResult modificationResult : this.completeModificationResult) {
                        List diffs = modificationResult.getDifferences(r);
                        if (diffs == null) continue;
                        for (ModificationResult.Difference difference : diffs) {
                            difference.exclude(true);
                        }
                    }
                    for (Map.Entry entry : this.file2Fixes2Changes.get(r).entrySet()) {
                        if (!this.enabled.contains(entry.getValue())) continue;
                        ArrayList fixes2Run = (ArrayList)toRun.get(r);
                        if (fixes2Run == null) {
                            fixes2Run = new ArrayList();
                            toRun.put(r, fixes2Run);
                        }
                        fixes2Run.add(entry.getKey());
                    }
                }
                ArrayList<? extends ModificationResult> arrayList = new ArrayList<ModificationResult>(this.completeModificationResult);
                arrayList.addAll(BatchUtilities.applyFixes(toRun));
                this.delegate = JavaRefactoringPlugin.createTransaction(new LinkedList<ModificationResult>(arrayList));
            }
            this.delegate.commit();
        }

        public synchronized void rollback() {
            this.delegate.rollback();
        }
    }

    private static final class ModificationResultElement
    extends SimpleRefactoringElementImplementation {
        private PositionBounds bounds;
        private String displayText;
        private FileObject parentFile;
        private ModificationResult modification;
        private WeakReference<String> newFileContent;
        private final Set<ModificationResult> enabledResults;

        private ModificationResultElement(FileObject parentFile, JavaFix jf, ModificationResult modification, Set<ModificationResult> enabledResults) {
            PositionRef s = ((ModificationResult.Difference)modification.getDifferences(parentFile).iterator().next()).getStartPosition();
            this.bounds = new PositionBounds(s, s);
            this.displayText = jf.toEditorFix().getText();
            this.parentFile = parentFile;
            this.modification = modification;
            this.enabledResults = enabledResults;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                this.enabledResults.add(this.modification);
            } else {
                this.enabledResults.remove(this.modification);
            }
            super.setEnabled(enabled);
        }

        public boolean isEnabled() {
            return this.enabledResults.contains(this.modification);
        }

        public PositionBounds getPosition() {
            return this.bounds;
        }

        public String getText() {
            return this.displayText;
        }

        public void performChange() {
        }

        public FileObject getParentFile() {
            return this.parentFile;
        }

        protected String getNewFileContent() {
            String result;
            String string = result = this.newFileContent != null ? (String)this.newFileContent.get() : null;
            if (result != null) {
                return result;
            }
            try {
                result = this.modification.getResultingSource(this.parentFile);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            this.newFileContent = new WeakReference<String>(result);
            return result;
        }
    }
}

