/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;

public class CheckBoxWidget
extends ButtonWidget {
    public static final String ACTION_COMMAND_SELECTED = "toggle-button-selected";
    public static final String ACTION_COMMAND_DESELECTED = "toggle-button-deselected";

    public CheckBoxWidget(Scene scene, String text) {
        super(scene, null, text);
        this.setImage(new UncheckedImageWidget(scene, 8));
        this.setSelectedImage((Object)new CheckedImageWidget(scene, 8));
        this.setBorder(BorderFactory.createEmptyBorder((int)1));
    }

    @Override
    public void performAction() {
        this.setSelected(!this.isSelected());
        super.performAction();
    }

    @Override
    public String getActionCommand() {
        return this.isSelected() ? ACTION_COMMAND_SELECTED : ACTION_COMMAND_DESELECTED;
    }

    @Override
    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (previousState.isFocused() != state.isFocused()) {
            this.setBorder(state.isFocused() ? BorderFactory.createDashedBorder((Color)BORDER_COLOR, (int)2, (int)2, (boolean)true) : BorderFactory.createEmptyBorder((int)1));
        }
        super.notifyStateChanged(previousState, state);
    }

    private static class CheckedImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public CheckedImageWidget(Scene scene, int size) {
            super(scene, Color.LIGHT_GRAY, size, size);
            this.setBackground(Color.GRAY);
            this.setBorder(BorderFactory.createLineBorder((int)1, (Color)Color.GRAY));
            this.setOpaque(true);
        }

        @Override
        protected Shape createImage(int width, int height) {
            return new Rectangle2D.Double(0.0, 0.0, width - 2, height - 2);
        }
    }

    private static class UncheckedImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public UncheckedImageWidget(Scene scene, int size) {
            super(scene, Color.LIGHT_GRAY, size, size);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder((int)1, (Color)Color.GRAY));
            this.setOpaque(true);
        }

        @Override
        protected Shape createImage(int width, int height) {
            return new Rectangle2D.Double(0.0, 0.0, width - 2, height - 2);
        }
    }
}

