/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractAction;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.AddWsOperationHelper;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddOperationAction
extends AbstractAction
implements AddOperationCookie {
    private ProjectService service;
    private DataObject dataObject;

    public AddOperationAction(ProjectService projectService, FileObject fileObject) {
        super(AddOperationAction.getName());
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/websvc/design/view/resources/operation.png", (boolean)false));
        this.putValue("ShortDescription", NbBundle.getMessage(AddOperationAction.class, (String)"Hint_AddOperation"));
        this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AddOperationAction.class, (String)"LBL_AddOperation_mnem_pos")));
        this.service = projectService;
        try {
            this.dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public static String getMainClassName(FileObject fileObject) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                if (typeElement != null) {
                    stringArray[0] = typeElement.getQualifiedName().toString();
                }
            }
        }, true);
        return stringArray[0];
    }

    private static String getName() {
        return NbBundle.getMessage(AddOperationAction.class, (String)"LBL_AddOperation");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.addJavaMethod();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void saveImplementationClass() throws IOException {
        SaveCookie saveCookie;
        if (this.dataObject.isModified() && (saveCookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class)) != null) {
            saveCookie.save();
        }
    }

    private void addJavaMethod() throws IOException {
        AddWsOperationHelper addWsOperationHelper = new AddWsOperationHelper(AddOperationAction.getName());
        String string = AddOperationAction.getMainClassName(this.dataObject.getPrimaryFile());
        if (string != null) {
            addWsOperationHelper.addMethod(this.dataObject.getPrimaryFile(), string);
            this.saveImplementationClass();
        }
    }

    public void addOperation() {
        this.actionPerformed(null);
    }

    public boolean isEnabledInEditor(Lookup lookup) {
        return this.service != null && this.service.getWsdlUrl() == null;
    }
}

