/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.loader;

import java.io.IOException;
import org.netbeans.api.java.loaders.JavaDataSupport;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.netbeans.modules.websvc.design.loader.JaxWsDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public final class JaxWsDataLoader
extends MultiFileLoader {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    public static final String JAXWS_MIME_TYPE = "text/x-jaxws";
    public static final String JAVA_EXTENSION = "java";
    private static final String PACKAGE_INFO = "package-info";
    static final long serialVersionUID = -6286836352608877232L;

    public JaxWsDataLoader() {
        super("org.netbeans.modules.websvc.design.loader.JaxWsDataObject");
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(JaxWsDataLoader.class, (String)"PROP_JaxWsLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        if (fileObject.getExt().equals(JAVA_EXTENSION)) {
            return new JaxWsDataObject(fileObject, this);
        }
        return null;
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (fileObject.getAttribute("template") != null && fileObject.getAttribute("javax.script.ScriptEngine") != null) {
            return null;
        }
        if (fileObject.getExt().equals(JAVA_EXTENSION) && Utils.isService(fileObject)) {
            return fileObject;
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        if (JAVA_EXTENSION.equals(fileObject.getExt())) {
            return JavaDataSupport.createJavaFileEntry((MultiDataObject)multiDataObject, (FileObject)fileObject);
        }
        return new FileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        ErrorManager.getDefault().log("Subclass of JavaDataLoader (" + ((Object)((Object)this)).getClass().getName() + ") has secondary entries but does not override createSecondaryEntries (MultidataObject, FileObject) method.");
        return new FileEntry.Numb(multiDataObject, fileObject);
    }
}

