/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import com.sun.javadoc.Doc;
import com.sun.javadoc.Tag;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.design.javamodel.ConfigProjectService;
import org.netbeans.modules.websvc.design.javamodel.FaultModel;
import org.netbeans.modules.websvc.design.javamodel.JavadocModel;
import org.netbeans.modules.websvc.design.javamodel.LightProjectService;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.javamodel.ResultModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class Utils {
    public static boolean isEqualTo(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static ProjectService getProjectService(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        String string = Utils.getImplClass(fileObject);
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel == null) {
            JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)fileObject);
            if (jAXWSLightSupport == null) {
                return null;
            }
            List list = jAXWSLightSupport.getServices();
            for (JaxWsService jaxWsService : list) {
                String string2 = jaxWsService.getImplementationClass();
                if (!string.equals(string2)) continue;
                return new LightProjectService(jAXWSLightSupport, jaxWsService, dataObject);
            }
            return null;
        }
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        Service service = jaxWsModel.findServiceByImplementationClass(string);
        return new ConfigProjectService(jAXWSSupport, service, dataObject);
    }

    public static boolean isService(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel == null) {
            JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)fileObject);
            if (jAXWSLightSupport == null) {
                return false;
            }
            List list = jAXWSLightSupport.getServices();
            for (JaxWsService jaxWsService : list) {
                String string = jaxWsService.getImplementationClass();
                String string2 = Utils.getImplClass(fileObject);
                if (string2 == null || !string2.equals(string)) continue;
                return jaxWsService.isServiceProvider();
            }
            return false;
        }
        return fileObject.getAttribute("jax-ws-service") != null && fileObject.getAttribute("jax-ws-service-provider") == null;
    }

    private static String getImplClass(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String string = classPath.getResourceName(fileObject, '.', false);
        return string;
    }

    public static Service getService(ProjectService projectService) {
        if (projectService instanceof ConfigProjectService) {
            return ((ConfigProjectService)projectService).getService();
        }
        return null;
    }

    public static ServiceModel populateModel(final FileObject fileObject) {
        final ServiceModel[] serviceModelArray = new ServiceModel[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    ServiceModel serviceModel;
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    serviceModelArray[0] = serviceModel = ServiceModel.getServiceModel();
                    Object object = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    if (object != null) {
                        Object object2;
                        Object object3;
                        ClassPath i;
                        ExecutableElement executableElement;
                        Object object4;
                        Object object5;
                        Object object6;
                        boolean bl;
                        List<? extends AnnotationMirror> list = object.getAnnotationMirrors();
                        AnnotationMirror annotationMirror = null;
                        for (AnnotationMirror annotationMirror2 : list) {
                            Name bl3;
                            Element bl2 = annotationMirror2.getAnnotationType().asElement();
                            if (!(bl2 instanceof TypeElement) || !(bl3 = ((TypeElement)bl2).getQualifiedName()).contentEquals("javax.jws.WebService")) continue;
                            annotationMirror = annotationMirror2;
                            break;
                        }
                        if (annotationMirror == null) {
                            serviceModel.status = 1;
                            return;
                        }
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        for (ExecutableElement n : map.keySet()) {
                            if (n.getSimpleName().contentEquals("serviceName")) {
                                serviceModel.serviceName = (String)((AnnotationValue)map.get(n)).getValue();
                                bl3 = true;
                                continue;
                            }
                            if (n.getSimpleName().contentEquals("name")) {
                                serviceModel.name = (String)((AnnotationValue)map.get(n)).getValue();
                                bl = true;
                                continue;
                            }
                            if (n.getSimpleName().contentEquals("portName")) {
                                serviceModel.portName = (String)((AnnotationValue)map.get(n)).getValue();
                                bl4 = true;
                                continue;
                            }
                            if (n.getSimpleName().contentEquals("targetNamespace")) {
                                serviceModel.targetNamespace = (String)((AnnotationValue)map.get(n)).getValue();
                                bl5 = true;
                                continue;
                            }
                            if (n.getSimpleName().contentEquals("endpointInterface")) {
                                serviceModel.endpointInterface = (String)((AnnotationValue)map.get(n)).getValue();
                                continue;
                            }
                            if (!n.getSimpleName().contentEquals("wsdlLocation")) continue;
                            serviceModel.wsdlLocation = (String)((AnnotationValue)map.get(n)).getValue();
                        }
                        if (!bl) {
                            serviceModel.name = fileObject.getName();
                        }
                        if (!bl4) {
                            serviceModel.portName = serviceModel.getName() + "Port";
                        }
                        if (!bl3) {
                            serviceModel.serviceName = fileObject.getName() + "Service";
                        }
                        if (!bl5) {
                            object6 = object.getQualifiedName().toString();
                            int bl52 = ((String)object6).lastIndexOf(".");
                            object5 = bl52 >= 0 ? ((String)object6).substring(0, bl52) : "";
                            object4 = Utils.getPackageReverseOrder((String)object5);
                            serviceModel.targetNamespace = "http://" + (String)object4 + "/";
                        }
                        object6 = null;
                        if (serviceModel.endpointInterface != null && (object6 = compilationController.getElements().getTypeElement(serviceModel.endpointInterface)) != null) {
                            object = object6;
                        }
                        boolean bl6 = false;
                        object5 = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
                        object4 = new ArrayList();
                        block2: for (Element bl62 : object.getEnclosedElements()) {
                            if (bl62.getKind() != ElementKind.METHOD || !(executableElement = (ExecutableElement)bl62).getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                            i = executableElement.getAnnotationMirrors();
                            if (bl6) {
                                object3 = i.iterator();
                                while (object3.hasNext()) {
                                    object2 = (AnnotationMirror)object3.next();
                                    if (!compilationController.getTypes().isSameType(object5.asType(), object2.getAnnotationType())) continue;
                                    object4.add(executableElement);
                                    continue block2;
                                }
                                continue;
                            }
                            object3 = i.iterator();
                            while (object3.hasNext()) {
                                object2 = (AnnotationMirror)object3.next();
                                if (!compilationController.getTypes().isSameType(object5.asType(), object2.getAnnotationType())) continue;
                                object4.clear();
                                bl6 = true;
                                object4.add(executableElement);
                                break;
                            }
                            if (bl6) continue;
                            object4.add(executableElement);
                        }
                        ArrayList arrayList = new ArrayList();
                        if (object4.size() == 0) {
                            serviceModel.operations = arrayList;
                            serviceModel.status = 2;
                            return;
                        }
                        boolean bl7 = serviceModel.endpointInterface != null;
                        executableElement = null;
                        if (bl7) {
                            String string;
                            Object object7;
                            i = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                            object2 = object3 = i.getRoots();
                            int string2 = ((FileObject[])object2).length;
                            for (int j = 0; j < string2 && (executableElement = (object7 = object2[j]).getFileObject(string = serviceModel.endpointInterface.replace('.', '/') + ".java")) == null; ++j) {
                            }
                            if (executableElement == null) {
                                object2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                                String string3 = "build/generated/wsimport/service/" + serviceModel.endpointInterface.replace('.', '/') + ".java";
                                executableElement = object2.getProjectDirectory().getFileObject(string3);
                                if (executableElement == null) {
                                    Utils.invokeWsImport((Project)object2, serviceModel.getName());
                                    executableElement = object2.getProjectDirectory().getFileObject(string3);
                                }
                            }
                        }
                        for (int j = 0; j < object4.size(); ++j) {
                            object3 = new MethodModel();
                            if (bl7 && executableElement != null) {
                                ((MethodModel)object3).setImplementationClass((FileObject)executableElement);
                            } else {
                                ((MethodModel)object3).setImplementationClass(fileObject);
                            }
                            object2 = ElementHandle.create((Element)((Element)object4.get(j)));
                            ((MethodModel)object3).setMethodHandle((ElementHandle)object2);
                            Utils.populateOperation(compilationController, (ExecutableElement)object4.get(j), (ElementHandle)object2, (MethodModel)object3, serviceModel.getTargetNamespace());
                            arrayList.add(object3);
                        }
                        serviceModel.operations = arrayList;
                    } else {
                        serviceModel.status = 2;
                    }
                }

                public void cancel() {
                }
            };
            try {
                Future future = javaSource.runWhenScanFinished((Task)cancellableTask, true);
                future.get();
                return serviceModelArray[0];
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (CancellationException cancellationException) {
                ErrorManager.getDefault().notify((Throwable)cancellationException);
            }
            catch (ExecutionException executionException) {
                ErrorManager.getDefault().notify((Throwable)executionException);
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify((Throwable)interruptedException);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void populateOperation(CompilationController compilationController, ExecutableElement executableElement, ElementHandle elementHandle, MethodModel methodModel, String string) {
        Object object;
        ArrayList<ParamModel> arrayList;
        List<? extends VariableElement> list;
        TypeElement typeElement = compilationController.getElements().getTypeElement("javax.jws.WebMethod");
        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.jws.Oneway");
        TypeElement typeElement3 = compilationController.getElements().getTypeElement("javax.jws.WebResult");
        List<? extends AnnotationMirror> list2 = executableElement.getAnnotationMirrors();
        ResultModel resultModel = new ResultModel();
        boolean bl = false;
        boolean bl2 = false;
        for (AnnotationMirror object22 : list2) {
            if (compilationController.getTypes().isSameType(typeElement.asType(), object22.getAnnotationType())) {
                list = object22.getElementValues();
                for (ExecutableElement executableElement2 : list.keySet()) {
                    if (executableElement2.getSimpleName().contentEquals("operationName")) {
                        methodModel.operationName = (String)((AnnotationValue)list.get(executableElement2)).getValue();
                        bl = true;
                        continue;
                    }
                    if (!executableElement2.getSimpleName().contentEquals("action")) continue;
                    methodModel.action = (String)((AnnotationValue)list.get(executableElement2)).getValue();
                }
                continue;
            }
            if (compilationController.getTypes().isSameType(typeElement3.asType(), object22.getAnnotationType())) {
                list = object22.getElementValues();
                for (ExecutableElement executableElement3 : list.keySet()) {
                    if (executableElement3.getSimpleName().contentEquals("name")) {
                        resultModel.setName((String)((AnnotationValue)list.get(executableElement3)).getValue());
                        bl2 = true;
                        continue;
                    }
                    if (executableElement3.getSimpleName().contentEquals("partName")) {
                        resultModel.setPartName((String)((AnnotationValue)list.get(executableElement3)).getValue());
                        continue;
                    }
                    if (!executableElement3.getSimpleName().contentEquals("targetNamespace")) continue;
                    resultModel.setTargetNamespace((String)((AnnotationValue)list.get(executableElement3)).getValue());
                }
                continue;
            }
            if (!compilationController.getTypes().isSameType(typeElement2.asType(), object22.getAnnotationType())) continue;
            methodModel.oneWay = true;
        }
        methodModel.javaName = executableElement.getSimpleName().toString();
        if (!bl) {
            methodModel.operationName = methodModel.javaName;
        }
        if (!methodModel.isOneWay()) {
            if (!bl2) {
                resultModel.setName("return");
            }
            resultModel.setResultType(((Object)executableElement.getReturnType()).toString());
        }
        methodModel.setResult(resultModel);
        List<? extends TypeMirror> list3 = executableElement.getThrownTypes();
        ArrayList<FaultModel> arrayList2 = new ArrayList<FaultModel>();
        list = list3.iterator();
        while (list.hasNext()) {
            arrayList = (TypeMirror)list.next();
            FaultModel faultModel = new FaultModel();
            boolean bl3 = false;
            if (arrayList.getKind() == TypeKind.DECLARED) {
                TypeElement typeElement4 = (TypeElement)((DeclaredType)((Object)arrayList)).asElement();
                object = compilationController.getElements().getTypeElement("javax.xml.ws.WebFault");
                List<? extends AnnotationMirror> list4 = typeElement4.getAnnotationMirrors();
                for (AnnotationMirror annotationMirror : list4) {
                    if (!compilationController.getTypes().isSameType(object.asType(), annotationMirror.getAnnotationType())) continue;
                    Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                    for (ExecutableElement executableElement4 : map.keySet()) {
                        if (executableElement4.getSimpleName().contentEquals("name")) {
                            faultModel.setName((String)map.get(executableElement4).getValue());
                            bl3 = true;
                            continue;
                        }
                        if (!executableElement4.getSimpleName().contentEquals("targetNamespace")) continue;
                        faultModel.setTargetNamespace((String)map.get(executableElement4).getValue());
                    }
                }
                faultModel.setFaultType(typeElement4.getQualifiedName().toString());
            } else {
                faultModel.setFaultType(((Object)arrayList).toString());
            }
            if (!bl3) {
                String string2 = faultModel.getFaultType();
                int n = string2.lastIndexOf(".");
                faultModel.setName(n >= 0 ? string2.substring(n + 1) : string2);
            }
            arrayList2.add(faultModel);
        }
        methodModel.setFaults(arrayList2);
        Utils.initJavaDoc(compilationController, executableElement, methodModel);
        list = executableElement.getParameters();
        arrayList = new ArrayList<ParamModel>();
        boolean bl4 = false;
        for (VariableElement variableElement : list) {
            void var16_23;
            object = new ParamModel("arg" + String.valueOf((int)(++var16_23)), variableElement.getSimpleName().toString());
            ((ParamModel)object).setImplementationClass(methodModel.getImplementationClass());
            ((ParamModel)object).setMethodHandle(elementHandle);
            Utils.populateParam(compilationController, variableElement, (ParamModel)object);
            arrayList.add((ParamModel)object);
        }
        methodModel.setParams(arrayList);
        Utils.setSoapRequest(methodModel, string);
        Utils.setSoapResponse(methodModel, string);
    }

    private static void initJavaDoc(CompilationController compilationController, ExecutableElement executableElement, MethodModel methodModel) {
        Doc doc = compilationController.getElementUtilities().javaDocFor((Element)executableElement);
        if (doc != null) {
            JavadocModel javadocModel = new JavadocModel(doc.getRawCommentText());
            Tag[] tagArray2 = doc.tags("@param");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Tag tagArray3 : tagArray2) {
                arrayList.add(tagArray3.text());
            }
            javadocModel.setParamJavadoc(arrayList);
            Tag[] tagArray4 = doc.tags("@return");
            if (tagArray4.length > 0) {
                javadocModel.setReturnJavadoc(tagArray4[0].text());
            }
            Tag[] tagArray5 = doc.tags("@throws");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Tag tag : tagArray5) {
                arrayList2.add(tag.text());
            }
            javadocModel.setThrowsJavadoc(arrayList2);
            Tag[] tagArray = doc.inlineTags();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Tag tag : tagArray) {
                arrayList2.add(tag.text());
            }
            javadocModel.setInlineJavadoc(arrayList3);
            methodModel.setJavadoc(javadocModel);
        }
    }

    private static void populateParam(CompilationController compilationController, VariableElement variableElement, ParamModel paramModel) {
        paramModel.setParamType(((Object)variableElement.asType()).toString());
        TypeElement typeElement = compilationController.getElements().getTypeElement("javax.jws.WebParam");
        List<? extends AnnotationMirror> list = variableElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : list) {
            if (!compilationController.getTypes().isSameType(typeElement.asType(), annotationMirror.getAnnotationType())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (executableElement.getSimpleName().contentEquals("name")) {
                    paramModel.name = (String)map.get(executableElement).getValue();
                    continue;
                }
                if (executableElement.getSimpleName().contentEquals("partName")) {
                    paramModel.setPartName((String)map.get(executableElement).getValue());
                    continue;
                }
                if (executableElement.getSimpleName().contentEquals("targetNamespace")) {
                    paramModel.setTargetNamespace((String)map.get(executableElement).getValue());
                    continue;
                }
                if (!executableElement.getSimpleName().contentEquals("mode")) continue;
                paramModel.setMode(WebParam.Mode.valueOf((String)map.get(executableElement).getValue().toString()));
            }
        }
    }

    private static void setSoapRequest(MethodModel methodModel, String string) {
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            Logger.getLogger(Utils.class.getName()).log(Level.FINE, NbBundle.getMessage(Utils.class, (String)"MSG_SAAJ_PROBLEM"), sOAPException);
        }
        if (messageFactory != null) {
            try {
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
                String string2 = methodModel.getAction();
                mimeHeaders.addHeader("SOAPAction", string2 == null ? "\"\"" : string2);
                SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                String string3 = sOAPEnvelope.getPrefix();
                if (!"soap".equals(string3)) {
                    sOAPEnvelope.removeAttribute("xmlns:" + string3);
                    sOAPEnvelope.setPrefix("soap");
                }
                SOAPBody sOAPBody = sOAPEnvelope.getBody();
                sOAPBody.setPrefix("soap");
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                sOAPEnvelope.removeChild((Node)sOAPHeader);
                javax.xml.soap.Name name = sOAPEnvelope.createName(methodModel.getOperationName());
                SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
                sOAPBodyElement.setPrefix("ns0");
                sOAPBodyElement.addNamespaceDeclaration("ns0", string);
                List<ParamModel> list = methodModel.getParams();
                int n = 0;
                for (ParamModel paramModel : list) {
                    Object object;
                    String string4 = paramModel.getTargetNamespace();
                    javax.xml.soap.Name name2 = null;
                    if (paramModel.getName() == null || paramModel.getName().trim().length() == 0) continue;
                    if (string4 != null && string4.length() > 0) {
                        object = "ns" + String.valueOf(++n);
                        name2 = sOAPEnvelope.createName(paramModel.getName(), (String)object, string4);
                        sOAPBodyElement.addNamespaceDeclaration((String)object, string4);
                    } else {
                        name2 = sOAPEnvelope.createName(paramModel.getName());
                    }
                    object = sOAPBodyElement.addChildElement(name2);
                    String string5 = paramModel.getParamType();
                    if ("javax.xml.namespace.QName".equals(string5)) {
                        object.addNamespaceDeclaration("sampleNs", "http://www.netbeans.org/sampleNamespace");
                        object.addTextNode("sampleNs:sampleQName");
                        continue;
                    }
                    object.addTextNode(Utils.getSampleValue(string5));
                }
                methodModel.setSoapRequest(sOAPMessage);
            }
            catch (SOAPException sOAPException) {
                ErrorManager.getDefault().notify((Throwable)sOAPException);
            }
        }
    }

    private static void setSoapResponse(MethodModel methodModel, String string) {
        if (methodModel.isOneWay()) {
            return;
        }
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            Logger.getLogger(Utils.class.getName()).log(Level.FINE, NbBundle.getMessage(Utils.class, (String)"MSG_SAAJ_PROBLEM"), sOAPException);
        }
        if (messageFactory != null) {
            try {
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
                SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                String string2 = sOAPEnvelope.getPrefix();
                if (!"soap".equals(string2)) {
                    sOAPEnvelope.removeAttribute("xmlns:" + string2);
                    sOAPEnvelope.setPrefix("soap");
                }
                SOAPBody sOAPBody = sOAPEnvelope.getBody();
                sOAPBody.setPrefix("soap");
                SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
                sOAPEnvelope.removeChild((Node)sOAPHeader);
                javax.xml.soap.Name name = sOAPEnvelope.createName(methodModel.getOperationName() + "Response");
                SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(name);
                sOAPBodyElement.setPrefix("ns0");
                sOAPBodyElement.addNamespaceDeclaration("ns0", string);
                ResultModel resultModel = methodModel.getResult();
                String string3 = resultModel.getTargetNamespace();
                javax.xml.soap.Name name2 = null;
                if (string3 != null && string3.length() > 0) {
                    sOAPBodyElement.addNamespaceDeclaration("ns1", string3);
                    name2 = sOAPEnvelope.createName(resultModel.getName(), "ns1", string3);
                } else {
                    name2 = sOAPEnvelope.createName(resultModel.getName());
                }
                String string4 = resultModel.getResultType();
                if ("javax.xml.namespace.QName".equals(string4)) {
                    SOAPElement sOAPElement = sOAPBodyElement.addChildElement(name2);
                    sOAPElement.addNamespaceDeclaration("sampleNs", "http://www.netbeans.org/sampleNamespace");
                    sOAPElement.addTextNode("sampleNs:sampleQName");
                } else if (!"void".equals(string4)) {
                    SOAPElement sOAPElement = sOAPBodyElement.addChildElement(name2);
                    sOAPElement.addTextNode(Utils.getSampleValue(string4));
                }
                methodModel.setSoapResponse(sOAPMessage);
            }
            catch (SOAPException sOAPException) {
                ErrorManager.getDefault().notify((Throwable)sOAPException);
            }
        }
    }

    private static String getSampleValue(String string) {
        if ("java.lang.String".equals(string)) {
            return "sample text";
        }
        if ("int".equals(string) || "java.lang.Integer".equals(string) || "java.math.BigInteger".equals(string)) {
            return "99";
        }
        if ("double".equals(string) || "java.lang.Double".equals(string)) {
            return "999.999";
        }
        if ("float".equals(string) || "java.lang.Float".equals(string) || "java.math.BigDecimal".equals(string)) {
            return "99.99";
        }
        if ("long".equals(string) || "java.lang.Long".equals(string)) {
            return "999";
        }
        if ("boolean".equals(string) || "java.lang.Boolean".equals(string)) {
            return "false";
        }
        if ("char".equals(string) || "java.lang.Char".equals(string) || "short".equals(string) || "java.lang.Short".equals(string)) {
            return "65";
        }
        if ("byte[]".equals(string)) {
            return "73616D706C652074657874";
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(string) || "java.util.Date".equals(string) || "java.util.Calendar".equals(string) || "java.util.GregorianCalendar".equals(string)) {
            return "2007-04-19";
        }
        if ("javax.xml.datatype.Duration".equals(string)) {
            return "P2007Y4M";
        }
        if ("java.net.URI".equals(string) || "java.net.URL".equals(string)) {
            return "http://www.netbeans.org/sampleURI";
        }
        return "...";
    }

    public static void setJavadoc(FileObject fileObject, final MethodModel methodModel, final String string) {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                ExecutableElement executableElement;
                Object object;
                MethodTree methodTree;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                List<? extends Tree> list = classTree.getMembers();
                TypeElement typeElement = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
                if (typeElement == null) {
                    return;
                }
                MethodTree methodTree2 = null;
                for (Tree tree : list) {
                    if (Tree.Kind.METHOD != tree.getKind()) continue;
                    methodTree = (MethodTree)tree;
                    object = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), methodTree);
                    executableElement = (ExecutableElement)workingCopy.getTrees().getElement((TreePath)object);
                    List<? extends AnnotationMirror> list2 = executableElement.getAnnotationMirrors();
                    block1: for (AnnotationMirror annotationMirror : list2) {
                        if (!workingCopy.getTypes().isSameType(typeElement.asType(), annotationMirror.getAnnotationType())) continue;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                        for (ExecutableElement executableElement2 : map.keySet()) {
                            if (!executableElement2.getSimpleName().contentEquals("operationName")) continue;
                            if (!methodModel.getOperationName().equals(map.get(executableElement2).getValue())) break block1;
                            methodTree2 = methodTree;
                            break block1;
                        }
                    }
                    if (methodTree2 != null) break;
                    if (!methodTree.getName().contentEquals(methodModel.getOperationName())) continue;
                    methodTree2 = methodTree;
                    break;
                }
                if (methodTree2 != null) {
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)0, (int)0, (int)0, (String)string);
                    MethodTree methodTree3 = (MethodTree)treeMaker.setLabel((Tree)methodTree2, (CharSequence)methodTree2.getName());
                    methodTree = methodModel.getMethodHandle();
                    object = methodTree.resolve((CompilationInfo)workingCopy);
                    if (object == null) {
                        return;
                    }
                    executableElement = workingCopy.getElementUtilities().javaDocFor((Element)object);
                    if (executableElement != null) {
                        treeMaker.removeComment((Tree)methodTree3, 0, true);
                    }
                    treeMaker.addComment((Tree)methodTree3, comment, true);
                    workingCopy.rewrite((Tree)methodTree2, (Tree)methodTree3);
                }
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runWhenScanFinished((Task)new Task<CompilationController>((CancellableTask)cancellableTask, methodModel){
                final /* synthetic */ CancellableTask val$modificationTask;
                final /* synthetic */ MethodModel val$methodModel;
                {
                    this.val$modificationTask = cancellableTask;
                    this.val$methodModel = methodModel;
                }

                public void run(CompilationController compilationController) throws Exception {
                    javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    ElementHandle elementHandle = this.val$methodModel.getMethodHandle();
                    Element element = elementHandle.resolve((CompilationInfo)compilationController);
                    if (element == null) {
                        return;
                    }
                    Utils.initJavaDoc(compilationController, (ExecutableElement)element, this.val$methodModel);
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public static String getFormatedDocument(SOAPMessage sOAPMessage) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            StreamSource streamSource = new StreamSource(byteArrayInputStream);
            transformer.transform(streamSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void invokeWsImport(final Project project, final String string) {
        Service service;
        JaxWsModel jaxWsModel;
        if (project != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null && (service = jaxWsModel.findServiceByName(string)) != null && service.getWsdlUrl() != null) {
            final FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                ((Boolean)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                    public Boolean run() throws IOException {
                        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
                        Properties properties = WSUtils.identifyWsimport((AntProjectHelper)jAXWSSupport.getAntProjectHelper());
                        ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-service-clean-" + string, "wsimport-service-" + string}, (Properties)properties);
                        executorTask.waitFinished();
                        return Boolean.TRUE;
                    }
                })).booleanValue();
            }
            catch (MutexException mutexException) {
                ErrorManager.getDefault().log(mutexException.getLocalizedMessage());
            }
        }
    }

    public static String getCurrentJavaName(final MethodModel methodModel) {
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)methodModel.getImplementationClass());
        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                ElementHandle elementHandle = methodModel.getMethodHandle();
                Element element = elementHandle.resolve((CompilationInfo)compilationController);
                stringArray[0] = element.getSimpleName().toString();
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runUserActionTask((Task)cancellableTask, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return stringArray[0];
    }

    public static String getAttributeValue(FileObject fileObject, final String string, final String string2) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[]{""};
        if (javaSource != null) {
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    if (typeElement != null) {
                        List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                        block0: for (AnnotationMirror annotationMirror : list) {
                            Object object;
                            Element element = annotationMirror.getAnnotationType().asElement();
                            if (!(element instanceof TypeElement) || !(object = ((TypeElement)element).getQualifiedName()).contentEquals(string)) continue;
                            object = annotationMirror.getElementValues();
                            for (ExecutableElement executableElement : object.keySet()) {
                                String string3;
                                if (!executableElement.getSimpleName().contentEquals(string2) || (string3 = (String)((AnnotationValue)object.get(executableElement)).getValue()) == null) continue;
                                stringArray[0] = URLEncoder.encode(string3, "UTF-8");
                                continue block0;
                            }
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)cancellableTask, true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return stringArray[0];
    }

    private static String getPackageReverseOrder(String string) {
        String[] stringArray = string.split("\\.");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (i < stringArray.length - 1) {
                stringBuffer.append(".");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }
}

