/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProvider;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProviderRegistry;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

class ConfigProjectService
implements ProjectService {
    private static final String BUILD_IMPL_XML_PATH = "nbproject/build-impl.xml";
    private final JAXWSSupport support;
    private final Service service;
    private final DataObject dataObject;

    ConfigProjectService(JAXWSSupport jAXWSSupport, Service service, DataObject dataObject) {
        this.support = jAXWSSupport;
        this.service = service;
        this.dataObject = dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() throws IOException {
        if (this.service == null || this.support == null) {
            return;
        }
        String string = this.service.getName();
        if (string != null) {
            Object object;
            FileObject fileObject = this.support.getLocalWsdlFolderForService(string, false);
            if (fileObject != null) {
                FileObject fileObject2;
                object = null;
                FileObject fileObject3 = fileObject.getParent();
                try {
                    object = fileObject3.lock();
                    fileObject3.delete((FileLock)object);
                }
                finally {
                    if (object != null) {
                        object.releaseLock();
                    }
                }
                FileObject fileObject4 = this.support.getWsdlFolder(false);
                if (fileObject4 != null && (fileObject2 = fileObject4.getFileObject(string)) != null) {
                    try {
                        object = fileObject2.lock();
                        fileObject2.delete((FileLock)object);
                    }
                    finally {
                        if (object != null) {
                            object.releaseLock();
                        }
                    }
                }
                fileObject2 = this.getProject().getProjectDirectory().getFileObject(BUILD_IMPL_XML_PATH);
                try {
                    ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject2, (String[])new String[]{"wsimport-service-clean-" + string}, null);
                    executorTask.waitFinished();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
                }
            }
            this.support.removeService(string);
            object = ((JaxWsModel)this.getProject().getLookup().lookup(JaxWsModel.class)).getJsr109();
            if (object != null && !((Boolean)object).booleanValue()) {
                if (this.service.getWsdlUrl() != null) {
                    string = this.service.getServiceName();
                }
                this.support.removeNonJsr109Entries(string);
            }
        }
    }

    @Override
    public Collection<WSConfiguration> getConfigurations() {
        LinkedList<WSConfiguration> linkedList = new LinkedList<WSConfiguration>();
        for (WSConfigurationProvider wSConfigurationProvider : this.getConfigProviders()) {
            WSConfiguration wSConfiguration = wSConfigurationProvider.getWSConfiguration(this.service, this.dataObject.getPrimaryFile());
            if (wSConfiguration == null) continue;
            linkedList.add(wSConfiguration);
        }
        return linkedList;
    }

    @Override
    public String getWsdlUrl() {
        return this.service.getWsdlUrl();
    }

    @Override
    public String getImplementationClass() {
        return this.service.getImplementationClass();
    }

    @Override
    public String getLocalWsdlFile() {
        return this.service.getLocalWsdlFile();
    }

    Service getService() {
        return this.service;
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.dataObject.getPrimaryFile());
    }

    private Set<WSConfigurationProvider> getConfigProviders() {
        return WSConfigurationProviderRegistry.getDefault().getWSConfigurationProviders();
    }
}

