/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.Callable;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.ContextAction;
import org.mozilla.nb.javascript.ContextFactory;
import org.mozilla.nb.javascript.IdFunctionObject;
import org.mozilla.nb.javascript.IdScriptableObject;
import org.mozilla.nb.javascript.JavaScriptException;
import org.mozilla.nb.javascript.NativeFunction;
import org.mozilla.nb.javascript.NativeIterator;
import org.mozilla.nb.javascript.RhinoException;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;
import org.mozilla.nb.javascript.Undefined;

public final class NativeGenerator
extends IdScriptableObject {
    private static final long serialVersionUID = 1645892441041347273L;
    private static final Object GENERATOR_TAG = "Generator";
    public static final int GENERATOR_SEND = 0;
    public static final int GENERATOR_THROW = 1;
    public static final int GENERATOR_CLOSE = 2;
    private static final int Id_close = 1;
    private static final int Id_next = 2;
    private static final int Id_send = 3;
    private static final int Id_throw = 4;
    private static final int Id___iterator__ = 5;
    private static final int MAX_PROTOTYPE_ID = 5;
    private NativeFunction function;
    private Object savedState;
    private String lineSource;
    private int lineNumber;
    private boolean firstTime = true;
    private boolean locked;

    static NativeGenerator init(ScriptableObject scriptableObject, boolean bl) {
        NativeGenerator nativeGenerator = new NativeGenerator();
        if (scriptableObject != null) {
            nativeGenerator.setParentScope(scriptableObject);
            nativeGenerator.setPrototype(NativeGenerator.getObjectPrototype(scriptableObject));
        }
        nativeGenerator.activatePrototypeMap(5);
        if (bl) {
            nativeGenerator.sealObject();
        }
        if (scriptableObject != null) {
            scriptableObject.associateValue(GENERATOR_TAG, nativeGenerator);
        }
        return nativeGenerator;
    }

    private NativeGenerator() {
    }

    public NativeGenerator(Scriptable scriptable, NativeFunction nativeFunction, Object object) {
        this.function = nativeFunction;
        this.savedState = object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        this.setParentScope(scriptable2);
        NativeGenerator nativeGenerator = (NativeGenerator)ScriptableObject.getTopScopeValue(scriptable2, GENERATOR_TAG);
        this.setPrototype(nativeGenerator);
    }

    @Override
    public String getClassName() {
        return "Generator";
    }

    public void finalize() throws Throwable {
        if (this.savedState != null) {
            Context context = Context.getCurrentContext();
            ContextFactory contextFactory = context != null ? context.getFactory() : ContextFactory.getGlobal();
            contextFactory.call(new CloseGeneratorAction(this));
        }
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "close";
                break;
            }
            case 2: {
                n2 = 1;
                string = "next";
                break;
            }
            case 3: {
                n2 = 0;
                string = "send";
                break;
            }
            case 4: {
                n2 = 0;
                string = "throw";
                break;
            }
            case 5: {
                n2 = 1;
                string = "__iterator__";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(GENERATOR_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(GENERATOR_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        if (!(scriptable2 instanceof NativeGenerator)) {
            throw NativeGenerator.incompatibleCallError(idFunctionObject);
        }
        NativeGenerator nativeGenerator = (NativeGenerator)scriptable2;
        switch (n) {
            case 1: {
                return nativeGenerator.resume(context, scriptable, 2, new GeneratorClosedException());
            }
            case 2: {
                nativeGenerator.firstTime = false;
                return nativeGenerator.resume(context, scriptable, 0, Undefined.instance);
            }
            case 3: {
                Object object;
                Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
                if (nativeGenerator.firstTime && !object.equals(Undefined.instance)) {
                    throw ScriptRuntime.typeError0("msg.send.newborn");
                }
                return nativeGenerator.resume(context, scriptable, 0, object);
            }
            case 4: {
                return nativeGenerator.resume(context, scriptable, 1, objectArray.length > 0 ? objectArray[0] : Undefined.instance);
            }
            case 5: {
                return scriptable2;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resume(Context context, Scriptable scriptable, int n, Object object) {
        if (this.savedState == null) {
            if (n == 2) {
                return Undefined.instance;
            }
            Object object2 = n == 1 ? object : NativeIterator.getStopIterationObject(scriptable);
            throw new JavaScriptException(object2, this.lineSource, this.lineNumber);
        }
        try {
            Object object3 = this;
            synchronized (object3) {
                if (this.locked) {
                    throw ScriptRuntime.typeError0("msg.already.exec.gen");
                }
                this.locked = true;
            }
            object3 = this.function.resumeGenerator(context, scriptable, n, this.savedState, object);
            return object3;
        }
        catch (GeneratorClosedException generatorClosedException) {
            Object object4 = Undefined.instance;
            return object4;
        }
        catch (RhinoException rhinoException) {
            this.lineNumber = rhinoException.lineNumber();
            this.lineSource = rhinoException.lineSource();
            this.savedState = null;
            throw rhinoException;
        }
        finally {
            NativeGenerator nativeGenerator = this;
            synchronized (nativeGenerator) {
                this.locked = false;
            }
            if (n == 2) {
                this.savedState = null;
            }
        }
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block11: {
            n = 0;
            String string2 = null;
            int n2 = string.length();
            if (n2 == 4) {
                char c = string.charAt(0);
                if (c == 'n') {
                    string2 = "next";
                    n = 2;
                } else if (c == 's') {
                    string2 = "send";
                    n = 3;
                }
            } else if (n2 == 5) {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "close";
                    n = 1;
                } else if (c == 't') {
                    string2 = "throw";
                    n = 4;
                }
            } else if (n2 == 12) {
                string2 = "__iterator__";
                n = 5;
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block11;
            n = 0;
        }
        return n;
    }

    private static class CloseGeneratorAction
    implements ContextAction {
        private NativeGenerator generator;

        CloseGeneratorAction(NativeGenerator nativeGenerator) {
            this.generator = nativeGenerator;
        }

        @Override
        public Object run(Context context) {
            Scriptable scriptable = ScriptableObject.getTopLevelScope(this.generator);
            Callable callable = new Callable(){

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    return ((NativeGenerator)scriptable2).resume(context, scriptable, 2, new GeneratorClosedException());
                }
            };
            return ScriptRuntime.doTopCall(callable, context, scriptable, this.generator, null);
        }
    }

    public static class GeneratorClosedException
    extends RuntimeException {
        private static final long serialVersionUID = 2561315658662379681L;
    }
}

