/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.update.RevertModificationsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class RevertModifications
implements PropertyChangeListener {
    private RevertModificationsPanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private RevertType[] types;

    public RevertModifications(RepositoryFile repositoryFile) {
        this(repositoryFile, null);
    }

    public RevertModifications(RepositoryFile repositoryFile, String defaultRevision) {
        OneCommitRevertType ocrt = new OneCommitRevertType(repositoryFile, this.getPanel().oneCommitRadioButton);
        LocalRevertType lrt = new LocalRevertType(this.getPanel().localChangesRadioButton);
        this.types = new RevertType[]{lrt, ocrt, new MoreCommitsRevertType(repositoryFile, this.getPanel().moreCommitsRadioButton)};
        this.okButton = new JButton(NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Revert"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Revert"));
        this.cancelButton = new JButton(NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Cancel"));
        if (defaultRevision != null) {
            this.panel.oneCommitRadioButton.setSelected(true);
            this.panel.oneRevisionTextField.setText(defaultRevision);
            ocrt.actionPerformed(null);
        } else {
            this.panel.localChangesRadioButton.setSelected(true);
            lrt.actionPerformed(null);
        }
        this.initInputVerifiers();
    }

    private void initInputVerifiers() {
        InputVerifier iv = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JTextComponent comp;
                if ((input == ((RevertModifications)RevertModifications.this).panel.startRevisionTextField || input == ((RevertModifications)RevertModifications.this).panel.endRevisionTextField || input == ((RevertModifications)RevertModifications.this).panel.oneRevisionTextField) && (comp = (JTextComponent)input).getText().trim().isEmpty()) {
                    comp.setText(SVNRevision.HEAD.toString());
                }
                return true;
            }
        };
        this.panel.startRevisionTextField.setInputVerifier(iv);
        this.panel.endRevisionTextField.setInputVerifier(iv);
        this.panel.oneRevisionTextField.setInputVerifier(iv);
    }

    private RevertModificationsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new RevertModificationsPanel();
        }
        return this.panel;
    }

    public RevisionInterval getRevisionInterval() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return this.types[i].getRevisionInterval();
        }
        return null;
    }

    public boolean revertNewFiles() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return this.types[i].revertNewFiles();
        }
        return false;
    }

    public boolean revertRecursively() {
        for (RevertType type : this.types) {
            if (!type.isSelected()) continue;
            return type.revertRecursively();
        }
        return false;
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertDialog"));
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertDialog"));
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid") && this.okButton != null) {
            boolean valid = (Boolean)evt.getNewValue();
            this.okButton.setEnabled(valid);
        }
    }

    protected void setMoreCommitsFieldsEnabled(boolean b) {
        this.getPanel().startRevisionTextField.setEnabled(b);
        this.getPanel().endRevisionTextField.setEnabled(b);
        this.getPanel().startSearchButton.setEnabled(b);
        this.getPanel().endSearchButton.setEnabled(b);
    }

    protected void setOneCommitFieldsEnabled(boolean b) {
        this.getPanel().oneRevisionSearchButton.setEnabled(b);
        this.getPanel().oneRevisionTextField.setEnabled(b);
    }

    protected final void setLocalModificationsFieldsEnabled(boolean b) {
        this.getPanel().cbRecursiveRevert.setEnabled(b);
        this.getPanel().revertNewFilesCheckBox.setEnabled(b);
    }

    private class LocalRevertType
    extends RevertType {
        LocalRevertType(JRadioButton button) {
            super(button);
        }

        @Override
        RevisionInterval getRevisionInterval() {
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RevertModifications.this.setLocalModificationsFieldsEnabled(true);
            RevertModifications.this.setOneCommitFieldsEnabled(false);
            RevertModifications.this.setMoreCommitsFieldsEnabled(false);
        }

        @Override
        boolean revertRecursively() {
            return ((RevertModifications)RevertModifications.this).getPanel().cbRecursiveRevert.isSelected();
        }

        @Override
        boolean revertNewFiles() {
            return ((RevertModifications)RevertModifications.this).panel.revertNewFilesCheckBox.isSelected();
        }
    }

    private class MoreCommitsRevertType
    extends RevertType {
        private RepositoryPaths endPath;
        private RepositoryPaths startPath;

        MoreCommitsRevertType(RepositoryFile repositoryFile, JRadioButton button) {
            super(button);
            this.startPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().startRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().startSearchButton);
            this.startPath.addPropertyChangeListener(RevertModifications.this);
            this.endPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().endRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().endSearchButton);
            this.endPath.addPropertyChangeListener(RevertModifications.this);
        }

        @Override
        RevisionInterval getRevisionInterval() {
            SVNRevision revision1 = this.getRevision(this.startPath);
            SVNRevision revision2 = this.getRevision(this.endPath);
            if (revision1 == null || revision2 == null) {
                return null;
            }
            return this.getResortedRevisionInterval(revision1, revision2);
        }

        @Override
        void validateUserInput() {
            if (!this.validateRevision(this.getRevision(this.startPath))) {
                return;
            }
            if (!this.validateRevision(this.getRevision(this.endPath))) {
                return;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RevertModifications.this.setLocalModificationsFieldsEnabled(false);
            RevertModifications.this.setMoreCommitsFieldsEnabled(true);
            RevertModifications.this.setOneCommitFieldsEnabled(false);
            this.validateUserInput();
        }

        private RevisionInterval getResortedRevisionInterval(SVNRevision revision1, SVNRevision revision2) {
            Long r2;
            Long r1;
            RevisionInterval ret = revision1.equals((Object)SVNRevision.HEAD) && revision1.equals((Object)SVNRevision.HEAD) ? new RevisionInterval(revision1, revision2) : (revision1.equals((Object)SVNRevision.HEAD) ? new RevisionInterval(revision2, revision1) : (revision2.equals((Object)SVNRevision.HEAD) ? new RevisionInterval(revision1, revision2) : ((r1 = Long.valueOf(Long.parseLong(revision1.toString()))).compareTo(r2 = Long.valueOf(Long.parseLong(revision2.toString()))) < 0 ? new RevisionInterval(revision1, revision2) : new RevisionInterval(revision2, revision1))));
            return ret;
        }
    }

    private class OneCommitRevertType
    extends RevertType {
        private RepositoryPaths oneRevisionPath;

        OneCommitRevertType(RepositoryFile repositoryFile, JRadioButton button) {
            super(button);
            this.oneRevisionPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().oneRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().oneRevisionSearchButton);
            this.oneRevisionPath.addPropertyChangeListener(RevertModifications.this);
        }

        @Override
        RevisionInterval getRevisionInterval() {
            SVNRevision revision = this.getRevision(this.oneRevisionPath);
            RevisionInterval ret = new RevisionInterval(revision);
            return ret;
        }

        @Override
        void validateUserInput() {
            this.validateRevision(this.getRevision(this.oneRevisionPath));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RevertModifications.this.setLocalModificationsFieldsEnabled(false);
            RevertModifications.this.setOneCommitFieldsEnabled(true);
            RevertModifications.this.setMoreCommitsFieldsEnabled(false);
            this.validateUserInput();
        }
    }

    private abstract class RevertType
    implements ActionListener,
    DocumentListener {
        private JRadioButton button;

        RevertType(JRadioButton button) {
            this.button = button;
            button.addActionListener(this);
        }

        boolean isSelected() {
            return this.button.isSelected();
        }

        boolean revertNewFiles() {
            return false;
        }

        boolean revertRecursively() {
            return true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validateUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validateUserInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validateUserInput();
        }

        void validateUserInput() {
        }

        RevisionInterval getRevisionInterval() {
            return null;
        }

        protected SVNRevision getRevision(RepositoryPaths path) {
            try {
                return path.getRepositoryFiles()[0].getRevision();
            }
            catch (NumberFormatException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
            catch (MalformedURLException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
            return null;
        }

        protected boolean validateRevision(SVNRevision revision) {
            boolean valid = revision == null || revision.equals((Object)SVNRevision.HEAD) || revision.getKind() == 1;
            RevertModifications.this.okButton.setEnabled(valid);
            return valid;
        }
    }

    public static class RevisionInterval {
        SVNRevision startRevision;
        SVNRevision endRevision;

        public RevisionInterval(SVNRevision revision) {
            this.startRevision = revision;
            this.endRevision = revision;
        }

        public RevisionInterval(SVNRevision startRevision, SVNRevision endRevision) {
            this.startRevision = startRevision;
            this.endRevision = endRevision;
        }
    }
}

