/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.blame;

import java.io.File;
import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.blame.AnnotateLine;
import org.netbeans.modules.subversion.ui.blame.AnnotationBar;
import org.netbeans.modules.subversion.ui.blame.AnnotationBarManager;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BlameAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        if (this.visible(activatedNodes)) {
            return "CTL_MenuItem_HideAnnotations";
        }
        return "CTL_MenuItem_ShowAnnotations";
    }

    @Override
    public boolean enable(Node[] nodes) {
        return super.enable(nodes) && this.activatedEditorCookie(nodes) != null;
    }

    protected String iconResource() {
        return "org/netbeans/modules/subversion/resources/icons/annotate.png";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 20472;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (this.visible(nodes)) {
            JEditorPane pane = this.activatedEditorPane(nodes);
            AnnotationBarManager.hideAnnotationBar(pane);
        } else {
            EditorCookie ec = this.activatedEditorCookie(nodes);
            if (ec == null) {
                return;
            }
            File file = this.activatedFile(nodes);
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null) {
                ec.open();
                panes = ec.getOpenedPanes();
            }
            if (panes == null) {
                return;
            }
            JEditorPane currentPane = panes[0];
            BlameAction.showAnnotations(currentPane, file, null);
        }
    }

    public static void showAnnotations(JEditorPane currentPane, File file, SVNRevision revision) {
        SVNUrl repository;
        AnnotationBar ab = AnnotationBarManager.showAnnotationBar(currentPane);
        ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationSubstitute"));
        try {
            repository = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        if (revision == null) {
            ISVNStatus status = Subversion.getInstance().getStatusCache().getStatus(file).getEntry(file);
            if (status == null || status.getRevision() == null) {
                return;
            }
            ab.setSVNClienListener(new SVNClientListener(status.getRevision().getNumber(), repository, file, ab));
        }
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, currentPane);
        tc.requestActive();
        BlameAction.computeAnnotations(repository, file, ab, revision);
    }

    private static void computeAnnotations(SVNUrl repository, final File file, final AnnotationBar ab, final SVNRevision revision) {
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                BlameAction.computeAnnotations(file, this, ab, revision);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(BlameAction.class, (String)"MSG_Annotation_Progress"));
    }

    private static void computeAnnotations(File file, SvnProgressSupport progress, AnnotationBar ab, SVNRevision revision) {
        ISVNLogMessage[] logs;
        ISVNAnnotations annotations;
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(file, progress);
        }
        catch (SVNClientException ex) {
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        if (revision == null) {
            revision = SVNRevision.BASE;
        } else {
            ab.setReferencedFile(file);
        }
        try {
            annotations = client.annotate(file, (SVNRevision)new SVNRevision.Number(1L), revision);
        }
        catch (SVNClientException e) {
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            SvnClientExceptionHandler.notifyException((Exception)((Object)e), true, true);
            return;
        }
        if (progress.isCanceled()) {
            ab.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        AnnotateLine[] lines = BlameAction.toAnnotateLines(annotations);
        ab.annotationLines(file, Arrays.asList(lines));
        try {
            logs = client.getLogMessages(file, revision, (SVNRevision)new SVNRevision.Number(1L), revision, false, false, 0L, false);
        }
        catch (SVNClientException e) {
            progress.annotate(e);
            return;
        }
        if (progress.isCanceled()) {
            return;
        }
        BlameAction.fillCommitMessages(lines, logs);
    }

    private static void fillCommitMessages(AnnotateLine[] annotations, ISVNLogMessage[] logs) {
        long lowestRevisionNumber = Long.MAX_VALUE;
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation = annotations[i];
            for (int j = 0; j < logs.length; ++j) {
                ISVNLogMessage log = logs[j];
                if (log.getRevision().getNumber() < lowestRevisionNumber) {
                    lowestRevisionNumber = log.getRevision().getNumber();
                }
                if (!annotation.getRevision().equals(log.getRevision().toString())) continue;
                annotation.setDate(log.getDate());
                annotation.setCommitMessage(log.getMessage());
            }
        }
        String lowestRev = Long.toString(lowestRevisionNumber);
        for (int i = 0; i < annotations.length; ++i) {
            AnnotateLine annotation;
            annotation.setCanBeRolledBack(!(annotation = annotations[i]).getRevision().equals(lowestRev));
        }
    }

    private static AnnotateLine[] toAnnotateLines(ISVNAnnotations annotations) {
        AnnotateLine[] lines = new AnnotateLine[annotations.numberOfLines()];
        int n = annotations.numberOfLines();
        for (int i = 0; i < n; ++i) {
            lines[i] = new AnnotateLine();
            lines[i].setAuthor(annotations.getAuthor(i));
            lines[i].setContent(annotations.getLine(i));
            lines[i].setLineNum(i + 1);
            lines[i].setRevision(Long.toString(annotations.getRevision(i)));
            lines[i].setDate(annotations.getChanged(i));
        }
        return lines;
    }

    public boolean visible(Node[] nodes) {
        JEditorPane currentPane = this.activatedEditorPane(nodes);
        return AnnotationBarManager.annotationBarVisible(currentPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodes) {
        EditorCookie ec = this.activatedEditorCookie(nodes);
        if (ec != null && SwingUtilities.isEventDispatchThread()) {
            return NbDocument.findRecentEditorPane((EditorCookie)ec);
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodes) {
        if (nodes == null) {
            nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodes.length == 1) {
            Node node = nodes[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodes) {
        Node node;
        DataObject dobj;
        if (nodes.length == 1 && (dobj = (DataObject)(node = nodes[0]).getCookie(DataObject.class)) != null) {
            FileObject fo = dobj.getPrimaryFile();
            return FileUtil.toFile((FileObject)fo);
        }
        return null;
    }

    private static class SVNClientListener
    implements ISVNNotifyListener {
        private final SVNUrl repository;
        private final File file;
        private final AnnotationBar ab;
        private long revision = -1L;
        private File notifiedFile = null;

        public SVNClientListener(long revision, SVNUrl repository, File file, AnnotationBar ab) {
            this.revision = revision;
            this.repository = repository;
            this.ab = ab;
            this.file = file;
        }

        public void setCommand(int arg0) {
        }

        public void logCommandLine(String arg0) {
        }

        public void logMessage(String arg0) {
        }

        public void logError(String arg0) {
        }

        public void logRevision(long newRevision, String path) {
            if (this.notifiedFile == null) {
                return;
            }
            if (this.notifiedFile.getAbsolutePath().equals(this.file.getAbsolutePath()) && this.revision != newRevision) {
                BlameAction.computeAnnotations(this.repository, this.file, this.ab, SVNRevision.BASE);
                this.revision = newRevision;
                this.notifiedFile = null;
            }
        }

        public void logCompleted(String arg0) {
        }

        public void onNotify(File file, SVNNodeKind nodeKind) {
            this.notifiedFile = file;
        }
    }
}

