/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.File;
import java.util.Date;
import org.netbeans.modules.subversion.client.cli.commands.StatusCommand;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CLIStatus
implements ISVNStatus {
    private StatusCommand.Status status;
    private ISVNInfo info;

    CLIStatus(StatusCommand.Status status, ISVNInfo info) {
        this.status = status;
        this.info = info;
    }

    CLIStatus(StatusCommand.Status status, String path) {
        this.status = status;
        this.info = new UnversionedInfo(path);
    }

    public SVNUrl getUrl() {
        return this.info.getUrl();
    }

    public String getUrlString() {
        return this.info.getUrlString();
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.info.getLastChangedRevision();
    }

    public Date getLastChangedDate() {
        return this.info.getLastChangedDate();
    }

    public String getLastCommitAuthor() {
        return this.info.getLastCommitAuthor();
    }

    public SVNStatusKind getTextStatus() {
        return this.status.getWcStatus();
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return this.status.getRepoStatus();
    }

    public SVNStatusKind getPropStatus() {
        return this.status.getWcPropsStatus();
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return this.status.getRepoPropsStatus();
    }

    public SVNRevision.Number getRevision() {
        return this.info.getRevision();
    }

    public String getPath() {
        return this.info != null ? this.info.getFile().getAbsolutePath() : this.status.getPath();
    }

    public File getFile() {
        return this.info.getFile();
    }

    public SVNNodeKind getNodeKind() {
        return this.info.getNodeKind();
    }

    public boolean isCopied() {
        return this.status.isWcCopied();
    }

    public boolean isWcLocked() {
        return this.status.isWcLocked();
    }

    public boolean isSwitched() {
        return this.status.isWcSwitched();
    }

    public SVNUrl getUrlCopiedFrom() {
        return this.info.getCopyUrl();
    }

    public File getConflictNew() {
        return null;
    }

    public File getConflictOld() {
        return null;
    }

    public File getConflictWorking() {
        return null;
    }

    public String getLockOwner() {
        return this.status.getLockOwner();
    }

    public Date getLockCreationDate() {
        return this.status.getLockCreated();
    }

    public String getLockComment() {
        return this.status.getLockComment();
    }

    public boolean hasTreeConflict() {
        return this.status.hasTreeConflicts();
    }

    public SVNConflictDescriptor getConflictDescriptor() {
        return this.status.getConflictDescriptor();
    }

    public boolean isFileExternal() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class UnversionedInfo
    implements ISVNInfo {
        private final File file;

        public UnversionedInfo(String path) {
            this.file = new File(path);
        }

        public File getFile() {
            return this.file;
        }

        public SVNUrl getUrl() {
            return null;
        }

        public String getUrlString() {
            return null;
        }

        public String getUuid() {
            return null;
        }

        public SVNUrl getRepository() {
            return null;
        }

        public SVNScheduleKind getSchedule() {
            return null;
        }

        public SVNNodeKind getNodeKind() {
            return SVNNodeKind.UNKNOWN;
        }

        public String getLastCommitAuthor() {
            return null;
        }

        public SVNRevision.Number getRevision() {
            return null;
        }

        public SVNRevision.Number getLastChangedRevision() {
            return null;
        }

        public Date getLastChangedDate() {
            return null;
        }

        public Date getLastDateTextUpdate() {
            return null;
        }

        public Date getLastDatePropsUpdate() {
            return null;
        }

        public boolean isCopied() {
            return false;
        }

        public SVNRevision.Number getCopyRev() {
            return SVNRevision.INVALID_REVISION;
        }

        public SVNUrl getCopyUrl() {
            return null;
        }

        public String getLockOwner() {
            return null;
        }

        public Date getLockCreationDate() {
            return null;
        }

        public String getLockComment() {
            return null;
        }

        public int getDepth() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

