/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.jdbc.admin.cli.JDBCConnectionPoolManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.connection.pool")
public class CreateJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcConnectionPool.class);
    @Param(name="datasourceClassname", optional=true)
    String datasourceclassname;
    @Param(optional=true, name="resType", acceptableValues="javax.sql.DataSource,javax.sql.XADataSource,javax.sql.ConnectionPoolDataSource,java.sql.Driver")
    String restype;
    @Param(name="steadyPoolSize", optional=true, defaultValue="8")
    String steadypoolsize = "8";
    @Param(name="maxPoolSize", optional=true, defaultValue="32")
    String maxpoolsize = "32";
    @Param(name="maxWait", alias="maxWaitTimeInMillis", optional=true, defaultValue="60000")
    String maxwait = "60000";
    @Param(name="poolResize", alias="poolResizeQuantity", optional=true, defaultValue="2")
    String poolresize = "2";
    @Param(name="idleTimeout", alias="idleTimeoutInSeconds", optional=true, defaultValue="300")
    String idletimeout = "300";
    @Param(name="initSql", optional=true)
    String initsql;
    @Param(name="isolationLevel", alias="transactionIsolationLevel", optional=true)
    String isolationlevel;
    @Param(name="isIsolationGuaranteed", alias="isIsolationLevelGuaranteed", optional=true, defaultValue="true")
    Boolean isisolationguaranteed;
    @Param(name="isConnectValidateReq", alias="isConnectionValidationRequired", optional=true, defaultValue="false")
    Boolean isconnectvalidatereq;
    @Param(name="validationMethod", optional=true, alias="connectionValidationMethod", acceptableValues="auto-commit,meta-data,table,custom-validation", defaultValue="table")
    String validationmethod = "table";
    @Param(name="validationTable", alias="validationTableName", optional=true)
    String validationtable;
    @Param(name="failConnection", alias="failAllConnections", optional=true, defaultValue="false")
    Boolean failconnection;
    @Param(name="allowNonComponentCallers", optional=true, defaultValue="false")
    Boolean allownoncomponentcallers;
    @Param(name="nonTransactionalConnections", optional=true, defaultValue="false")
    Boolean nontransactionalconnections;
    @Param(name="validateAtMostOncePeriod", alias="validateAtmostOncePeriodInSeconds", optional=true, defaultValue="0")
    String validateatmostonceperiod = "0";
    @Param(name="leakTimeout", alias="connectionLeakTimeoutInSeconds", optional=true, defaultValue="0")
    String leaktimeout = "0";
    @Param(name="leakReclaim", alias="connectionLeakReclaim", optional=true, defaultValue="false")
    Boolean leakreclaim;
    @Param(name="creationRetryAttempts", alias="connectionCreationRetryAttempts", optional=true, defaultValue="0")
    String creationretryattempts = "0";
    @Param(name="creationRetryInterval", alias="connectionCreationRetryIntervalInSeconds", optional=true, defaultValue="10")
    String creationretryinterval = "10";
    @Param(name="sqlTraceListeners", optional=true)
    String sqltracelisteners;
    @Param(name="statementTimeout", alias="statementTimeoutInSeconds", optional=true, defaultValue="-1")
    String statementtimeout = "-1";
    @Param(name="statementLeakTimeout", alias="statementLeakTimeoutInSeconds", optional=true, defaultValue="0")
    String statementLeaktimeout = "0";
    @Param(name="statementLeakReclaim", alias="statementLeakReclaim", optional=true, defaultValue="false")
    Boolean statementLeakreclaim;
    @Param(name="lazyConnectionEnlistment", optional=true, defaultValue="false")
    Boolean lazyconnectionenlistment;
    @Param(name="lazyConnectionAssociation", optional=true, defaultValue="false")
    Boolean lazyconnectionassociation;
    @Param(name="associateWithThread", optional=true, defaultValue="false")
    Boolean associatewiththread;
    @Param(name="driverClassname", optional=true)
    String driverclassname;
    @Param(name="matchConnections", optional=true, defaultValue="false")
    Boolean matchconnections;
    @Param(name="maxConnectionUsageCount", optional=true, defaultValue="0")
    String maxconnectionusagecount = "0";
    @Param(optional=true, defaultValue="false")
    Boolean ping;
    @Param(optional=true, defaultValue="true")
    Boolean pooling;
    @Param(optional=true, name="statementCacheSize", defaultValue="0")
    String statementcachesize;
    @Param(name="validationClassname", optional=true)
    String validationclassname;
    @Param(name="wrapJdbcObjects", optional=true, defaultValue="true")
    Boolean wrapjdbcobjects;
    @Param(name="description", optional=true)
    String description;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(optional=true, obsolete=true)
    String target = "server";
    @Param(name="jdbc_connection_pool_id", alias="name", primary=true)
    String jdbc_connection_pool_id;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("name", this.jdbc_connection_pool_id);
        attrList.put("datasource-classname", this.datasourceclassname);
        attrList.put("description", this.description);
        attrList.put("res-type", this.restype);
        attrList.put("steady-pool-size", this.steadypoolsize);
        attrList.put("max-pool-size", this.maxpoolsize);
        attrList.put("max-wait-time-in-millis", this.maxwait);
        attrList.put("pool-resize-quantity", this.poolresize);
        attrList.put("init-sql", this.initsql);
        attrList.put("idle-timeout-in-seconds", this.idletimeout);
        attrList.put("transaction-isolation-level", this.isolationlevel);
        attrList.put("is-isolation-level-guaranteed", this.isisolationguaranteed.toString());
        attrList.put("is-connection-validation-required", this.isconnectvalidatereq.toString());
        attrList.put("connection-validation-method", this.validationmethod);
        attrList.put("validation-table-name", this.validationtable);
        attrList.put("fail-all-connections", this.failconnection.toString());
        attrList.put("non-transactional-connections", this.nontransactionalconnections.toString());
        attrList.put("allow-non-component-callers", this.allownoncomponentcallers.toString());
        attrList.put("validate-atmost-once-period-in-seconds", this.validateatmostonceperiod);
        attrList.put("connection-leak-timeout-in-seconds", this.leaktimeout);
        attrList.put("connection-leak-reclaim", this.leakreclaim.toString());
        attrList.put("connection-creation-retry-attempts", this.creationretryattempts);
        attrList.put("connection-creation-retry-interval-in-seconds", this.creationretryinterval);
        attrList.put("driver-classname", this.driverclassname);
        attrList.put("sql-trace-listeners", this.sqltracelisteners);
        attrList.put("statement-timeout-in-seconds", this.statementtimeout);
        attrList.put("statement-leak-timeout-in-seconds", this.statementLeaktimeout);
        attrList.put("statement-leak-reclaim", this.statementLeakreclaim.toString());
        attrList.put("statement-cache-size", this.statementcachesize);
        attrList.put("lazy-connection-association", this.lazyconnectionassociation.toString());
        attrList.put("lazy-connection-enlistment", this.lazyconnectionenlistment.toString());
        attrList.put("associate-with-thread", this.associatewiththread.toString());
        attrList.put("match-connections", this.matchconnections.toString());
        attrList.put("max-connection-usage-count", this.maxconnectionusagecount);
        attrList.put("ping", this.ping.toString());
        attrList.put("pooling", this.pooling.toString());
        attrList.put("validation-classname", this.validationclassname);
        attrList.put("wrap-jdbc-objects", this.wrapjdbcobjects.toString());
        try {
            JDBCConnectionPoolManager connPoolMgr = new JDBCConnectionPoolManager();
            rs = connPoolMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            String actual = e.getMessage();
            String def = "JDBC connection pool: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", def, new Object[]{this.jdbc_connection_pool_id, actual}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() == null) {
                report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} creation failed", new Object[]{this.jdbc_connection_pool_id, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        } else if ("true".equalsIgnoreCase(this.ping.toString())) {
            ActionReport subReport = report.addSubActionsReport();
            ParameterMap parameters = new ParameterMap();
            parameters.set((Object)"pool_name", (Object)this.jdbc_connection_pool_id);
            this.commandRunner.getCommandInvocation("ping-connection-pool", subReport).parameters(parameters).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                subReport.setMessage(localStrings.getLocalString("ping.create.jdbc.connection.pool.fail", "\nAttempting to ping during JDBC Connection Pool Creation : {0} - Failed.", new Object[]{this.jdbc_connection_pool_id}));
                subReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                subReport.setMessage(localStrings.getLocalString("ping.create.jdbc.connection.pool.success", "\nAttempting to ping during JDBC Connection Pool Creation : {0} - Succeeded.", new Object[]{this.jdbc_connection_pool_id}));
            }
        }
        report.setActionExitCode(ec);
    }
}

