/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spi.nodes;

import java.awt.Image;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.ImageUtilities;

public class NodeUtils {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/maven/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/maven/defaultFolderOpen.gif";
    private static Reference<LocalFileSystem> repoFS;
    public static final String ICON_DEPENDENCY_JAR = "org/netbeans/modules/maven/spi/nodes/DependencyJar.gif";

    public static Image getTreeFolderIcon(boolean opened) {
        Image base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
        if (base == null) {
            Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
            base = baseIcon != null ? ImageUtilities.icon2Image((Icon)baseIcon) : ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
        }
        assert (base != null);
        return base;
    }

    public static synchronized FileObject readOnlyLocalRepositoryFile(FileObject file) {
        File root;
        String path;
        LocalFileSystem fs;
        File f = FileUtil.toFile((FileObject)file);
        if (f == null || !file.isData()) {
            return file;
        }
        LocalFileSystem localFileSystem = fs = repoFS != null ? repoFS.get() : null;
        if (fs == null) {
            fs = new LocalFileSystem();
            fs.setReadOnly(true);
            try {
                fs.setRootDirectory(EmbedderFactory.getProjectEmbedder().getLocalRepositoryFile());
            }
            catch (Exception x) {
                throw new AssertionError((Object)x);
            }
            repoFS = new WeakReference<LocalFileSystem>(fs);
        }
        if ((path = FileUtilities.getRelativePath(root = fs.getRootDirectory(), f)) == null) {
            return file;
        }
        FileObject ro = fs.findResource(path);
        if (ro == null) {
            fs.refresh(false);
            ro = fs.findResource(path);
        }
        if (ro == null) {
            Logger.getLogger(NodeUtils.class.getName()).log(Level.WARNING, "Cannot find r/o equivalent of {0} as {1} in {2}", new Object[]{f, path, root});
            return file;
        }
        return ro;
    }

    private NodeUtils() {
    }
}

