/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.spi.queries.ForeignClassBundler;

public class ShadePluginDetector
implements ForeignClassBundler {
    private static final ProblemReport PROBLEM_REPORT = new ProblemReport(5, Bundle.PRBL_Name(), Bundle.PRBL_DESC(), null);
    private final Project project;
    private boolean calculated = false;
    private boolean calculatedValue = false;

    public ShadePluginDetector(Project project) {
        this.project = project;
    }

    private boolean calculateValue() {
        NbMavenProject nbmp;
        ProblemReporter pr = (ProblemReporter)this.project.getLookup().lookup(ProblemReporter.class);
        if (pr != null) {
            pr.removeReport(PROBLEM_REPORT);
        }
        if ((nbmp = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)) == null) {
            return true;
        }
        if (PluginPropertyUtils.getPluginVersion(nbmp.getMavenProject(), "org.apache.maven.plugins", "maven-shade-plugin") == null) {
            return true;
        }
        Boolean toret = Boolean.valueOf(PluginPropertyUtils.getPluginProperty(nbmp.getMavenProject(), "org.apache.maven.plugins", "maven-shade-plugin", "shadedArtifactAttached", "shade"));
        if (toret == Boolean.FALSE && pr != null) {
            pr.addReport(PROBLEM_REPORT);
        }
        return toret;
    }

    @Override
    public synchronized boolean preferSources() {
        if (this.calculated) {
            return this.calculatedValue;
        }
        this.calculatedValue = this.calculateValue();
        this.calculated = true;
        return this.calculatedValue;
    }

    @Override
    public synchronized void resetCachedValue() {
        this.calculated = false;
    }
}

