/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class MavenFileOwnerQueryImpl
implements FileOwnerQueryImplementation {
    private final PropertyChangeListener projectListener;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final Logger LOG = Logger.getLogger(MavenFileOwnerQueryImpl.class.getName());

    public MavenFileOwnerQueryImpl() {
        this.projectListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName()) && !MavenFileOwnerQueryImpl.this.registerProject((NbMavenProjectImpl)evt.getSource())) {
                    MavenFileOwnerQueryImpl.this.fireChange();
                }
            }
        };
    }

    public static MavenFileOwnerQueryImpl getInstance() {
        return (MavenFileOwnerQueryImpl)Lookup.getDefault().lookup(MavenFileOwnerQueryImpl.class);
    }

    public void attachProjectListener(NbMavenProjectImpl project) {
        project.getProjectWatcher().removePropertyChangeListener(this.projectListener);
        project.getProjectWatcher().addPropertyChangeListener(this.projectListener);
    }

    public void registerCoordinates(String groupId, String artifactId, String version, URL owner) {
        String oldkey = groupId + ':' + artifactId;
        if (owner.toString().equals(MavenFileOwnerQueryImpl.prefs().get(oldkey, null))) {
            MavenFileOwnerQueryImpl.prefs().remove(oldkey);
        }
        String key = oldkey + ":" + version;
        String ownerString = owner.toString();
        try {
            for (String k : MavenFileOwnerQueryImpl.prefs().keys()) {
                if (!ownerString.equals(MavenFileOwnerQueryImpl.prefs().get(k, null))) continue;
                MavenFileOwnerQueryImpl.prefs().remove(k);
                break;
            }
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.FINE, "Error iterating preference to find old mapping", ex);
        }
        MavenFileOwnerQueryImpl.prefs().put(key, ownerString);
        LOG.log(Level.FINE, "Registering {0} under {1}", new Object[]{owner, key});
    }

    public boolean registerProject(NbMavenProjectImpl project) {
        MavenProject model = project.getOriginalMavenProject();
        this.attachProjectListener(project);
        if (NbMavenProject.isErrorPlaceholder(model)) {
            LOG.log(Level.FINE, "will not register unloadable {0}", project.getPOMFile());
            return false;
        }
        this.registerCoordinates(model.getGroupId(), model.getArtifactId(), model.getVersion(), project.getProjectDirectory().toURL());
        this.fireChange();
        return true;
    }

    public void addChangeListener(ChangeListener list) {
        this.cs.addChangeListener(list);
    }

    public void removeChangeListener(ChangeListener list) {
        this.cs.removeChangeListener(list);
    }

    private void fireChange() {
        this.cs.fireChange();
    }

    public Project getOwner(URI uri) {
        LOG.log(Level.FINEST, "getOwner of uri={0}", uri);
        if ("file".equals(uri.getScheme())) {
            File file = Utilities.toFile((URI)uri);
            return this.getOwner(file);
        }
        return null;
    }

    public Project getOwner(FileObject fileObject) {
        LOG.log(Level.FINEST, "getOwner of fileobject={0}", fileObject);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    @CheckForNull
    static String[] findCoordinates(File file) {
        File parentArt;
        String nm = file.getName();
        File parentVer = file.getParentFile();
        if (parentVer != null && (parentArt = parentVer.getParentFile()) != null) {
            File parentGroup;
            String artifactID = parentArt.getName();
            String version = parentVer.getName();
            if (nm.startsWith(artifactID + '-' + version) && (parentGroup = parentArt.getParentFile()) != null) {
                return MavenFileOwnerQueryImpl.findCoordinates(parentGroup, artifactID, version);
            }
        }
        return null;
    }

    @CheckForNull
    private static String[] findCoordinates(File parentGroup, String artifactID, String version) {
        String parentGroupS;
        File repo = new File(EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir());
        String repoS = repo.getAbsolutePath();
        if (!repoS.endsWith(File.separator)) {
            repoS = repoS + File.separatorChar;
        }
        if ((parentGroupS = parentGroup.getAbsolutePath()).endsWith(File.separator)) {
            parentGroupS = parentGroupS.substring(0, parentGroupS.length() - 1);
        }
        if (parentGroupS.startsWith(repoS)) {
            String groupID = parentGroupS.substring(repoS.length()).replace(File.separatorChar, '.');
            return new String[]{groupID, artifactID, version};
        }
        return null;
    }

    private Project getOwner(File file) {
        LOG.log(Level.FINER, "Looking for owner of {0}", file);
        String[] coordinates = MavenFileOwnerQueryImpl.findCoordinates(file);
        if (coordinates == null) {
            LOG.log(Level.FINER, "{0} not an artifact in local repo", file);
            return null;
        }
        return this.getOwner(coordinates[0], coordinates[1], coordinates[2]);
    }

    public Project getOwner(String groupId, String artifactId, String version) {
        LOG.log(Level.FINER, "Checking {0} / {1} / {2}", new Object[]{groupId, artifactId, version});
        String oldKey = groupId + ":" + artifactId;
        String key = oldKey + ":" + version;
        String ownerURI = MavenFileOwnerQueryImpl.prefs().get(key, null);
        boolean usingOldKey = false;
        if (ownerURI == null) {
            ownerURI = MavenFileOwnerQueryImpl.prefs().get(oldKey, null);
            usingOldKey = true;
        }
        if (ownerURI != null) {
            boolean stale = true;
            try {
                FileObject projectDir = URLMapper.findFileObject((URL)new URI(ownerURI).toURL());
                if (projectDir != null && projectDir.isFolder()) {
                    Project p = ProjectManager.getDefault().findProject(projectDir);
                    if (p != null) {
                        NbMavenProjectImpl mp = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                        if (mp != null) {
                            MavenProject model = mp.getOriginalMavenProject();
                            if (model.getGroupId().equals(groupId) && model.getArtifactId().equals(artifactId)) {
                                if (model.getVersion().equals(version)) {
                                    LOG.log(Level.FINE, "Found match {0}", p);
                                    this.attachProjectListener(mp);
                                    return p;
                                }
                                LOG.log(Level.FINE, "Mismatch on version {0} in {1}", new Object[]{model.getVersion(), ownerURI});
                                stale = false;
                                this.registerProject(mp);
                            } else {
                                LOG.log(Level.FINE, "Mismatch on group and/or artifact ID in {0}", ownerURI);
                                this.registerProject(mp);
                            }
                        } else {
                            LOG.log(Level.FINE, "Not a Maven project {0} in {1}", new Object[]{p, ownerURI});
                        }
                    } else {
                        LOG.log(Level.FINE, "No such project in {0}", ownerURI);
                    }
                } else {
                    LOG.log(Level.FINE, "No such folder {0}", ownerURI);
                }
            }
            catch (IOException x) {
                LOG.log(Level.FINE, "Could not load project in " + ownerURI, x);
            }
            catch (URISyntaxException x) {
                LOG.log(Level.INFO, null, x);
            }
            if (stale) {
                if (usingOldKey) {
                    MavenFileOwnerQueryImpl.prefs().remove(oldKey);
                } else {
                    MavenFileOwnerQueryImpl.prefs().remove(key);
                }
            }
        } else {
            LOG.log(Level.FINE, "No known owner for {0}", key);
        }
        return null;
    }

    public File getOwnerPOM(String groupId, String artifactId, String version) {
        LOG.log(Level.FINER, "Checking {0} / {1} / {2} (POM only)", new Object[]{groupId, artifactId, version});
        String oldKey = groupId + ":" + artifactId;
        String key = oldKey + ":" + version;
        String ownerURI = MavenFileOwnerQueryImpl.prefs().get(key, null);
        boolean usingOldKey = false;
        if (ownerURI == null) {
            ownerURI = MavenFileOwnerQueryImpl.prefs().get(oldKey, null);
            usingOldKey = true;
        }
        if (ownerURI != null) {
            try {
                URI uri = new URI(ownerURI);
                if ("file".equals(uri.getScheme())) {
                    File pom = Utilities.toFile((URI)uri.resolve("pom.xml"));
                    if (pom.isFile()) {
                        ModelReader reader = (ModelReader)EmbedderFactory.getProjectEmbedder().lookupComponent(ModelReader.class);
                        Model model = reader.read(pom, Collections.singletonMap("org.apache.maven.model.io.isStrict", false));
                        Parent parent = model.getParent();
                        if (groupId.equals(model.getGroupId()) || parent != null && groupId.equals(parent.getGroupId())) {
                            if (artifactId.equals(model.getArtifactId()) || parent != null && artifactId.equals(parent.getArtifactId())) {
                                if (version.equals(model.getVersion()) || parent != null && version.equals(parent.getVersion())) {
                                    LOG.log(Level.FINE, "found match {0}", pom);
                                    return pom;
                                }
                                LOG.log(Level.FINE, "mismatch on version in {0}", pom);
                            } else {
                                LOG.log(Level.FINE, "mismatch on artifactId in {0}", pom);
                            }
                        } else {
                            LOG.log(Level.FINE, "mismatch on groupId in {0}", pom);
                        }
                        FileObject projectDir = URLMapper.findFileObject((URL)new URI(ownerURI).toURL());
                        if (projectDir != null && projectDir.isFolder()) {
                            MavenProject prj = MavenProjectCache.getMavenProject(projectDir, false);
                            if (prj != null && prj.getGroupId().equals(groupId) && prj.getArtifactId().equals(artifactId) && prj.getVersion().equals(version)) {
                                return pom;
                            }
                        } else {
                            LOG.log(Level.FINE, "no live project match for {0}", pom);
                        }
                    } else {
                        LOG.log(Level.FINE, "no such file {0}", pom);
                    }
                } else {
                    LOG.log(Level.FINE, "not a file URI {0}", uri);
                }
            }
            catch (IOException x) {
                LOG.log(Level.FINE, "Could not load project in " + ownerURI, x);
            }
            catch (URISyntaxException x) {
                LOG.log(Level.INFO, null, x);
            }
            if (usingOldKey) {
                MavenFileOwnerQueryImpl.prefs().remove(oldKey);
            } else {
                MavenFileOwnerQueryImpl.prefs().remove(key);
            }
        } else {
            LOG.log(Level.FINE, "No known owner for {0}", key);
        }
        return null;
    }

    static Preferences prefs() {
        return NbPreferences.forModule(MavenFileOwnerQueryImpl.class).node("externalOwners");
    }
}

