/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.queries.JavaLikeRootProvider;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
public class MavenBinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private final Project project;
    private final Map<URL, Res> results;

    public MavenBinaryForSourceQueryImpl(Project prj) {
        this.project = prj;
        this.results = new HashMap<URL, Res>();
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL url) {
        if (this.results.containsKey(url)) {
            return this.results.get(url);
        }
        if ("file".equals(url.getProtocol())) {
            try {
                File fil = Utilities.toFile((URI)url.toURI());
                fil = FileUtil.normalizeFile((File)fil);
                Res toReturn = this.findFor(fil);
                if (toReturn != null) {
                    this.results.put(url, toReturn);
                }
                return toReturn;
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private Res findFor(File fil) {
        String testSrc;
        File testSrcFile;
        MavenProject mav = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        String src = mav.getBuild() != null ? mav.getBuild().getSourceDirectory() : null;
        File srcFile = src != null ? FileUtil.normalizeFile((File)new File(src)) : null;
        Res toReturn = this.checkRoot(fil, srcFile, testSrcFile = (testSrc = mav.getBuild() != null ? mav.getBuild().getTestSourceDirectory() : null) != null ? FileUtil.normalizeFile((File)new File(testSrc)) : null);
        if (toReturn != null) {
            return toReturn;
        }
        NbMavenProjectImpl impl = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        for (URI res : impl.getResources(false)) {
            toReturn = this.checkRoot(fil, res, null);
            if (toReturn == null) continue;
            return toReturn;
        }
        for (URI res : impl.getResources(true)) {
            toReturn = this.checkRoot(fil, null, res);
            if (toReturn == null) continue;
            return toReturn;
        }
        for (URI gen : impl.getGeneratedSourceRoots(false)) {
            toReturn = this.checkRoot(fil, gen, null);
            if (toReturn == null) continue;
            return toReturn;
        }
        for (URI gen : impl.getGeneratedSourceRoots(true)) {
            toReturn = this.checkRoot(fil, null, gen);
            if (toReturn == null) continue;
            return toReturn;
        }
        for (JavaLikeRootProvider rp : this.project.getLookup().lookupAll(JavaLikeRootProvider.class)) {
            toReturn = this.checkRoot(fil, FileUtilities.getDirURI(this.project.getProjectDirectory(), "src/main/" + rp.kind()), FileUtilities.getDirURI(this.project.getProjectDirectory(), "src/test/" + rp.kind()));
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    private Res checkRoot(File root, File source, File test) {
        if (source != null && source.equals(root)) {
            return new Res(false, (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class));
        }
        if (test != null && test.equals(root)) {
            return new Res(true, (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class));
        }
        return null;
    }

    private Res checkRoot(File root, URI source, URI test) {
        return this.checkRoot(root, source != null ? FileUtil.normalizeFile((File)Utilities.toFile((URI)source)) : null, test != null ? FileUtil.normalizeFile((File)Utilities.toFile((URI)test)) : null);
    }

    private static class Res
    implements BinaryForSourceQuery.Result {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private NbMavenProject project;
        private boolean isTest;

        Res(boolean test, NbMavenProject prj) {
            this.isTest = test;
            this.project = prj;
        }

        public URL[] getRoots() {
            return new URL[]{FileUtil.urlForArchiveOrDir((File)this.project.getOutputDirectory(this.isTest))};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> lists = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            for (ChangeListener listen : lists) {
                listen.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

