/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenAnnotationProcessingQueryImpl
implements AnnotationProcessingQueryImplementation {
    private final Project prj;

    public MavenAnnotationProcessingQueryImpl(Project prj) {
        this.prj = prj;
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(final FileObject file) {
        return new AnnotationProcessingQuery.Result(){

            public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
                String version = PluginPropertyUtils.getPluginVersion(((NbMavenProject)MavenAnnotationProcessingQueryImpl.this.prj.getLookup().lookup(NbMavenProject.class)).getMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
                if (version != null && new ComparableVersion(version).compareTo(new ComparableVersion("2.2")) < 0) {
                    return EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
                }
                String compilerArgument = PluginPropertyUtils.getPluginProperty(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", this.tests() ? "testCompile" : "compile");
                if ("-proc:none".equals(compilerArgument)) {
                    return EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
                }
                return EnumSet.allOf(AnnotationProcessingQuery.Trigger.class);
            }

            public Iterable<? extends String> annotationProcessorsToRun() {
                String[] procs = PluginPropertyUtils.getPluginPropertyList(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "annotationProcessors", "annotationProcessor", this.tests() ? "testCompile" : "compile");
                return procs != null ? Arrays.asList(procs) : null;
            }

            public URL sourceOutputDirectory() {
                boolean tests = this.tests();
                String generatedSourcesDirectory = PluginPropertyUtils.getPluginProperty(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "generatedSourcesDirectory", tests ? "testCompile" : "compile");
                if (generatedSourcesDirectory == null) {
                    generatedSourcesDirectory = tests ? "${project.build.directory}/generated-sources/test-annotations" : "${project.build.directory}/generated-sources/annotations";
                }
                try {
                    return FileUtil.urlForArchiveOrDir((File)new File((String)PluginPropertyUtils.createEvaluator(((NbMavenProject)MavenAnnotationProcessingQueryImpl.this.prj.getLookup().lookup(NbMavenProject.class)).getMavenProject()).evaluate(generatedSourcesDirectory)));
                }
                catch (ExpressionEvaluationException ex) {
                    return null;
                }
            }

            public Map<? extends String, ? extends String> processorOptions() {
                String compilerArgument;
                LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                options.put("eclipselink.canonicalmodel.use_static_factory", "false");
                String goal = this.tests() ? "testCompile" : "compile";
                Properties props = PluginPropertyUtils.getPluginPropertyParameter(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArguments", goal);
                if (props != null) {
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String k = (String)entry.getKey();
                        if (!k.startsWith("A")) continue;
                        String v = (String)entry.getValue();
                        options.put(k.substring(1), v.isEmpty() ? null : v);
                    }
                }
                if ((compilerArgument = PluginPropertyUtils.getPluginProperty(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", goal)) != null && compilerArgument.startsWith("-A")) {
                    int idx = compilerArgument.indexOf(61);
                    if (idx != -1) {
                        options.put(compilerArgument.substring(2, idx), compilerArgument.substring(idx + 1));
                    } else {
                        options.put(compilerArgument.substring(2), null);
                    }
                }
                return options;
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }

            private boolean tests() {
                NbMavenProjectImpl project = (NbMavenProjectImpl)MavenAnnotationProcessingQueryImpl.this.prj.getLookup().lookup(NbMavenProjectImpl.class);
                String actual = file.toURI().toString();
                for (URI r : project.getSourceRoots(true)) {
                    if (!actual.startsWith(r.toString())) continue;
                    return true;
                }
                for (URI r : project.getGeneratedSourceRoots(true)) {
                    if (!actual.startsWith(r.toString())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

