/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class CompileAnnotation
implements OutputListener {
    File clazzfile;
    private int lineNum;
    private String text;

    public CompileAnnotation(File clazz, String line, String textAnn) {
        this.clazzfile = clazz;
        this.text = textAnn;
        try {
            this.lineNum = Integer.parseInt(line);
        }
        catch (NumberFormatException exc) {
            this.lineNum = -1;
        }
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineAction(OutputEvent ev) {
        block9: {
            FileUtil.refreshFor((File[])new File[]{this.clazzfile});
            FileObject file = FileUtil.toFileObject((File)this.clazzfile);
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (this.lineNum == -1) {
                        ed.open();
                        break block9;
                    }
                    ed.openDocument();
                    try {
                        Line l = ed.getLineSet().getOriginal(this.lineNum - 1);
                        if (!l.isDeleted()) {
                            l.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
                        }
                        break block9;
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        ed.open();
                    }
                    break block9;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    public void outputLineCleared(OutputEvent ev) {
    }

    public String toString() {
        return "error[" + this.clazzfile + ":" + this.lineNum + ":" + this.text + "]";
    }
}

