/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.spi.nodes.SpecialIcon;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

public class MavenProjectNode
extends AbstractNode {
    static final String BADGE_ICON = "org/netbeans/modules/maven/brokenProjectBadge.png";
    private static final String toolTipBroken = "<img src=\"" + MavenProjectNode.class.getClassLoader().getResource("org/netbeans/modules/maven/brokenProjectBadge.png") + "\">&nbsp;" + Bundle.ICON_BrokenProjectBadge();
    private NbMavenProjectImpl project;
    private final ProjectInformation info;
    private ProblemReporterImpl reporter;

    public MavenProjectNode(Lookup lookup, NbMavenProjectImpl proj) {
        super(NodeFactorySupport.createCompositeChildren((Project)proj, (String)"Projects/org-netbeans-modules-maven/Nodes"), lookup);
        this.project = proj;
        this.info = ProjectUtils.getInformation((Project)this.project);
        this.info.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String prop = event.getPropertyName();
                if ("name".equals(prop)) {
                    MavenProjectNode.this.fireNameChange(null, null);
                } else if ("displayName".equals(prop)) {
                    MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                } else if ("icon".equals(prop)) {
                    MavenProjectNode.this.fireIconChange();
                    MavenProjectNode.this.fireOpenedIconChange();
                }
            }
        });
        this.reporter = (ProblemReporterImpl)proj.getLookup().lookup(ProblemReporterImpl.class);
        this.reporter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectNode.this.fireIconChange();
                        MavenProjectNode.this.fireOpenedIconChange();
                        MavenProjectNode.this.fireNameChange(null, MavenProjectNode.this.getName());
                        MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                        MavenProjectNode.this.fireShortDescriptionChange(null, MavenProjectNode.this.getShortDescription());
                    }
                });
            }
        });
    }

    public String getName() {
        return this.project.getProjectDirectory().toURI().toString();
    }

    public String getDisplayName() {
        return this.info.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (!this.project.isMavenProjectLoaded()) {
            return null;
        }
        String packaging = this.project.getOriginalMavenProject().getPackaging();
        if (this.project.getLookup().lookup(SpecialIcon.class) != null) {
            return null;
        }
        try {
            return XMLUtil.toElementContent((String)this.getDisplayName()) + " <font color='!controlShadow'>" + packaging + "</font>";
        }
        catch (CharConversionException x) {
            return null;
        }
    }

    public Image getIcon(int param) {
        Image img = ImageUtilities.icon2Image((Icon)this.info.getIcon());
        if (this.reporter.isBroken()) {
            Image ann = ImageUtilities.loadImage((String)BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipBroken);
            img = ImageUtilities.mergeImages((Image)img, (Image)ann, (int)8, (int)0);
        }
        return img;
    }

    public Image getOpenedIcon(int param) {
        Image img = ImageUtilities.icon2Image((Icon)this.info.getIcon());
        if (this.reporter.isBroken()) {
            Image ann = ImageUtilities.loadImage((String)BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipBroken);
            img = ImageUtilities.mergeImages((Image)img, (Image)ann, (int)8, (int)0);
        }
        return img;
    }

    public Action[] getActions(boolean param) {
        return CommonProjectActions.forType((String)"org-netbeans-modules-maven");
    }

    public String getShortDescription() {
        String desc;
        StringBuilder buf = new StringBuilder();
        MavenProject mp = this.project.getOriginalMavenProject();
        boolean errorPlaceholder = NbMavenProject.isErrorPlaceholder(mp);
        if (errorPlaceholder) {
            desc = Bundle.TXT_FailedProjectLoadingDesc();
        } else {
            desc = mp.getDescription();
            if (desc == null) {
                desc = Bundle.LBL_DefaultDescription();
            }
        }
        buf.append("<html><i>").append(Bundle.DESC_Project1()).append("</i><b> ").append(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())).append("</b><br><i>");
        if (!errorPlaceholder) {
            buf.append(Bundle.DESC_Project2()).append("</i><b> ").append(mp.getGroupId()).append("</b><br><i>");
            buf.append(Bundle.DESC_Project3()).append("</i><b> ").append(mp.getArtifactId()).append("</b><br><i>");
            buf.append(Bundle.DESC_Project4()).append("</i><b> ").append(mp.getVersion()).append("</b><br><i>");
            buf.append(Bundle.DESC_Project5()).append("</i><b> ").append(mp.getPackaging()).append("</b><br><i>");
        }
        buf.append(Bundle.DESC_Project6()).append("</i> ").append(this.breakPerLine(desc, Bundle.DESC_Project5().length()));
        Collection<ProblemReport> problems = this.reporter.getReports();
        if (!problems.isEmpty()) {
            buf.append("<br><b>").append(Bundle.DESC_Project7()).append("</b><br><ul>");
            for (ProblemReport elem : problems) {
                buf.append("<li>").append(elem.getShortDescription()).append("</li>");
            }
            buf.append("</ul>");
        }
        return buf.toString();
    }

    private String breakPerLine(String string, int start) {
        StringBuilder buf = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(string, " ", true);
        int charCount = start;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ((charCount += token.length()) > 50) {
                charCount = 0;
                buf.append("<br>");
            }
            buf.append(token);
        }
        return buf.toString();
    }
}

