/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.nodes.AddDependencyPanel;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.DependencyNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class DependenciesNode
extends AbstractNode {
    public static final String PREF_DEPENDENCIES_UI = "org/netbeans/modules/maven/dependencies/ui";
    private final DependenciesSet dependencies;
    private static final RequestProcessor RP = new RequestProcessor(DependenciesNode.class);
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/maven/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/maven/defaultFolderOpen.gif";

    DependenciesNode(DependenciesSet dependencies) {
        super(Children.create((ChildFactory)new DependenciesChildren(dependencies), (boolean)true), Lookups.fixed((Object[])new Object[]{dependencies.project}));
        this.dependencies = dependencies;
        this.setName("Dependencies" + (Object)((Object)dependencies.type));
        switch (dependencies.type) {
            case COMPILE: {
                this.setDisplayName(Bundle.LBL_Libraries());
                break;
            }
            case TEST: {
                this.setDisplayName(Bundle.LBL_Test_Libraries());
                break;
            }
            case RUNTIME: {
                this.setDisplayName(Bundle.LBL_Runtime_Libraries());
                break;
            }
            default: {
                this.setDisplayName(Bundle.LBL_non_cp_libraries());
            }
        }
        this.setIconBaseWithExtension(ICON_PATH);
    }

    public Image getIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(false), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(true), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        return retValue;
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> toRet = new ArrayList<AbstractAction>();
        toRet.add(new AddDependencyAction());
        toRet.add(null);
        toRet.add(new ResolveDepsAction(this.dependencies.project));
        toRet.add(new DownloadJavadocSrcAction(true));
        toRet.add(new DownloadJavadocSrcAction(false));
        toRet.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/DependenciesActions"));
        toRet.add(null);
        toRet.add(new DependencyNode.ShowManagedStateAction());
        return toRet.toArray(new Action[toRet.size()]);
    }

    public static Image getTreeFolderIcon(boolean opened) {
        Image base;
        Icon baseIcon = UIManager.getIcon(opened ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (baseIcon != null) {
            base = ImageUtilities.icon2Image((Icon)baseIcon);
        } else {
            base = (Image)UIManager.get(opened ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (base == null) {
                base = ImageUtilities.loadImage((String)(opened ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
            }
        }
        assert (base != null);
        return base;
    }

    static Preferences prefs() {
        return NbPreferences.root().node(PREF_DEPENDENCIES_UI);
    }

    private class AddDependencyAction
    extends AbstractAction {
        AddDependencyAction() {
            this.putValue("Name", Bundle.BTN_Add_Library());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String typeString = DependenciesNode.this.dependencies.type == Type.RUNTIME ? "runtime" : (DependenciesNode.this.dependencies.type == Type.TEST ? "test" : "compile");
            final String[] data = AddDependencyPanel.show(DependenciesNode.this.dependencies.project, true, typeString);
            if (data != null) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ModelUtils.addDependency(DependenciesNode.this.dependencies.project.getProjectDirectory().getFileObject("pom.xml"), data[0], data[1], data[2], data[4], data[3], data[5], false);
                        ((NbMavenProject)DependenciesNode.this.dependencies.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(false);
                    }
                });
            }
        }
    }

    private static class DependenciesChildren
    extends ChildFactory<DependencyWrapper>
    implements ChangeListener {
        private final DependenciesSet dependencies;

        DependenciesChildren(DependenciesSet dependencies) {
            this.dependencies = dependencies;
            dependencies.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)dependencies));
        }

        protected Node createNodeForKey(DependencyWrapper wr) {
            Artifact art = wr.getArtifact();
            if (art.getFile() == null) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName("No such artifact: " + art);
                return n;
            }
            return new DependencyNode(this.dependencies.project, art, true);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        protected boolean createKeys(List<DependencyWrapper> toPopulate) {
            toPopulate.addAll(this.dependencies.list());
            return true;
        }
    }

    private static class DependenciesComparator
    implements Comparator<DependencyWrapper> {
        private DependenciesComparator() {
        }

        @Override
        public int compare(DependencyWrapper art1, DependencyWrapper art2) {
            boolean transitive2;
            boolean transitive1 = art1.getArtifact().getDependencyTrail().size() > 2;
            boolean bl = transitive2 = art2.getArtifact().getDependencyTrail().size() > 2;
            if (transitive1 && !transitive2) {
                return 1;
            }
            if (!transitive1 && transitive2) {
                return -1;
            }
            int ret = art1.getArtifact().getArtifactId().compareTo(art2.getArtifact().getArtifactId());
            if (ret != 0) {
                return ret;
            }
            return art1.getArtifact().compareTo((Object)art2.getArtifact());
        }
    }

    static final class DependenciesSet
    implements PropertyChangeListener {
        private NbMavenProjectImpl project;
        private final Type type;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        DependenciesSet(NbMavenProjectImpl project, Type type) {
            this.project = project;
            this.type = type;
            NbMavenProject nbmp = project.getProjectWatcher();
            nbmp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nbmp));
        }

        Collection<DependencyWrapper> list() {
            TreeSet<DependencyWrapper> lst = new TreeSet<DependencyWrapper>(new DependenciesComparator());
            MavenProject mp = this.project.getOriginalMavenProject();
            Set arts = mp.getArtifacts();
            switch (this.type) {
                case COMPILE: {
                    this.create(lst, arts, "compile", "provided", "system");
                    break;
                }
                case TEST: {
                    this.create(lst, arts, "test");
                    break;
                }
                case RUNTIME: {
                    this.create(lst, arts, "runtime");
                    break;
                }
                default: {
                    for (Artifact a : arts) {
                        if (a.getArtifactHandler().isAddedToClasspath()) continue;
                        lst.add(new DependencyWrapper(a));
                    }
                }
            }
            return lst;
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.cs.fireChange();
            }
        }

        private void create(Set<DependencyWrapper> lst, Collection<Artifact> arts, String ... scopes) {
            for (Artifact a : arts) {
                if (!Arrays.asList(scopes).contains(a.getScope()) || !a.getArtifactHandler().isAddedToClasspath()) continue;
                lst.add(new DependencyWrapper(a));
            }
        }
    }

    private static class DependencyWrapper {
        private Artifact artifact;

        public DependencyWrapper(Artifact artifact) {
            this.artifact = artifact;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyWrapper other = (DependencyWrapper)obj;
            if (!this.artifact.equals(other.artifact)) {
                return false;
            }
            if (!((Object)this.artifact.getDependencyTrail()).equals(other.artifact.getDependencyTrail())) {
                return false;
            }
            return this.artifact.getFile().equals(other.artifact.getFile());
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.artifact.hashCode() + ((Object)this.artifact.getDependencyTrail()).hashCode();
            hash = 31 * hash + this.artifact.getFile().hashCode();
            return hash;
        }
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        private boolean javadoc;

        DownloadJavadocSrcAction(boolean javadoc) {
            this.putValue("Name", javadoc ? Bundle.LBL_Download_Javadoc() : Bundle.LBL_Download__Sources());
            this.javadoc = javadoc;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Node[] nds = DependenciesNode.this.getChildren().getNodes();
                    ProgressContributor[] contribs = new ProgressContributor[nds.length];
                    for (int i = 0; i < nds.length; ++i) {
                        contribs[i] = AggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                    }
                    String label = DownloadJavadocSrcAction.this.javadoc ? Bundle.Progress_Javadoc() : Bundle.Progress_Source();
                    AggregateProgressHandle handle = AggregateProgressFactory.createHandle((String)label, (ProgressContributor[])contribs, (Cancellable)ProgressTransferListener.cancellable(), null);
                    handle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)handle);
                        for (int i = 0; i < nds.length; ++i) {
                            AtomicBoolean cancel = ProgressTransferListener.activeListener().cancel;
                            if (cancel != null && cancel.get()) {
                                return;
                            }
                            if (!(nds[i] instanceof DependencyNode)) continue;
                            DependencyNode nd = (DependencyNode)nds[i];
                            if (DownloadJavadocSrcAction.this.javadoc && !nd.hasJavadocInRepository()) {
                                nd.downloadJavadocSources(contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            if (!DownloadJavadocSrcAction.this.javadoc && !nd.hasSourceInRepository()) {
                                nd.downloadJavadocSources(contribs[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            contribs[i].finish();
                        }
                    }
                    catch (ThreadDeath d) {
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                    }
                    finally {
                        handle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                }
            });
        }
    }

    private static class ResolveDepsAction
    extends AbstractAction {
        private Project project;

        ResolveDepsAction(Project prj) {
            this.putValue("Name", Bundle.LBL_Download());
            this.project = prj;
        }

        @Override
        public void actionPerformed(ActionEvent evnt) {
            this.setEnabled(false);
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(false);
        }
    }

    static enum Type {
        COMPILE,
        TEST,
        RUNTIME,
        NONCP;

    }
}

