/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeProvider;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.modules.Places;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

public abstract class CatalogRepoProvider
implements ArchetypeProvider {
    private static final String EL_ARCHETYPES = "archetypes";
    private static final String EL_ARCHETYPE = "archetype";
    private static final String EL_ARTIFACTID = "artifactId";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_GROUPID = "groupId";
    private static final String EL_REPOSITORY = "repository";
    private static final String EL_VERSION = "version";
    private static final Logger LOG = Logger.getLogger(CatalogRepoProvider.class.getName());
    private static final long ARCHETYPE_TIMEOUT = 86400000L;

    protected CatalogRepoProvider() {
    }

    protected abstract URL file() throws IOException;

    protected abstract String repository();

    @Override
    public List<Archetype> getArchetypes() {
        try {
            return CatalogRepoProvider.getArchetypes(this.file(), this.repository());
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    static List<Archetype> getArchetypes(URL file, String repository) {
        ArrayList<Archetype> toRet = new ArrayList<Archetype>();
        try {
            Namespace ns;
            if (file == null) {
                return toRet;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            Element list = root.getChild(EL_ARCHETYPES, ns = root.getNamespace());
            if (list != null) {
                for (Element el : NbCollections.checkedListByCopy((List)list.getChildren(EL_ARCHETYPE, ns), Element.class, (boolean)true)) {
                    String grId = el.getChildText(EL_GROUPID, ns);
                    String artId = el.getChildText(EL_ARTIFACTID, ns);
                    String ver = el.getChildText(EL_VERSION, ns);
                    String repo = el.getChildText(EL_REPOSITORY, ns);
                    String desc = el.getChildText(EL_DESCRIPTION, ns);
                    Archetype archetype = new Archetype(false);
                    if (grId == null || artId == null || ver == null) continue;
                    archetype.setArtifactId(artId);
                    archetype.setGroupId(grId);
                    archetype.setVersion(ver);
                    if (repo != null) {
                        archetype.setRepository(repo);
                    } else {
                        archetype.setRepository(repository);
                    }
                    if (desc != null) {
                        archetype.setDescription(desc);
                    }
                    toRet.add(archetype);
                }
            }
        }
        catch (IOException exc) {
            LOG.log(Level.INFO, null, exc);
        }
        catch (JDOMException exc) {
            LOG.log(Level.INFO, null, exc);
        }
        return toRet;
    }

    public static class LocalCatalogRepoProvider
    extends CatalogRepoProvider {
        @Override
        protected URL file() throws IOException {
            File f = new File(RepositorySystem.userMavenConfigurationHome, "archetype-catalog.xml");
            return f.isFile() ? Utilities.toURI((File)f).toURL() : null;
        }

        @Override
        protected String repository() {
            return "local";
        }
    }

    public static class RemoteCatalogProvider
    implements ArchetypeProvider {
        @Override
        public List<Archetype> getArchetypes() {
            File root = Places.getCacheSubdirectory((String)"mavenarchetypes");
            ArrayList<Archetype> toRet = new ArrayList<Archetype>();
            MavenEmbedder embedder = EmbedderFactory.getOnlineEmbedder();
            SettingsDecryptionResult settings = ((SettingsDecrypter)embedder.lookupComponent(SettingsDecrypter.class)).decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(embedder.getSettings()));
            for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                if (!info.isRemoteDownloadable()) continue;
                File catalog = new File(new File(root, info.getId()), "archetype-catalog.xml");
                boolean download = false;
                if (!catalog.exists()) {
                    download = true;
                } else {
                    long lastM = catalog.lastModified();
                    if (lastM == 0L) {
                        download = true;
                    } else if (lastM - System.currentTimeMillis() > 86400000L) {
                        download = true;
                    }
                }
                if (download) {
                    this.download(info.getId(), info.getRepositoryUrl(), catalog, settings, embedder);
                }
                if (!catalog.exists()) continue;
                try {
                    toRet.addAll(CatalogRepoProvider.getArchetypes(Utilities.toURI((File)catalog).toURL(), info.getRepositoryUrl()));
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
            return toRet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void download(String id, String url, File catalog, SettingsDecryptionResult settings, MavenEmbedder embedder) {
            String baseurl = url;
            String repoId = id;
            try {
                catalog.getParentFile().mkdirs();
                AuthenticationInfo wagonAuth = null;
                MirrorSelector mrri = (MirrorSelector)embedder.getPlexus().lookup(MirrorSelector.class);
                ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)embedder.getPlexus().lookup(ArtifactRepositoryLayout.ROLE, "default");
                ArtifactRepositoryFactory arf = (ArtifactRepositoryFactory)embedder.getPlexus().lookup(ArtifactRepositoryFactory.class);
                ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "daily", "daily");
                ArtifactRepository art = arf.createArtifactRepository(repoId, baseurl, layout, policy, policy);
                Mirror mirr = mrri.getMirror(art, embedder.getSettings().getMirrors());
                if (mirr != null) {
                    baseurl = mirr.getUrl();
                    repoId = mirr.getId();
                }
                for (Server server : settings.getServers()) {
                    if (!repoId.equals(server.getId())) continue;
                    wagonAuth = new AuthenticationInfo();
                    wagonAuth.setUserName(server.getUsername());
                    wagonAuth.setPassword(server.getPassword());
                    wagonAuth.setPassphrase(server.getPassphrase());
                    wagonAuth.setPrivateKey(server.getPrivateKey());
                    break;
                }
                String protocol = URI.create(baseurl).getScheme();
                ProxyInfo wagonProxy = null;
                for (Proxy proxy : settings.getProxies()) {
                    if (!proxy.isActive()) continue;
                    wagonProxy = new ProxyInfo();
                    wagonProxy.setHost(proxy.getHost());
                    wagonProxy.setPort(proxy.getPort());
                    wagonProxy.setNonProxyHosts(proxy.getNonProxyHosts());
                    wagonProxy.setUserName(proxy.getUsername());
                    wagonProxy.setPassword(proxy.getPassword());
                    wagonProxy.setType(protocol);
                    break;
                }
                Wagon wagon = (Wagon)embedder.getPlexus().lookup(Wagon.class, protocol);
                assert (wagon != null);
                Repository repository = new Repository(repoId, baseurl);
                try {
                    if (wagonAuth != null) {
                        if (wagonProxy != null) {
                            wagon.connect(repository, wagonAuth, wagonProxy);
                        } else {
                            wagon.connect(repository, wagonAuth);
                        }
                    } else if (wagonProxy != null) {
                        wagon.connect(repository, wagonProxy);
                    } else {
                        wagon.connect(repository);
                    }
                    File temp = File.createTempFile("maven", "catalog");
                    try {
                        wagon.get("archetype-catalog.xml", temp);
                        if (temp.exists() && temp.length() > 0L) {
                            FileUtils.copyFile((File)temp, (File)catalog);
                            temp.delete();
                        }
                    }
                    finally {
                        wagon.disconnect();
                    }
                }
                catch (AuthenticationException ex) {
                    String msg = "Authentication exception connecting to " + repository;
                    throw new IOException(msg, ex);
                }
                catch (WagonException ex) {
                    String msg = "Wagon exception connecting to " + repository;
                    throw new IOException(msg, ex);
                }
                finally {
                    try {
                        wagon.disconnect();
                    }
                    catch (ConnectionException ex) {
                        String msg = "Wagon exception disconnecting from " + repository;
                        throw new IOException(msg, ex);
                    }
                }
            }
            catch (ComponentLookupException ex) {
                LOG.log(Level.FINE, null, ex);
            }
            catch (IOException io) {
                LOG.log(Level.INFO, null, io);
            }
        }
    }
}

