/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.modelcache;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.modelcache.ActiveConfigurationProvider;
import org.netbeans.modules.maven.modelcache.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class MavenProjectCache {
    private static final Logger LOG = Logger.getLogger(MavenProjectCache.class.getName());
    private static final String CONTEXT_EXECUTION_RESULT = "NB_Execution_Result";
    private static final Map<FileObject, WeakReference<MavenProject>> file2Project = new WeakHashMap<FileObject, WeakReference<MavenProject>>();
    private static final Map<FileObject, Mutex> file2Mutex = new WeakHashMap<FileObject, Mutex>();
    private static final Properties statics = new Properties();

    public static MavenProject getMavenProject(final FileObject projectDirectory, final boolean reload) {
        if (projectDirectory.getFileObject("pom.xml") == null) {
            return null;
        }
        Mutex mutex = MavenProjectCache.getMutex(projectDirectory);
        MavenProject mp = (MavenProject)mutex.writeAccess((Mutex.Action)new Mutex.Action<MavenProject>(){

            public MavenProject run() {
                MavenProject mp;
                WeakReference ref;
                if (!reload && (ref = (WeakReference)file2Project.get(projectDirectory)) != null && (mp = (MavenProject)ref.get()) != null) {
                    return mp;
                }
                MavenProject mp2 = MavenProjectCache.loadOriginalMavenProject(projectDirectory);
                file2Project.put(projectDirectory, new WeakReference<MavenProject>(mp2));
                return mp2;
            }
        });
        return mp;
    }

    public static MavenExecutionResult getExecutionResult(MavenProject project) {
        return (MavenExecutionResult)project.getContextValue(CONTEXT_EXECUTION_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    private static MavenProject loadOriginalMavenProject(FileObject projectDirectory) {
        block9: {
            startLoading = System.currentTimeMillis();
            projectEmbedder = EmbedderFactory.getProjectEmbedder();
            newproject = null;
            aux = new M2AuxilaryConfigImpl(projectDirectory);
            config = new ActiveConfigurationProvider(projectDirectory, aux);
            active = config.getActiveConfiguration();
            pomFile = new File(FileUtil.toFile((FileObject)projectDirectory), "pom.xml");
            res = null;
            try {
                req = projectEmbedder.createMavenExecutionRequest();
                req.addActiveProfiles(active.getActivatedProfiles());
                req.setPom(pomFile);
                req.setNoSnapshotUpdates(true);
                req.setUpdateSnapshots(false);
                req.setInteractiveMode(false);
                req.setRecursive(false);
                req.setOffline(true);
                req.setUserProperties(MavenProjectCache.createSystemPropsForProjectLoading(active.getProperties()));
                res = projectEmbedder.readProjectWithDependencies(req, true);
                newproject = res.getProject();
                if (newproject != null) break block9;
            }
            catch (RuntimeException exc) {
                block10: {
                    try {
                        MavenProjectCache.LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + projectDirectory, exc);
                        res = new DefaultMavenExecutionResult();
                        res.addException((Throwable)exc);
                        if (newproject != null) break block10;
                    }
                    catch (Throwable var12_13) {
                        if (newproject == null) {
                            newproject = MavenProjectCache.getFallbackProject(pomFile);
                        }
                        newproject.setContextValue("NB_Execution_Result", res);
                        endLoading = System.currentTimeMillis();
                        MavenProjectCache.LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, projectDirectory.getPath()});
                        if (MavenProjectCache.LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                            MavenProjectCache.LOG.log(Level.FINE, "Project " + projectDirectory.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                        }
                        throw var12_13;
                    }
                    newproject = MavenProjectCache.getFallbackProject(pomFile);
                }
                newproject.setContextValue("NB_Execution_Result", (Object)res);
                endLoading = System.currentTimeMillis();
                MavenProjectCache.LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, projectDirectory.getPath()});
                if (MavenProjectCache.LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                    MavenProjectCache.LOG.log(Level.FINE, "Project " + projectDirectory.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                } else {
                    ** GOTO lbl62
                }
            }
            newproject = MavenProjectCache.getFallbackProject(pomFile);
        }
        newproject.setContextValue("NB_Execution_Result", (Object)res);
        endLoading = System.currentTimeMillis();
        MavenProjectCache.LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, projectDirectory.getPath()});
        if (MavenProjectCache.LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
            MavenProjectCache.LOG.log(Level.FINE, "Project " + projectDirectory.getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
        }
        if (!MavenProjectCache.$assertionsDisabled && newproject == null) {
            throw new AssertionError();
        }
        return newproject;
    }

    public static MavenProject getFallbackProject(File projectFile) throws AssertionError {
        MavenProject newproject = new MavenProject();
        newproject.setGroupId("error");
        newproject.setArtifactId("error");
        newproject.setVersion("0");
        newproject.setPackaging("pom");
        newproject.setName(Bundle.LBL_Incomplete_Project_Name());
        newproject.setDescription(Bundle.LBL_Incomplete_Project_Desc());
        newproject.setFile(projectFile);
        return newproject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties cloneStaticProps() {
        Properties properties = statics;
        synchronized (properties) {
            if (statics.isEmpty()) {
                statics.setProperty("netbeans.execution", "true");
                EmbedderFactory.fillEnvVars((Properties)statics);
                statics.putAll((Map<?, ?>)AbstractMavenExecutor.excludeNetBeansProperties(System.getProperties()));
            }
            Properties toRet = new Properties();
            toRet.putAll((Map<?, ?>)statics);
            return toRet;
        }
    }

    public static Properties createSystemPropsForProjectLoading(Map<String, String> activeConfiguration) {
        Properties props = MavenProjectCache.cloneStaticProps();
        if (activeConfiguration != null) {
            props.putAll(activeConfiguration);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mutex getMutex(FileObject projectDirectory) {
        Map<FileObject, Mutex> map = file2Mutex;
        synchronized (map) {
            Mutex mutex = file2Mutex.get(projectDirectory);
            if (mutex != null) {
                return mutex;
            }
            mutex = new Mutex();
            file2Mutex.put(projectDirectory, mutex);
            return mutex;
        }
    }
}

