/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.modelcache;

import java.util.Collections;
import java.util.SortedSet;
import org.netbeans.modules.maven.configurations.ConfigurationPersistenceUtils;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;

public class ActiveConfigurationProvider {
    private final AuxiliaryConfiguration aux;
    private final FileObject projectDirectory;

    public ActiveConfigurationProvider(FileObject projectDirectory, AuxiliaryConfiguration aux) {
        this.aux = aux;
        this.projectDirectory = projectDirectory;
    }

    public M2Configuration getActiveConfiguration() {
        String active = ConfigurationPersistenceUtils.readActiveConfigurationName(this.aux);
        if (active == null) {
            return M2Configuration.createDefault(this.projectDirectory);
        }
        SortedSet<M2Configuration> configs = ConfigurationPersistenceUtils.readConfigurations(this.aux, this.projectDirectory, true);
        for (M2Configuration c : configs) {
            if (!c.getId().equals(active)) continue;
            return c;
        }
        configs = ConfigurationPersistenceUtils.readConfigurations(this.aux, this.projectDirectory, false);
        for (M2Configuration c : configs) {
            if (!c.getId().equals(active)) continue;
            return c;
        }
        M2Configuration toRet = new M2Configuration(active, this.projectDirectory);
        toRet.setActivatedProfiles(Collections.singletonList(active));
        return toRet;
    }
}

