/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public abstract class OutputTabMaintainer<TabContext> {
    private static final Map<InputOutput, AllContext<?>> freeTabs = new WeakHashMap();
    protected InputOutput io;
    private final String name;

    protected abstract Class<TabContext> tabContextType();

    protected OutputTabMaintainer(String name) {
        assert (name != null);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markFreeTab() {
        Map<InputOutput, AllContext<?>> map = freeTabs;
        synchronized (map) {
            assert (this.io != null);
            freeTabs.put(this.io, new AllContext<TabContext>(this.name, this.tabContextType(), this.createContext()));
        }
    }

    protected abstract void reassignAdditionalContext(TabContext var1);

    protected abstract TabContext createContext();

    protected Action[] createNewTabActions() {
        return new Action[0];
    }

    public final InputOutput getInputOutput() {
        if (this.io == null) {
            this.io = this.createInputOutput();
        }
        return this.io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final InputOutput createInputOutput() {
        Map<InputOutput, AllContext<?>> map = freeTabs;
        synchronized (map) {
            for (Map.Entry<InputOutput, AllContext<?>> entry : freeTabs.entrySet()) {
                InputOutput free = entry.getKey();
                AllContext<?> allContext = entry.getValue();
                if (this.io == null && allContext.name.equals(this.name) && allContext.tabContextType == this.tabContextType()) {
                    this.io = free;
                    this.reassignAdditionalContext(this.tabContextType().cast(allContext.tabContext));
                    try {
                        this.io.getOut().reset();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                free.closeInputOutput();
            }
            freeTabs.clear();
        }
        if (this.io == null) {
            this.io = IOProvider.getDefault().getIO(this.name, this.createNewTabActions());
            this.io.setInputVisible(true);
        }
        return this.io;
    }

    private static class AllContext<TabContext> {
        final String name;
        final Class<TabContext> tabContextType;
        final TabContext tabContext;

        AllContext(String name, Class<TabContext> tabContextType, TabContext tabContext) {
            this.name = name;
            this.tabContextType = tabContextType;
            this.tabContext = tabContext;
        }
    }
}

