/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NbGlobalActionGoalProvider
extends AbstractMavenActionsProvider {
    public static final String FILENAME = "Projects/org-netbeans-modules-maven/nbactions.xml";
    private static final Logger LOG = Logger.getLogger(NbGlobalActionGoalProvider.class.getName());
    private Date lastModified = new Date();
    private boolean lastTimeExists = true;

    @Override
    public InputStream getActionDefinitionStream() {
        FileObject fo = FileUtil.getConfigFile((String)FILENAME);
        boolean bl = this.lastTimeExists = fo != null;
        if (fo != null) {
            try {
                this.lastModified = fo.lastModified();
                return fo.getInputStream();
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.FINE, "File not found: " + FileUtil.getFileDisplayName((FileObject)fo), ex);
            }
        }
        this.lastModified = new Date();
        return null;
    }

    public NetbeansActionMapping[] getCustomMappings() {
        NetbeansActionMapping[] fallbackActions = new NetbeansActionMapping[]{};
        try {
            ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
            Reader read = this.performDynamicSubstitutions(Collections.<String, String>emptyMap(), this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            List<NetbeansActionMapping> lst = mapping.getActions();
            if (lst != null) {
                for (NetbeansActionMapping mapp : lst) {
                    if (!mapp.getActionName().startsWith("CUSTOM-")) continue;
                    toRet.add(mapp);
                }
            }
            return toRet.toArray(new NetbeansActionMapping[toRet.size()]);
        }
        catch (XmlPullParserException ex) {
            LOG.log(Level.FINE, "cannot parse", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "", ex);
        }
        return fallbackActions;
    }

    @Override
    protected boolean reloadStream() {
        FileObject fo = FileUtil.getConfigFile((String)FILENAME);
        boolean prevExists = this.lastTimeExists;
        this.lastTimeExists = fo != null;
        return fo == null && prevExists || fo != null && fo.lastModified().after(this.lastModified);
    }
}

