/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.debug.JPDAStart;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbCollections;
import org.openide.windows.OutputWriter;

public class DebuggerChecker
implements LateBoundPrerequisitesChecker,
ExecutionResultChecker,
PrerequisitesChecker {
    private static final String ARGLINE = "argLine";
    private static final String MAVENSUREFIREDEBUG = "maven.surefire.debug";
    private static final Logger LOGGER = Logger.getLogger(DebuggerChecker.class.getName());

    @Override
    public boolean checkRunConfig(RunConfig config) {
        if (config.getProject() == null) {
            return true;
        }
        boolean debug = "true".equalsIgnoreCase(config.getProperties().get("jpda.listen"));
        if (debug && "debug.test.single".equalsIgnoreCase(config.getActionName()) && config.getGoals().contains("surefire:test")) {
            String newArgs = config.getProperties().get(MAVENSUREFIREDEBUG);
            String oldArgs = config.getProperties().get(ARGLINE);
            String ver = PluginPropertyUtils.getPluginVersion(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin");
            if (ver == null) {
                ver = "2.4";
            }
            DefaultArtifactVersion twopointfour = new DefaultArtifactVersion("2.4");
            DefaultArtifactVersion current = new DefaultArtifactVersion(ver);
            int compare = current.compareTo((Object)twopointfour);
            if (oldArgs != null && newArgs == null && compare >= 0) {
                config.setProperty(MAVENSUREFIREDEBUG, oldArgs);
                config.setProperty(ARGLINE, null);
            }
            if (newArgs != null && compare < 0) {
                oldArgs = (oldArgs == null ? "" : oldArgs) + " " + newArgs;
                config.setProperty(ARGLINE, oldArgs);
                config.setProperty(MAVENSUREFIREDEBUG, null);
            }
        }
        return true;
    }

    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext context) {
        if (config.getProject() == null) {
            return true;
        }
        boolean debug = "true".equalsIgnoreCase(config.getProperties().get("jpda.listen"));
        boolean mavenDebug = "maven".equalsIgnoreCase(config.getProperties().get("jpda.listen"));
        if (debug || mavenDebug) {
            String key = "Env.MAVEN_OPTS";
            if (mavenDebug) {
                String vmargs = "-Xdebug -Xrunjdwp:transport=dt_socket,server=n,address=${jpda.address}";
                String orig = config.getProperties().get(key);
                if (orig == null) {
                    orig = System.getenv("MAVEN_OPTS");
                }
                config.setProperty(key, orig != null ? orig + ' ' + vmargs : vmargs);
            }
            try {
                JPDAStart start = new JPDAStart(context.getInputOutput());
                NbMavenProject prj = (NbMavenProject)config.getProject().getLookup().lookup(NbMavenProject.class);
                start.setName(prj.getMavenProject().getArtifactId());
                start.setStopClassName(config.getProperties().get("jpda.stopclass"));
                String val = start.execute(config.getProject());
                for (Map.Entry entry : NbCollections.checkedMapByFilter(config.getProperties(), String.class, String.class, (boolean)true).entrySet()) {
                    StringBuilder buf = new StringBuilder((String)entry.getValue());
                    String replaceItem = "${jpda.address}";
                    int index = buf.indexOf(replaceItem);
                    while (index > -1) {
                        String newItem = val;
                        newItem = newItem == null ? "" : newItem;
                        buf.replace(index, index + replaceItem.length(), newItem);
                        index = buf.indexOf(replaceItem);
                    }
                    config.setProperty((String)entry.getKey(), buf.toString());
                }
                config.setProperty("jpda.address", val);
            }
            catch (Throwable th) {
                LOGGER.log(Level.INFO, th.getMessage(), th);
            }
        }
        if ("debug.stepinto".equals(config.getActionName())) {
            // empty if block
        }
        return true;
    }

    @Override
    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        if (config.getProject() != null && resultCode == 0 && "debug.fix".equals(config.getActionName())) {
            String cname = config.getProperties().get("jpda.stopclass");
            if (cname != null) {
                this.reload(config.getProject(), res.getInputOutput().getOut(), cname);
            } else {
                res.getInputOutput().getErr().println("Missing jpda.stopclass property in action mapping definition. Cannot reload class.");
            }
        }
    }

    public void reload(Project project, OutputWriter logger, String classname) {
        ClassPath cp;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            logger.println("NetBeans: No debugging sessions was found.");
            return;
        }
        JPDADebugger debugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            logger.println("NetBeans: Current debugger is not JPDA one.");
            return;
        }
        if (!debugger.canFixClasses()) {
            logger.println("NetBeans: The debugger does not support Fix action.");
            return;
        }
        if (debugger.getState() == 4) {
            logger.println("NetBeans: The debugger is not running");
            return;
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        EditorContext editorContext = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
        String clazz = classname.replace('.', '/') + ".class";
        ProjectSourcesClassPathProvider prv = (ProjectSourcesClassPathProvider)project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        ClassPath[] ccp = prv.getProjectClassPaths("classpath/compile");
        FileObject fo2 = null;
        ClassPath[] arr$ = ccp;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fo2 = (cp = arr$[i$]).findResource(clazz)) == null; ++i$) {
        }
        if (fo2 != null) {
            try {
                String basename = fo2.getName();
                for (FileObject classfile : fo2.getParent().getChildren()) {
                    String basename2 = classfile.getName();
                    if (!basename2.equals(basename) && !basename2.startsWith(basename + '$')) continue;
                    String url = this.classToSourceURL(classfile, logger);
                    if (url != null) {
                        editorContext.updateTimeStamp((Object)debugger, url);
                    }
                    map.put(classname + basename2.substring(basename.length()), classfile.asBytes());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        logger.println("NetBeans: classes to reload: " + map.keySet());
        if (map.isEmpty()) {
            logger.println("NetBeans: No class to reload");
            return;
        }
        String error = null;
        try {
            debugger.fixClasses(map);
        }
        catch (UnsupportedOperationException uoex) {
            error = "The virtual machine does not support this operation: " + uoex.getLocalizedMessage();
        }
        catch (NoClassDefFoundError ncdfex) {
            error = "The bytes don't correspond to the class type (the names don't match): " + ncdfex.getLocalizedMessage();
        }
        catch (VerifyError ver) {
            error = "A \"verifier\" detects that a class, though well formed, contains an internal inconsistency or security problem: " + ver.getLocalizedMessage();
        }
        catch (UnsupportedClassVersionError ucver) {
            error = "The major and minor version numbers in bytes are not supported by the VM. " + ucver.getLocalizedMessage();
        }
        catch (ClassFormatError cfer) {
            error = "The bytes do not represent a valid class. " + cfer.getLocalizedMessage();
        }
        catch (ClassCircularityError ccer) {
            error = "A circularity has been detected while initializing a class: " + ccer.getLocalizedMessage();
        }
        if (error != null) {
            logger.println("NetBeans:" + error);
        }
    }

    private String classToSourceURL(FileObject fo, OutputWriter logger) {
        FileObject[] sRoots;
        ClassPath sourcePath;
        FileObject rfo;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
        if (cp == null) {
            return null;
        }
        FileObject root = cp.findOwnerRoot(fo);
        String resourceName = cp.getResourceName(fo, '/', false);
        if (resourceName == null) {
            logger.println("Can not find classpath resource for " + fo + ", skipping...");
            return null;
        }
        int i = resourceName.indexOf(36);
        if (i > 0) {
            resourceName = resourceName.substring(0, i);
        }
        if ((rfo = (sourcePath = ClassPathSupport.createClassPath((FileObject[])(sRoots = SourceForBinaryQuery.findSourceRoots((URL)root.toURL()).getRoots()))).findResource(resourceName + ".java")) == null) {
            return null;
        }
        return rfo.toURL().toExternalForm();
    }
}

